/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IViewCellStorage;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartItem;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.util.IConfigManager;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.parts.reporting.AbstractDisplayPart;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3917;

public abstract class AbstractTerminalPart
extends AbstractDisplayPart
implements ITerminalHost,
IViewCellStorage,
InternalInventoryHost {
    private final IConfigManager cm = new ConfigManager();
    private final AppEngInternalInventory viewCell = new AppEngInternalInventory(this, 5);

    public AbstractTerminalPart(IPartItem<?> partItem) {
        super(partItem, true);
        this.cm.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.cm.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
    }

    @Override
    public void addAdditionalDrops(List<class_1799> drops, boolean wrenched) {
        for (class_1799 is : this.viewCell) {
            if (is.method_7960()) continue;
            drops.add(is);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void saveChanges() {
        this.getHost().markForSave();
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.cm.readFromNBT(data);
        this.viewCell.readFromNBT(data, "viewCell");
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        this.cm.writeToNBT(data);
        this.viewCell.writeToNBT(data, "viewCell");
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (!super.onPartActivate(player, hand, pos) && !player.field_6002.field_9236) {
            MenuOpener.open(this.getMenuType(player), player, MenuLocators.forPart(this));
        }
        return true;
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.open(this.getMenuType(player), player, subMenu.getLocator());
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return new class_1799(this.getPartItem());
    }

    public class_3917<?> getMenuType(class_1657 player) {
        return MEStorageMenu.TYPE;
    }

    @Override
    public MEStorage getInventory() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            return grid.getStorageService().getInventory();
        }
        return null;
    }

    @Override
    public InternalInventory getViewCellStorage() {
        return this.viewCell;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.getHost().markForSave();
    }
}

