/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.items.parts.PartModels;
import appeng.me.service.EnergyService;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;

public class QuartzFiberPart
extends AEBasePart {
    @PartModels
    private static final IPartModel MODELS = new PartModel(new class_2960("ae2", "part/quartz_fiber"));
    private final IManagedGridNode outerNode;

    public QuartzFiberPart(IPartItem<?> partItem) {
        super(partItem);
        GridBridgeProvider energyBridge = new GridBridgeProvider();
        this.getMainNode().setIdlePowerUsage(0.0).setFlags(GridFlags.CANNOT_CARRY).addService(IEnergyGridProvider.class, energyBridge);
        this.outerNode = GridHelper.createManagedNode(this, AEBasePart.NodeListener.INSTANCE).setTagName("outer").setIdlePowerUsage(0.0).setVisualRepresentation(partItem).setFlags(GridFlags.CANNOT_CARRY).setInWorldNode(true).addService(IEnergyGridProvider.class, energyBridge);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
    }

    @Override
    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.outerNode.loadFromNBT(extra);
    }

    @Override
    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.outerNode.saveToNBT(extra);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerNode.destroy();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerNode.create(this.getLevel(), this.getBlockEntity().method_11016());
    }

    @Override
    public void setPartHostInfo(class_2350 side, IPartHost host, class_2586 blockEntity) {
        super.setPartHostInfo(side, host, blockEntity);
        this.outerNode.setExposedOnSides(EnumSet.of(side));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerNode.getNode();
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    @Override
    public void onPlacement(class_1657 player) {
        super.onPlacement(player);
        this.outerNode.setOwningPlayer(player);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS;
    }

    private class GridBridgeProvider
    implements IEnergyGridProvider {
        private GridBridgeProvider() {
        }

        @Override
        public Collection<IEnergyGridProvider> providers() {
            ArrayList<IEnergyGridProvider> providers = new ArrayList<IEnergyGridProvider>(2);
            QuartzFiberPart.this.getMainNode().ifPresent(grid -> {
                EnergyService eg = (EnergyService)grid.getEnergyService();
                providers.add(eg);
            });
            QuartzFiberPart.this.outerNode.ifPresent(grid -> {
                EnergyService eg = (EnergyService)grid.getEnergyService();
                providers.add(eg);
            });
            return providers;
        }

        @Override
        public double extractProviderPower(double amt, Actionable mode) {
            return 0.0;
        }

        @Override
        public double injectProviderPower(double amt, Actionable mode) {
            return amt;
        }

        @Override
        public double getProviderEnergyDemand(double amt) {
            return 0.0;
        }

        @Override
        public double getProviderStoredEnergy() {
            return 0.0;
        }

        @Override
        public double getProviderMaxEnergy() {
            return 0.0;
        }
    }
}

