/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.parts.ICablePart;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.pathing.ChannelMode;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.core.definitions.AEParts;
import appeng.items.parts.ColoredPartItem;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.parts.AEBasePart;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2540;

public class CablePart
extends AEBasePart
implements ICablePart {
    private static final IGridNodeListener<CablePart> NODE_LISTENER = new AEBasePart.NodeListener<CablePart>(){

        @Override
        public void onInWorldConnectionChanged(CablePart nodeOwner, IGridNode node) {
            super.onInWorldConnectionChanged(nodeOwner, node);
            nodeOwner.markForUpdate();
        }
    };
    private final int[] channelsOnSide = new int[]{0, 0, 0, 0, 0, 0};
    private Set<class_2350> connections = Collections.emptySet();
    private boolean powered = false;

    public CablePart(ColoredPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.PREFERRED).setIdlePowerUsage(0.0).setInWorldNode(true).setExposedOnSides(EnumSet.allOf(class_2350.class));
        this.getMainNode().setGridColor(partItem.getColor());
    }

    @Override
    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode(this, NODE_LISTENER);
    }

    @Override
    public BusSupport supportsBuses() {
        return BusSupport.CABLE;
    }

    @Override
    public AEColor getCableColor() {
        IPartItem<?> iPartItem = this.getPartItem();
        if (iPartItem instanceof ColoredPartItem) {
            ColoredPartItem coloredPartItem = (ColoredPartItem)iPartItem;
            return coloredPartItem.getColor();
        }
        return AEColor.TRANSPARENT;
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.GLASS;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        if (cable == this.getCableConnectionType()) {
            return 4.0f;
        }
        if (cable.ordinal() >= this.getCableConnectionType().ordinal()) {
            return -1.0f;
        }
        return 8.0f;
    }

    @Override
    public void onPlacement(class_1657 player) {
        ColorApplicatorItem item;
        AEColor color;
        class_1792 class_17922;
        super.onPlacement(player);
        class_1799 stack = player.method_5998(class_1268.field_5810);
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof ColorApplicatorItem && (color = (item = (ColorApplicatorItem)class_17922).getActiveColor(stack)) != null && color != this.getCableColor() && item.consumeColor(stack, color, true) && this.changeColor(color, player) && !player.method_31549().field_7477) {
            item.consumeColor(stack, color, false);
        }
    }

    @Override
    public boolean changeColor(AEColor newColor, class_1657 who) {
        if (this.getCableColor() != newColor) {
            IPartItem newPart = null;
            if (this.getCableConnectionType() == AECableType.GLASS) {
                newPart = AEParts.GLASS_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.COVERED) {
                newPart = AEParts.COVERED_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.SMART) {
                newPart = AEParts.SMART_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.DENSE_COVERED) {
                newPart = AEParts.COVERED_DENSE_CABLE.item(newColor);
            } else if (this.getCableConnectionType() == AECableType.DENSE_SMART) {
                newPart = AEParts.SMART_DENSE_CABLE.item(newColor);
            }
            boolean hasPermission = true;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                hasPermission = grid.getSecurityService().hasPermission(who, SecurityPermissions.BUILD);
            }
            if (newPart != null && hasPermission) {
                if (this.isClientSide()) {
                    return true;
                }
                this.setPartItem(newPart);
                this.getMainNode().setGridColor(this.getCableColor());
                this.getHost().markForUpdate();
                this.getHost().markForSave();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setExposedOnSides(EnumSet<class_2350> sides) {
        this.getMainNode().setExposedOnSides(sides);
    }

    @Override
    public boolean isConnected(class_2350 side) {
        return this.getConnections().contains(side);
    }

    public void markForUpdate() {
        this.getHost().markForUpdate();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.updateConnections();
        bch.addBox(6.0, 6.0, 6.0, 10.0, 10.0, 10.0);
        IPartHost ph = this.getHost();
        if (ph != null) {
            block16: for (class_2350 dir : class_2350.values()) {
                float dist;
                IPart p = ph.getPart(dir);
                if (p == null || (dist = p.getCableConnectionLength(this.getCableConnectionType())) > 8.0f) continue;
                switch (dir) {
                    case field_11033: {
                        bch.addBox(6.0, dist, 6.0, 10.0, 6.0, 10.0);
                        continue block16;
                    }
                    case field_11034: {
                        bch.addBox(10.0, 6.0, 6.0, 16.0 - (double)dist, 10.0, 10.0);
                        continue block16;
                    }
                    case field_11043: {
                        bch.addBox(6.0, 6.0, dist, 10.0, 10.0, 6.0);
                        continue block16;
                    }
                    case field_11035: {
                        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0 - (double)dist);
                        continue block16;
                    }
                    case field_11036: {
                        bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0 - (double)dist, 10.0);
                        continue block16;
                    }
                    case field_11039: {
                        bch.addBox(dist, 6.0, 6.0, 6.0, 10.0, 10.0);
                        continue block16;
                    }
                }
            }
        }
        for (class_2350 of : this.getConnections()) {
            switch (of) {
                case field_11033: {
                    bch.addBox(6.0, 0.0, 6.0, 10.0, 6.0, 10.0);
                    break;
                }
                case field_11034: {
                    bch.addBox(10.0, 6.0, 6.0, 16.0, 10.0, 10.0);
                    break;
                }
                case field_11043: {
                    bch.addBox(6.0, 6.0, 0.0, 10.0, 10.0, 6.0);
                    break;
                }
                case field_11035: {
                    bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
                    break;
                }
                case field_11036: {
                    bch.addBox(6.0, 10.0, 6.0, 10.0, 16.0, 10.0);
                    break;
                }
                case field_11039: {
                    bch.addBox(0.0, 6.0, 6.0, 6.0, 10.0, 10.0);
                    break;
                }
            }
        }
    }

    protected void updateConnections() {
        if (!this.isClientSide()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.setConnections(n.getConnectedSides());
            } else {
                this.setConnections(Collections.emptySet());
            }
        }
    }

    @Override
    public void writeToStream(class_2540 data) {
        int flags = 0;
        boolean[] writeSide = new boolean[class_2350.values().length];
        byte[] channelsPerSide = new byte[class_2350.values().length];
        for (class_2350 thisSide : class_2350.values()) {
            IPart part = this.getHost().getPart(thisSide);
            if (part == null) continue;
            writeSide[thisSide.ordinal()] = true;
            int channels = 0;
            if (part.getGridNode() != null) {
                for (IGridConnection gc : part.getGridNode().getConnections()) {
                    channels = Math.max(channels, gc.getUsedChannels());
                }
            }
            channelsPerSide[thisSide.ordinal()] = this.getVisualChannels(channels);
        }
        IGridNode n = this.getGridNode();
        if (n != null) {
            for (Map.Entry<class_2350, IGridConnection> entry : n.getInWorldConnections().entrySet()) {
                int side = entry.getKey().ordinal();
                writeSide[side] = true;
                IGridConnection connection = entry.getValue();
                channelsPerSide[side] = this.getVisualChannels(connection.getUsedChannels());
                flags |= 1 << side;
            }
            if (n.isPowered()) {
                flags |= 1 << class_2350.values().length;
            }
        }
        data.writeByte((int)((byte)flags));
        for (int i = 0; i < writeSide.length; ++i) {
            if (!writeSide[i]) continue;
            data.writeByte((int)channelsPerSide[i]);
        }
    }

    private byte getVisualChannels(int channels) {
        byte visualMaxChannels;
        IGridNode node = this.getGridNode();
        if (node == null) {
            return 0;
        }
        switch (this.getCableConnectionType()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                byte by = 0;
                break;
            }
            case GLASS: 
            case SMART: 
            case COVERED: {
                byte by = 8;
                break;
            }
            case DENSE_COVERED: 
            case DENSE_SMART: {
                byte by = visualMaxChannels = 32;
            }
        }
        if (node.getGrid().getPathingService().getChannelMode() == ChannelMode.INFINITE) {
            return channels <= 0 ? (byte)0 : visualMaxChannels;
        }
        int gridMaxChannels = node.getMaxChannels();
        if (visualMaxChannels == 0 || gridMaxChannels == 0) {
            return 0;
        }
        byte result = (byte)Math.min(visualMaxChannels, channels * visualMaxChannels / gridMaxChannels);
        if (result == 0 && channels > 0) {
            return 1;
        }
        return result;
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        byte cs = data.readByte();
        Set<class_2350> previousConnections = this.getConnections();
        boolean wasPowered = this.powered;
        boolean channelsChanged = false;
        this.powered = (cs & 1 << class_2350.values().length) != 0;
        EnumSet<class_2350> connections = EnumSet.noneOf(class_2350.class);
        for (class_2350 d : class_2350.values()) {
            boolean conOnSide;
            boolean bl = conOnSide = (cs & 1 << d.ordinal()) != 0;
            if (conOnSide) {
                connections.add(d);
            }
            int ch = 0;
            if (conOnSide || this.getHost().getPart(d) != null) {
                ch = data.readByte() & 0xFF;
            }
            if (ch == this.getChannelsOnSide(d.ordinal())) continue;
            channelsChanged = true;
            this.setChannelsOnSide(d.ordinal(), ch);
        }
        this.setConnections(connections);
        return !previousConnections.equals(this.getConnections()) || wasPowered != this.powered || channelsChanged;
    }

    int getChannelsOnSide(int i) {
        return this.channelsOnSide[i];
    }

    public int getChannelsOnSide(class_2350 side) {
        if (!this.powered) {
            return 0;
        }
        return this.channelsOnSide[side.ordinal()];
    }

    void setChannelsOnSide(int i, int channels) {
        this.channelsOnSide[i] = channels;
    }

    Set<class_2350> getConnections() {
        return this.connections;
    }

    void setConnections(Set<class_2350> connections) {
        this.connections = connections;
    }
}

