/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PlacementStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.FormationPlaneMenu;
import appeng.menu.locator.MenuLocators;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModels;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.ConfigInventory;
import appeng.util.prioritylist.IPartitionList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3917;

public class FormationPlanePart
extends UpgradeablePart
implements IStorageProvider,
IPriorityHost,
IConfigInvHost {
    private static final PlaneModels MODELS = new PlaneModels("part/formation_plane", "part/formation_plane_on");
    private boolean wasActive = false;
    private int priority = 0;
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper(this);
    private final MEStorage inventory = new InWorldStorage();
    private final ConfigInventory config;
    @Nullable
    private PlacementStrategy placementStrategies;
    private IncludeExclude filterMode = IncludeExclude.WHITELIST;
    private IPartitionList filter;

    public FormationPlanePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IStorageProvider.class, this);
        this.config = ConfigInventory.configTypes(StackWorldBehaviors.hasPlacementStrategy(), 63, this::updateFilter);
        this.getConfigManager().registerSetting(Settings.PLACE_BLOCK, YesNo.YES);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
    }

    protected final PlacementStrategy getPlacementStrategies() {
        if (this.placementStrategies == null) {
            class_2586 self = this.getHost().getBlockEntity();
            class_2338 pos = self.method_11016().method_10093(this.getSide());
            class_2350 side = this.getSide().method_10153();
            this.placementStrategies = StackWorldBehaviors.createPlacementStrategies((class_3218)self.method_10997(), pos, side, self);
        }
        return this.placementStrategies;
    }

    protected final void updateFilter() {
        this.filter = this.createFilter();
        this.filterMode = this.isUpgradedWith(AEItems.INVERTER_CARD) ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
    }

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public void upgradesChanged() {
        this.updateFilter();
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.getHost().markForSave();
    }

    public void stateChanged() {
        boolean currentActive = this.getMainNode().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.remountStorage();
            this.getHost().markForUpdate();
        }
    }

    private void remountStorage() {
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    @Override
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.stateChanged();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    @Override
    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide()).equals((Object)neighbor)) {
            if (!this.isClientSide()) {
                this.getPlacementStrategies().clearBlocked();
            }
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    protected long placeInWorld(AEKey what, long amount, Actionable type) {
        YesNo placeBlock = this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        return this.getPlacementStrategies().placeInWorld(what, amount, type, placeBlock != YesNo.YES);
    }

    public boolean supportsEntityPlacement() {
        for (int i = 0; i < this.config.size(); ++i) {
            if (!AEItemKey.is(this.config.getKey(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.priority = data.method_10550("priority");
        this.config.readFromChildTag(data, "config");
        this.remountStorage();
    }

    @Override
    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10569("priority", this.getPriority());
        this.config.writeToChildTag(data, "config");
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.remountStorage();
    }

    @Override
    public void mountInventories(IStorageMounts mounts) {
        if (this.getMainNode().isActive()) {
            this.updateFilter();
            mounts.mount(this.inventory, this.priority);
        }
    }

    @Override
    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        this.openConfigMenu(player);
    }

    @Override
    public class_1799 getMainMenuIcon() {
        return new class_1799(this.getPartItem());
    }

    private void openConfigMenu(class_1657 player) {
        MenuOpener.open(this.getMenuType(), player, MenuLocators.forPart(this));
    }

    protected class_3917<?> getMenuType() {
        return FormationPlaneMenu.TYPE;
    }

    private IPartitionList createFilter() {
        IPartitionList.Builder builder = IPartitionList.builder();
        if (this.isUpgradedWith(AEItems.FUZZY_CARD)) {
            builder.fuzzyMode(this.getConfigManager().getSetting(Settings.FUZZY_MODE));
        }
        int slotsToUse = 18 + this.getInstalledUpgrades(AEItems.CAPACITY_CARD) * 9;
        for (int x = 0; x < this.config.size() && x < slotsToUse; ++x) {
            builder.add(this.config.getKey(x));
        }
        return builder.build();
    }

    @Override
    public boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    @Override
    public ConfigInventory getConfig() {
        return this.config;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public Object getRenderAttachmentData() {
        return this.getConnections();
    }

    class InWorldStorage
    implements MEStorage {
        InWorldStorage() {
        }

        @Override
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (FormationPlanePart.this.filter != null && !FormationPlanePart.this.filter.matchesFilter(what, FormationPlanePart.this.filterMode)) {
                return 0L;
            }
            return FormationPlanePart.this.placeInWorld(what, amount, mode);
        }

        @Override
        public class_2561 getDescription() {
            return FormationPlanePart.this.getPartItem().method_8389().method_7848();
        }
    }
}

