/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PickupStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.parts.BasicStatePart;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModels;
import appeng.parts.automation.StackWorldBehaviors;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public class AnnihilationPlanePart
extends BasicStatePart
implements IGridTickable {
    private static final PlaneModels MODELS = new PlaneModels("part/annihilation_plane", "part/annihilation_plane_on");
    private final IActionSource actionSource = new MachineSource(this);
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper(this);
    @Nullable
    private List<PickupStrategy> pickupStrategies;
    private PickupStrategy pendingPickupStrategy;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public AnnihilationPlanePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, this);
    }

    private List<PickupStrategy> getPickupStrategies() {
        if (this.pickupStrategies == null) {
            class_2586 self = this.getHost().getBlockEntity();
            class_2338 pos = self.method_11016().method_10093(this.getSide());
            class_2350 side = this.getSide().method_10153();
            this.pickupStrategies = StackWorldBehaviors.createPickupStrategies((class_3218)self.method_10997(), pos, side, self, this.allowsSilkTouch());
        }
        return this.pickupStrategies;
    }

    protected boolean allowsSilkTouch() {
        return false;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        if (bch.isBBCollision()) {
            bch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 15.5);
            return;
        }
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    @Override
    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide()).equals((Object)neighbor)) {
            if (!this.isClientSide()) {
                this.refresh();
            }
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    @Override
    public void onEntityCollision(class_1297 entity) {
        boolean capture;
        if (!entity.method_5805() || this.isClientSide() || !this.getMainNode().isActive()) {
            return;
        }
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        PickupStrategy strategy = null;
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            if (!pickupStrategy.canPickUpEntity(entity)) continue;
            strategy = pickupStrategy;
            break;
        }
        if (strategy == null) {
            return;
        }
        class_2338 pos = this.getHost().getBlockEntity().method_11016();
        int planePosX = pos.method_10263();
        int planePosY = pos.method_10264();
        int planePosZ = pos.method_10260();
        double posYMiddle = (entity.method_5829().field_1322 + entity.method_5829().field_1325) / 2.0;
        double entityPosX = entity.method_23317();
        double entityPosY = entity.method_23318();
        double entityPosZ = entity.method_23321();
        boolean captureX = entityPosX > (double)planePosX && entityPosX < (double)(planePosX + 1);
        boolean captureY = posYMiddle > (double)planePosY && posYMiddle < (double)(planePosY + 1);
        boolean captureZ = entityPosZ > (double)planePosZ && entityPosZ < (double)(planePosZ + 1);
        switch (this.getSide()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case field_11033: {
                boolean bl;
                if (captureX && captureZ && entityPosY < (double)planePosY + 0.1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_11036: {
                boolean bl;
                if (captureX && captureZ && entityPosY > (double)planePosY + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_11035: {
                boolean bl;
                if (captureX && captureY && entityPosZ > (double)planePosZ + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_11043: {
                boolean bl;
                if (captureX && captureY && entityPosZ < (double)planePosZ + 0.1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_11034: {
                boolean bl;
                if (captureZ && captureY && entityPosX > (double)planePosX + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case field_11039: {
                boolean bl = capture = captureZ && captureY && entityPosX < (double)planePosX + 0.1;
            }
        }
        if (capture && !strategy.pickUpEntity(grid.getEnergyService(), this::insertIntoGrid, entity)) {
            this.getMainNode().ifPresent((g, n) -> g.getTickManager().alertDevice((IGridNode)n));
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.refresh();
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        IGrid grid = node.getGrid();
        if (this.pendingPickupStrategy != null) {
            this.pendingPickupStrategy.completePickup(grid.getEnergyService(), this::insertIntoGrid);
            this.pendingPickupStrategy = null;
        }
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            pickupStrategy.reset();
        }
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            PickupStrategy.Result pickupResult = pickupStrategy.tryStartPickup(grid.getEnergyService(), this::insertIntoGrid);
            if (pickupResult == PickupStrategy.Result.PICKED_UP) {
                this.pendingPickupStrategy = pickupStrategy;
                return TickRateModulation.URGENT;
            }
            if (pickupResult != PickupStrategy.Result.CANT_STORE) continue;
            return TickRateModulation.IDLE;
        }
        return TickRateModulation.SLEEP;
    }

    private void refresh() {
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            pickupStrategy.reset();
        }
        this.getMainNode().ifPresent((g, n) -> g.getTickManager().alertDevice((IGridNode)n));
    }

    private long insertIntoGrid(AEKey what, long amount, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return 0L;
        }
        return StorageHelper.poweredInsert(grid.getEnergyService(), grid.getStorageService().getInventory(), what, amount, this.actionSource, mode);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public Object getRenderAttachmentData() {
        return this.getConnections();
    }
}

