/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.parts.IPartItem;
import appeng.parts.AEBasePart;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.class_2540;

public abstract class BasicStatePart
extends AEBasePart
implements IPowerChannelState {
    protected static final int POWERED_FLAG = 1;
    protected static final int CHANNEL_FLAG = 2;
    private int clientFlags = 0;

    public BasicStatePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @Override
    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode(this, AEBasePart.NodeListener.INSTANCE);
    }

    @Override
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (this.calculateClientFlags() != this.getClientFlags()) {
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        int flags = this.calculateClientFlags();
        this.setClientFlags(flags);
        data.writeByte((int)((byte)flags));
    }

    @OverridingMethodsMustInvokeSuper
    protected int calculateClientFlags() {
        int flags = 0;
        IGridNode node = this.getMainNode().getNode();
        if (node != null) {
            if (node.isPowered()) {
                flags |= 1;
            }
            if (node.meetsChannelRequirements()) {
                flags |= 2;
            }
        }
        return flags;
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean eh = super.readFromStream(data);
        int old = this.getClientFlags();
        this.setClientFlags(data.readByte());
        return eh || old != this.getClientFlags();
    }

    @Override
    public boolean isPowered() {
        return (this.getClientFlags() & 1) == 1;
    }

    @Override
    public boolean isActive() {
        return (this.getClientFlags() & 2) == 2;
    }

    public int getClientFlags() {
        return this.clientFlags;
    }

    private void setClientFlags(int clientFlags) {
        this.clientFlags = clientFlags;
    }
}

