/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.features.Locatables;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.helpers.WirelessTerminalMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.util.ConfigManager;
import java.util.List;
import java.util.OptionalLong;
import java.util.function.DoubleSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class WirelessTerminalItem
extends AEBasePoweredItem
implements IMenuItem,
IUpgradeableItem {
    public static final IGridLinkableHandler LINKABLE_HANDLER = new LinkableHandler();
    private static final String TAG_GRID_KEY = "gridKey";

    public WirelessTerminalItem(DoubleSupplier powerCapacity, class_1792.class_1793 props) {
        super(powerCapacity, props);
    }

    @Override
    public double getChargeRate(class_1799 stack) {
        return 800.0 + 800.0 * (double)this.getUpgrades(stack).getInstalledUpgrades(AEItems.ENERGY_CARD);
    }

    public boolean openFromInventory(class_1657 player, int inventorySlot) {
        class_1799 is = player.method_31548().method_5438(inventorySlot);
        if (this.checkPreconditions(is, player)) {
            return MenuOpener.open(this.getMenuType(), player, MenuLocators.forInventorySlot(inventorySlot));
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 is = player.method_5998(hand);
        if (this.checkPreconditions(is, player) && MenuOpener.open(this.getMenuType(), player, MenuLocators.forHand(player, hand))) {
            return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)is);
        }
        return new class_1271(class_1269.field_5814, (Object)is);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, level, lines, advancedTooltips);
        if (this.getGridKey(stack).isEmpty()) {
            lines.add((class_2561)Tooltips.of(GuiText.Unlinked, Tooltips.RED, new Object[0]));
        } else {
            lines.add((class_2561)Tooltips.of(GuiText.Linked, Tooltips.GREEN, new Object[0]));
        }
    }

    public OptionalLong getGridKey(class_1799 item) {
        class_2487 tag = item.method_7969();
        if (tag != null && tag.method_10573(TAG_GRID_KEY, 4)) {
            return OptionalLong.of(tag.method_10537(TAG_GRID_KEY));
        }
        return OptionalLong.empty();
    }

    public class_3917<?> getMenuType() {
        return MEStorageMenu.WIRELESS_TYPE;
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    @Override
    @Nullable
    public ItemMenuHost getMenuHost(class_1657 player, int inventorySlot, class_1799 stack, @Nullable class_2338 pos) {
        return new WirelessTerminalMenuHost(player, inventorySlot, stack, (p, subMenu) -> this.openFromInventory((class_1657)p, inventorySlot));
    }

    protected boolean checkPreconditions(class_1799 item, class_1657 player) {
        if (item.method_7960() || item.method_7909() != this) {
            return false;
        }
        class_1937 level = player.method_5770();
        if (level.method_8608()) {
            return false;
        }
        OptionalLong key = this.getGridKey(item);
        if (key.isEmpty()) {
            player.method_9203((class_2561)PlayerMessages.DeviceNotLinked.text(), class_156.field_25140);
            return false;
        }
        IActionHost securityStation = Locatables.securityStations().get(level, key.getAsLong());
        if (securityStation == null) {
            player.method_9203((class_2561)PlayerMessages.StationCanNotBeLocated.text(), class_156.field_25140);
            return false;
        }
        if (!this.hasPower(player, 0.5, item)) {
            player.method_9203((class_2561)PlayerMessages.DeviceNotPowered.text(), class_156.field_25140);
            return false;
        }
        return true;
    }

    public boolean usePower(class_1657 player, double amount, class_1799 is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    public boolean hasPower(class_1657 player, double amt, class_1799 is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(class_1799 target) {
        ConfigManager out = new ConfigManager((manager, settingName) -> manager.writeToNBT(target.method_7948()));
        out.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        out.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        out.readFromNBT(target.method_7948().method_10553());
        return out;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 stack) {
        return UpgradeInventories.forItem(stack, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(class_1799 stack, IUpgradeInventory upgrades) {
        this.setAEMaxPowerMultiplier(stack, 1 + upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD));
    }

    private static class LinkableHandler
    implements IGridLinkableHandler {
        private LinkableHandler() {
        }

        @Override
        public boolean canLink(class_1799 stack) {
            return stack.method_7909() instanceof WirelessTerminalItem;
        }

        @Override
        public void link(class_1799 itemStack, long securityKey) {
            itemStack.method_7948().method_10544(WirelessTerminalItem.TAG_GRID_KEY, securityKey);
        }

        @Override
        public void unlink(class_1799 itemStack) {
            itemStack.method_7983(WirelessTerminalItem.TAG_GRID_KEY);
        }
    }
}

