/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.ids.AEItemIds;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.upgrades.UpgradeInventories;
import appeng.block.AEBaseBlockItemChargeable;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.FluidContainerHelper;
import appeng.hooks.AEToolItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.PortableCellMenuHost;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.fluid.FluidSoundHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3955;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class PortableCellItem
extends AEBasePoweredItem
implements IBasicCellItem,
IMenuItem,
IUpgradeableItem,
AEToolItem {
    public static final StorageTier SIZE_1K = new StorageTier("1k", 512, 54, 8, () -> (class_1792)class_2378.field_11142.method_10223(AEItemIds.CELL_COMPONENT_1K));
    public static final StorageTier SIZE_4K = new StorageTier("4k", 2048, 45, 32, () -> (class_1792)class_2378.field_11142.method_10223(AEItemIds.CELL_COMPONENT_4K));
    public static final StorageTier SIZE_16K = new StorageTier("16k", 8192, 36, 128, () -> (class_1792)class_2378.field_11142.method_10223(AEItemIds.CELL_COMPONENT_16K));
    public static final StorageTier SIZE_64K = new StorageTier("64k", 16834, 27, 512, () -> (class_1792)class_2378.field_11142.method_10223(AEItemIds.CELL_COMPONENT_64K));
    private final StorageTier tier;
    private final AEKeyType keyType;
    private final class_3917<?> menuType;

    public class_2960 getRecipeId() {
        return AppEng.makeId("tools/" + Objects.requireNonNull(this.getRegistryName()).method_12832());
    }

    public PortableCellItem(AEKeyType keyType, class_3917<?> menuType, StorageTier tier, class_1792.class_1793 props) {
        super(AEConfig.instance().getPortableCellBattery(), props);
        this.menuType = menuType;
        this.tier = tier;
        this.keyType = keyType;
    }

    @Override
    public double getChargeRate(class_1799 stack) {
        return 80.0 + 80.0 * (double)this.getUpgrades(stack).getInstalledUpgrades(AEItems.ENERGY_CARD);
    }

    public boolean openFromInventory(class_1657 player, int inventorySlot) {
        class_1799 is = player.method_31548().method_5438(inventorySlot);
        if (is.method_7909() == this) {
            return MenuOpener.open(this.getMenuType(), player, MenuLocators.forInventorySlot(inventorySlot));
        }
        return false;
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        return context.method_8046() && this.disassembleDrive(stack, context.method_8045(), context.method_8036()) ? class_1269.method_29236((boolean)context.method_8045().method_8608()) : class_1269.field_5811;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (!(InteractionUtil.isInAlternateUseMode(player) && this.disassembleDrive(player.method_5998(hand), level, player) || level.method_8608())) {
            MenuOpener.open(this.getMenuType(), player, MenuLocators.forHand(player, hand));
        }
        return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)player.method_5998(hand));
    }

    private boolean disassembleDrive(class_1799 stack, class_1937 level, class_1657 player) {
        if (!AEConfig.instance().isPortableCellDisassemblyEnabled()) {
            return false;
        }
        class_1860 recipe = level.method_8433().method_8130(this.getRecipeId()).orElse(null);
        if (!(recipe instanceof class_3955)) {
            AELog.debug("Cannot disassemble portable cell because it's crafting recipe doesn't exist: %s", this.getRecipeId());
            return false;
        }
        class_3955 craftingRecipe = (class_3955)recipe;
        if (level.method_8608()) {
            return true;
        }
        class_1661 playerInventory = player.method_31548();
        if (playerInventory.method_7391() != stack) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory(stack, null);
        if (inv == null) {
            return false;
        }
        if (inv.getAvailableStacks().isEmpty()) {
            playerInventory.method_5447(playerInventory.field_7545, class_1799.field_8037);
            double remainingEnergy = this.getAECurrentPower(stack);
            for (class_1856 ingredient : craftingRecipe.method_8117()) {
                class_1792 class_17922;
                class_1799 ingredientStack = ingredient.method_8105()[0].method_7972();
                if (remainingEnergy > 0.0 && (class_17922 = ingredientStack.method_7909()) instanceof AEBaseBlockItemChargeable) {
                    AEBaseBlockItemChargeable chargeable = (AEBaseBlockItemChargeable)class_17922;
                    remainingEnergy = chargeable.injectAEPower(ingredientStack, remainingEnergy, Actionable.MODULATE);
                }
                playerInventory.method_7398(ingredientStack);
            }
            for (class_1799 upgrade : this.getUpgrades(stack)) {
                playerInventory.method_7398(upgrade);
            }
        } else {
            player.method_9203((class_2561)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), class_156.field_25140);
        }
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return this.tier.bytes();
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return this.tier.bytesPerType();
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return this.tier.types();
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem(is, 2, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(class_1799 stack, IUpgradeInventory upgrades) {
        int energyCards = upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD);
        this.setAEMaxPowerMultiplier(stack, 1 + energyCards * 8);
    }

    @Override
    public ConfigInventory getConfigInventory(class_1799 is) {
        return CellConfig.create(this.keyType.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    @Override
    public PortableCellMenuHost getMenuHost(class_1657 player, int inventorySlot, class_1799 stack, class_2338 pos) {
        return new PortableCellMenuHost(player, inventorySlot, this, stack, (p, sm) -> this.openFromInventory((class_1657)p, inventorySlot));
    }

    public boolean allowNbtUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public long insert(class_1657 player, class_1799 itemStack, AEKey what, long amount, Actionable mode) {
        if (this.keyType.tryCast(what) == null) {
            return 0L;
        }
        PortableCellMenuHost host = this.getMenuHost(player, -1, itemStack, null);
        if (host == null) {
            return 0L;
        }
        MEStorage inv = host.getInventory();
        if (inv != null) {
            return StorageHelper.poweredInsert(host, inv, what, amount, new PlayerSource(player), mode);
        }
        return 0L;
    }

    @Override
    public AEKeyType getKeyType() {
        return this.keyType;
    }

    public class_3917<?> getMenuType() {
        return this.menuType;
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 action, class_1657 player) {
        long extracted;
        GenericStack fluidStack;
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        class_1799 other = slot.method_7677();
        if (other.method_7960()) {
            return true;
        }
        if (this.keyType == AEKeyType.items()) {
            AEItemKey key = AEItemKey.of(other);
            int inserted = (int)this.insert(player, stack, key, other.method_7947(), Actionable.MODULATE);
            other.method_7934(inserted);
        } else if (this.keyType == AEKeyType.fluids() && (fluidStack = FluidContainerHelper.getContainedStack(other)) != null && this.insert(player, stack, fluidStack.what(), fluidStack.amount(), Actionable.SIMULATE) == fluidStack.amount() && (extracted = FluidContainerHelper.extractFromPlayerInventory(player, (AEFluidKey)fluidStack.what(), fluidStack.amount(), other)) > 0L) {
            this.insert(player, stack, fluidStack.what(), extracted, Actionable.MODULATE);
            FluidSoundHelper.playEmptySound(player, (AEFluidKey)fluidStack.what());
        }
        return true;
    }

    public boolean method_31566(class_1799 stack, class_1799 other, class_1735 slot, class_5536 action, class_1657 player, class_5630 access) {
        long extracted;
        GenericStack fluidStack;
        if (action != class_5536.field_27014 || !slot.method_32754(player)) {
            return false;
        }
        if (other.method_7960()) {
            return false;
        }
        if (this.keyType == AEKeyType.items()) {
            AEItemKey key = AEItemKey.of(other);
            int inserted = (int)this.insert(player, stack, key, other.method_7947(), Actionable.MODULATE);
            other.method_7934(inserted);
        } else if (this.keyType == AEKeyType.fluids() && (fluidStack = FluidContainerHelper.getContainedStack(other)) != null && this.insert(player, stack, fluidStack.what(), fluidStack.amount(), Actionable.SIMULATE) == fluidStack.amount() && (extracted = FluidContainerHelper.extractFromCarried(player, (AEFluidKey)fluidStack.what(), fluidStack.amount(), stack)) > 0L) {
            this.insert(player, stack, fluidStack.what(), extracted, Actionable.MODULATE);
            FluidSoundHelper.playEmptySound(player, (AEFluidKey)fluidStack.what());
        }
        return true;
    }

    public StorageTier getTier() {
        return this.tier;
    }

    public static int getColor(class_1799 stack, int tintIndex) {
        class_1792 class_17922;
        if (tintIndex == 1 && (class_17922 = stack.method_7909()) instanceof PortableCellItem) {
            PortableCellItem portableCellItem = (PortableCellItem)class_17922;
            if (portableCellItem.getAECurrentPower(stack) <= 0.0) {
                return CellState.ABSENT.getStateColor();
            }
            StorageCell cellInv = StorageCells.getCellInventory(stack, null);
            CellState cellStatus = cellInv != null ? cellInv.getStatus() : CellState.EMPTY;
            return cellStatus.getStateColor();
        }
        return 0xFFFFFF;
    }

    public record StorageTier(String namePrefix, int bytes, int types, int bytesPerType, Supplier<class_1792> componentSupplier) {
    }
}

