/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.misc.PaintSplotchesBlockEntity;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.packets.MatterCannonPacket;
import appeng.items.contents.CellConfig;
import appeng.items.misc.PaintBallItem;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.helpers.PlayerSource;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.util.ConfigInventory;
import appeng.util.InteractionUtil;
import appeng.util.LookDirection;
import appeng.util.Platform;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1472;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1860;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.server.MinecraftServer;

public class MatterCannonItem
extends AEBasePoweredItem
implements IBasicCellItem {
    private static final int ENERGY_PER_SHOT = 1600;

    public MatterCannonItem(class_1792.class_1793 props) {
        super(AEConfig.instance().getMatterCannonBattery(), props);
    }

    @Override
    public double getChargeRate(class_1799 stack) {
        return 800.0 + 800.0 * (double)this.getUpgrades(stack).getInstalledUpgrades(AEItems.ENERGY_CARD);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        super.method_7851(stack, level, lines, advancedTooltips);
        this.addCellInformationToTooltip(stack, lines);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 p, class_1268 hand) {
        LookDirection direction;
        class_1799 stack = p.method_5998(hand);
        if (this.fireCannon(level, stack, p, direction = InteractionUtil.getPlayerRay(p, 32.0))) {
            return new class_1271(class_1269.method_29236((boolean)level.method_8608()), (Object)stack);
        }
        return new class_1271(class_1269.field_5814, (Object)stack);
    }

    public boolean fireCannon(class_1937 level, class_1799 stack, class_1657 player, LookDirection dir) {
        Object object;
        if (this.getAECurrentPower(stack) < 1600.0) {
            return false;
        }
        StorageCell inv = StorageCells.getCellInventory(stack, null);
        if (inv == null) {
            return false;
        }
        KeyCounter itemList = inv.getAvailableStacks();
        Object2LongMap.Entry<AEKey> req = itemList.getFirstEntry(AEItemKey.class);
        if (req == null || !((object = req.getKey()) instanceof AEItemKey)) {
            if (!level.method_8608()) {
                player.method_9203((class_2561)PlayerMessages.AmmoDepleted.text(), class_156.field_25140);
            }
            return true;
        }
        AEItemKey itemKey = (AEItemKey)object;
        int shots = 1;
        IUpgradeInventory cu = this.getUpgrades(stack);
        if (cu != null) {
            shots += cu.getInstalledUpgrades(AEItems.SPEED_CARD);
        }
        shots = Math.min(shots, (int)req.getLongValue());
        for (int sh = 0; sh < shots; ++sh) {
            this.extractAEPower(stack, 1600.0, Actionable.MODULATE);
            if (level.method_8608()) {
                return true;
            }
            long aeAmmo = inv.extract((AEKey)req.getKey(), 1L, Actionable.MODULATE, new PlayerSource(player));
            if (aeAmmo == 0L) {
                return true;
            }
            class_243 rayFrom = dir.getA();
            class_243 rayTo = dir.getB();
            class_243 direction = rayTo.method_1020(rayFrom);
            direction.method_1029();
            double x = rayFrom.field_1352;
            double y = rayFrom.field_1351;
            double z = rayFrom.field_1350;
            class_1799 ammoStack = itemKey.toStack();
            float penetration = this.getPenetration(ammoStack);
            if (penetration <= 0.0f) {
                if (!(ammoStack.method_7909() instanceof PaintBallItem)) continue;
                this.shootPaintBalls(ammoStack, level, player, rayFrom, rayTo, direction, x, y, z);
                return true;
            }
            this.standardAmmo(penetration, level, player, rayFrom, rayTo, direction, x, y, z);
        }
        return true;
    }

    private void shootPaintBalls(class_1799 type, class_1937 level, @Nullable class_1657 p, class_243 Vector3d, class_243 Vector3d1, class_243 direction, double d0, double d1, double d2) {
        class_243 intersection;
        class_238 bb = new class_238(Math.min(Vector3d.field_1352, Vector3d1.field_1352), Math.min(Vector3d.field_1351, Vector3d1.field_1351), Math.min(Vector3d.field_1350, Vector3d1.field_1350), Math.max(Vector3d.field_1352, Vector3d1.field_1352), Math.max(Vector3d.field_1351, Vector3d1.field_1351), Math.max(Vector3d.field_1350, Vector3d1.field_1350)).method_1009(16.0, 16.0, 16.0);
        class_1297 entity = null;
        class_243 entityIntersection = null;
        List list = level.method_8333((class_1297)p, bb, e -> !(e instanceof class_1542) && e.method_5805());
        double closest = 9999999.0;
        for (class_1297 entity1 : list) {
            double nd;
            if (p.method_5765() && entity1.method_5626((class_1297)p)) continue;
            float f1 = 0.3f;
            class_238 boundingBox = entity1.method_5829().method_1009((double)0.3f, (double)0.3f, (double)0.3f);
            intersection = boundingBox.method_992(Vector3d, Vector3d1).orElse(null);
            if (intersection == null || !((nd = Vector3d.method_1025(intersection)) < closest)) continue;
            entity = entity1;
            entityIntersection = intersection;
            closest = nd;
        }
        class_3959 rayTraceContext = new class_3959(Vector3d, Vector3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)p);
        class_3965 pos = level.method_17742(rayTraceContext);
        class_243 vec = new class_243(d0, d1, d2);
        if (entity != null && pos.method_17783() != class_239.class_240.field_1333 && pos.method_17784().method_1025(vec) > closest) {
            pos = new class_3966(entity, entityIntersection);
        } else if (entity != null && pos.method_17783() == class_239.class_240.field_1333) {
            pos = new class_3966(entity, entityIntersection);
        }
        try {
            AppEng.instance().sendToAllNearExcept(null, d0, d1, d2, 128.0, level, new MatterCannonPacket(d0, d1, d2, (float)direction.field_1352, (float)direction.field_1351, (float)direction.field_1350, (byte)(pos.method_17783() == class_239.class_240.field_1333 ? 32.0 : pos.method_17784().method_1025(vec) + 1.0)));
        }
        catch (Exception err) {
            AELog.debug(err);
        }
        if (pos.method_17783() != class_239.class_240.field_1333 && type != null && (intersection = type.method_7909()) instanceof PaintBallItem) {
            PaintBallItem ipb = (PaintBallItem)intersection;
            AEColor col = ipb.getColor();
            if (pos instanceof class_3966) {
                class_3966 entityResult = (class_3966)pos;
                class_1297 entityHit = entityResult.method_17782();
                if (entityHit instanceof class_1472) {
                    class_1472 sh = (class_1472)entityHit;
                    sh.method_6631(col.dye);
                }
                entityHit.method_5643(class_1282.method_5532((class_1657)p), 0.0f);
            } else if (pos instanceof class_3965) {
                class_2586 te;
                class_3965 blockResult = pos;
                class_2350 side = blockResult.method_17780();
                class_2338 hitPos = blockResult.method_17777().method_10093(side);
                if (!Platform.hasPermissions(new DimensionalBlockPos(level, hitPos), p)) {
                    return;
                }
                class_2680 whatsThere = level.method_8320(hitPos);
                if (whatsThere.method_26207().method_15800() && level.method_22347(hitPos)) {
                    level.method_8652(hitPos, AEBlocks.PAINT.block().method_9564(), 3);
                }
                if ((te = level.method_8321(hitPos)) instanceof PaintSplotchesBlockEntity) {
                    class_243 hp = pos.method_17784().method_1023((double)hitPos.method_10263(), (double)hitPos.method_10264(), (double)hitPos.method_10260());
                    ((PaintSplotchesBlockEntity)te).addBlot(type, side.method_10153(), hp);
                }
            }
        }
    }

    private void standardAmmo(float penetration, class_1937 level, class_1657 p, class_243 Vector3d, class_243 Vector3d1, class_243 direction, double d0, double d1, double d2) {
        boolean hasDestroyed = true;
        while (penetration > 0.0f && hasDestroyed) {
            hasDestroyed = false;
            class_238 bb = new class_238(Math.min(Vector3d.field_1352, Vector3d1.field_1352), Math.min(Vector3d.field_1351, Vector3d1.field_1351), Math.min(Vector3d.field_1350, Vector3d1.field_1350), Math.max(Vector3d.field_1352, Vector3d1.field_1352), Math.max(Vector3d.field_1351, Vector3d1.field_1351), Math.max(Vector3d.field_1350, Vector3d1.field_1350)).method_1009(16.0, 16.0, 16.0);
            class_1297 entity = null;
            class_243 entityIntersection = null;
            List list = level.method_8333((class_1297)p, bb, e -> !(e instanceof class_1542) && e.method_5805());
            double closest = 9999999.0;
            for (class_1297 entity1 : list) {
                double nd;
                if (p.method_5765() && entity1.method_5626((class_1297)p)) continue;
                float f1 = 0.3f;
                class_238 boundingBox = entity1.method_5829().method_1009((double)0.3f, (double)0.3f, (double)0.3f);
                class_243 intersection = boundingBox.method_992(Vector3d, Vector3d1).orElse(null);
                if (intersection == null || !((nd = Vector3d.method_1025(intersection)) < closest)) continue;
                entity = entity1;
                entityIntersection = intersection;
                closest = nd;
            }
            class_3959 rayTraceContext = new class_3959(Vector3d, Vector3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)p);
            class_243 vec = new class_243(d0, d1, d2);
            class_3965 pos = level.method_17742(rayTraceContext);
            if (entity != null && pos.method_17783() != class_239.class_240.field_1333 && pos.method_17784().method_1025(vec) > closest) {
                pos = new class_3966(entity, entityIntersection);
            } else if (entity != null && pos.method_17783() == class_239.class_240.field_1333) {
                pos = new class_3966(entity, entityIntersection);
            }
            try {
                AppEng.instance().sendToAllNearExcept(null, d0, d1, d2, 128.0, level, new MatterCannonPacket(d0, d1, d2, (float)direction.field_1352, (float)direction.field_1351, (float)direction.field_1350, (byte)(pos.method_17783() == class_239.class_240.field_1333 ? 32.0 : pos.method_17784().method_1025(vec) + 1.0)));
            }
            catch (Exception err) {
                AELog.debug(err);
            }
            if (pos.method_17783() == class_239.class_240.field_1333) continue;
            class_1285 dmgSrc = new class_1285("matter_cannon", (class_1297)p);
            if (pos instanceof class_3966) {
                class_3966 entityResult = (class_3966)pos;
                class_1297 entityHit = entityResult.method_17782();
                int dmg = (int)Math.ceil(penetration / 20.0f);
                if (entityHit instanceof class_1309) {
                    class_1309 el = (class_1309)entityHit;
                    penetration -= (float)dmg;
                    el.method_6005(0.0, -direction.field_1352, -direction.field_1350);
                    el.method_5643((class_1282)dmgSrc, (float)dmg);
                    if (el.method_5805()) continue;
                    hasDestroyed = true;
                    continue;
                }
                if (entityHit instanceof class_1542) {
                    hasDestroyed = true;
                    entityHit.method_31472();
                    continue;
                }
                if (!entityHit.method_5643((class_1282)dmgSrc, (float)dmg)) continue;
                hasDestroyed = !entityHit.method_5805();
                continue;
            }
            if (!(pos instanceof class_3965)) continue;
            class_3965 blockResult = pos;
            if (!AEConfig.instance().isMatterCanonBlockDamageEnabled()) {
                penetration = 0.0f;
                continue;
            }
            class_2338 blockPos = blockResult.method_17777();
            class_2680 bs = level.method_8320(blockPos);
            float hardness = bs.method_26214((class_1922)level, blockPos) * 9.0f;
            if (!((double)hardness >= 0.0) || !(penetration > hardness) || !Platform.hasPermissions(new DimensionalBlockPos(level, blockPos), p)) continue;
            hasDestroyed = true;
            penetration -= hardness;
            penetration = (float)((double)penetration * 0.6);
            level.method_22352(blockPos, true);
        }
    }

    @Override
    public boolean isEditable(class_1799 is) {
        return true;
    }

    @Override
    public IUpgradeInventory getUpgrades(class_1799 is) {
        return UpgradeInventories.forItem(is, 4, this::onUpgradesChanged);
    }

    private void onUpgradesChanged(class_1799 stack, IUpgradeInventory upgrades) {
        int energyCards = upgrades.getInstalledUpgrades(AEItems.ENERGY_CARD);
        this.setAEMaxPowerMultiplier(stack, 1 + energyCards * 8);
    }

    @Override
    public ConfigInventory getConfigInventory(class_1799 is) {
        return CellConfig.create(AEItemKey.filter(), is);
    }

    @Override
    public FuzzyMode getFuzzyMode(class_1799 is) {
        String fz = is.method_7948().method_10558("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(class_1799 is, FuzzyMode fzMode) {
        is.method_7948().method_10582("FuzzyMode", fzMode.name());
    }

    @Override
    public int getBytes(class_1799 cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(class_1799 cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(class_1799 cellItem) {
        return 1;
    }

    @Override
    public boolean isBlackListed(class_1799 cellItem, AEKey requestedAddition) {
        if (requestedAddition instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)requestedAddition;
            float pen = this.getPenetration(itemKey.toStack());
            if (pen > 0.0f) {
                return false;
            }
            return !(itemKey.getItem() instanceof PaintBallItem);
        }
        return true;
    }

    private float getPenetration(class_1799 itemStack) {
        MinecraftServer server = AppEng.instance().getCurrentServer();
        if (server == null) {
            AELog.warn("Tried to get penetration of matter cannon ammo for %s while no server was running", itemStack);
            return 0.0f;
        }
        Map recipes = server.method_3772().method_17717(MatterCannonAmmo.TYPE);
        for (class_1860 recipe : recipes.values()) {
            MatterCannonAmmo ammoRecipe;
            if (!(recipe instanceof MatterCannonAmmo) || !(ammoRecipe = (MatterCannonAmmo)recipe).getAmmo().method_8093(itemStack)) continue;
            return ammoRecipe.getWeight();
        }
        return 0.0f;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public AEKeyType getKeyType() {
        return AEKeyType.items();
    }
}

