/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.spatial.SpatialStorageHelper;
import appeng.spatial.SpatialStoragePlot;
import appeng.spatial.SpatialStoragePlotManager;
import appeng.spatial.TransitionInfo;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class SpatialStorageCellItem
extends AEBaseItem
implements ISpatialStorageCell {
    private static final String TAG_PLOT_ID = "plot_id";
    private static final String TAG_PLOT_SIZE = "plot_size";
    private final int maxRegion;

    public SpatialStorageCellItem(class_1792.class_1793 props, int spatialScale) {
        super(props);
        this.maxRegion = spatialScale;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> lines, class_1836 advancedTooltips) {
        int plotId = this.getAllocatedPlotId(stack);
        if (plotId == -1) {
            lines.add((class_2561)Tooltips.of(GuiText.Unformatted, new Object[0]).method_27692(class_124.field_1056));
            lines.add((class_2561)Tooltips.of(GuiText.SpatialCapacity, this.maxRegion, this.maxRegion, this.maxRegion));
            return;
        }
        String serialNumber = String.format(Locale.ROOT, "SP-%04d", plotId);
        lines.add((class_2561)Tooltips.of(GuiText.SerialNumber, serialNumber));
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573(TAG_PLOT_SIZE, 4)) {
            class_2338 size = class_2338.method_10092((long)tag.method_10537(TAG_PLOT_SIZE));
            lines.add((class_2561)Tooltips.of(GuiText.StoredSize, size.method_10263(), size.method_10264(), size.method_10260()));
        }
    }

    @Override
    public boolean isSpatialStorage(class_1799 is) {
        return true;
    }

    @Override
    public int getMaxStoredDim(class_1799 is) {
        return this.maxRegion;
    }

    @Override
    public int getAllocatedPlotId(class_1799 is) {
        class_2487 c = is.method_7969();
        if (c != null && c.method_10545(TAG_PLOT_ID)) {
            try {
                int plotId = c.method_10550(TAG_PLOT_ID);
                if (SpatialStoragePlotManager.INSTANCE.getPlot(plotId) == null) {
                    return -1;
                }
                return plotId;
            }
            catch (Exception e) {
                AELog.warn("Failed to retrieve spatial storage dimension: %s", e);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doSpatialTransition(class_1799 is, class_3218 level, class_2338 min, class_2338 max, int playerId) {
        int targetX = max.method_10263() - min.method_10263() - 1;
        int targetY = max.method_10264() - min.method_10264() - 1;
        int targetZ = max.method_10260() - min.method_10260() - 1;
        int maxSize = this.getMaxStoredDim(is);
        if (targetX > maxSize && targetY > maxSize && targetZ > maxSize) {
            AELog.info("Failing spatial transition because the transfer area (%dx%dx%d) exceeds the cell capacity (%s).", targetX, targetY, targetZ, maxSize);
            return false;
        }
        class_2338 targetSize = new class_2338(targetX, targetY, targetZ);
        SpatialStoragePlotManager manager = SpatialStoragePlotManager.INSTANCE;
        SpatialStoragePlot plot = SpatialStoragePlotManager.INSTANCE.getPlot(this.getAllocatedPlotId(is));
        if (plot != null) {
            if (!plot.getSize().equals((Object)targetSize)) {
                AELog.info("Failing spatial transition because the transfer area (%dx%dx%d) does not match the spatial storage plot's size (%s).", targetX, targetY, targetZ, plot.getSize());
                return false;
            }
        } else {
            plot = manager.allocatePlot(targetSize, playerId);
        }
        TransitionInfo info = new TransitionInfo(level.method_27983().method_29177(), min, max, Instant.now());
        manager.setLastTransition(plot.getId(), info);
        try {
            class_3218 cellLevel = manager.getLevel();
            class_2338 offset = plot.getOrigin();
            this.setStoredDimension(is, plot.getId(), plot.getSize());
            SpatialStorageHelper.getInstance().swapRegions(level, min.method_10263() + 1, min.method_10264() + 1, min.method_10260() + 1, cellLevel, offset.method_10263(), offset.method_10264(), offset.method_10260(), targetX - 1, targetY - 1, targetZ - 1);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.getAllocatedPlotId(is) == -1) {
                manager.freePlot(plot.getId(), true);
            }
        }
    }

    public void setStoredDimension(class_1799 is, int plotId, class_2338 size) {
        class_2487 c = is.method_7948();
        c.method_10569(TAG_PLOT_ID, plotId);
        c.method_10544(TAG_PLOT_SIZE, size.method_10063());
    }
}

