/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.core.AEConfig;
import appeng.core.definitions.AEParts;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.parts.FacadeItem;
import appeng.parts.BusCollisionHelper;
import appeng.parts.PartPlacement;
import appeng.parts.misc.CableAnchorPart;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;

public class RenderBlockOutlineHook {
    private RenderBlockOutlineHook() {
    }

    public static void install() {
        WorldRenderEvents.BEFORE_BLOCK_OUTLINE.register((context, hitResult) -> {
            class_3965 blockHitResult;
            class_638 level = context.world();
            class_4587 poseStack = context.matrixStack();
            class_4597 buffers = context.consumers();
            class_4184 camera = context.camera();
            if (level == null || buffers == null) {
                return true;
            }
            if (!(hitResult instanceof class_3965) || (blockHitResult = (class_3965)hitResult).method_17783() != class_239.class_240.field_1332) {
                return true;
            }
            return !RenderBlockOutlineHook.replaceBlockOutline(level, poseStack, buffers, camera, blockHitResult);
        });
    }

    private static boolean replaceBlockOutline(class_638 level, class_4587 poseStack, class_4597 buffers, class_4184 camera, class_3965 hitResult) {
        class_2338 pos;
        class_2586 class_25862;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        if (AEConfig.instance().isPlacementPreviewEnabled()) {
            class_1799 itemInHand = player.method_5998(class_1268.field_5808);
            RenderBlockOutlineHook.showPartPlacementPreview((class_1657)player, poseStack, buffers, camera, hitResult, itemInHand);
        }
        if ((class_25862 = level.method_8321(pos = hitResult.method_17777())) instanceof IPartHost) {
            IPartHost partHost = (IPartHost)class_25862;
            if (AEConfig.instance().isPlacementPreviewEnabled()) {
                class_1799 itemInHand = player.method_5998(class_1268.field_5808);
                RenderBlockOutlineHook.showFacadePlacementPreview(poseStack, buffers, camera, hitResult, partHost, itemInHand);
            }
            SelectedPart selectedPart = partHost.selectPartWorld(hitResult.method_17784());
            if (selectedPart.facade != null) {
                RenderBlockOutlineHook.renderFacade(poseStack, buffers, camera, pos, selectedPart.facade, selectedPart.side, false);
                return true;
            }
            if (selectedPart.part != null) {
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, pos, selectedPart.part, selectedPart.side, false);
                return true;
            }
        }
        return false;
    }

    private static boolean showFacadePlacementPreview(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_3965 blockHitResult, IPartHost partHost, class_1799 itemInHand) {
        class_2350 side;
        IFacadeItem facadeItem;
        FacadePart facade;
        class_2338 pos = blockHitResult.method_17777();
        class_1792 class_17922 = itemInHand.method_7909();
        if (class_17922 instanceof IFacadeItem && (facade = (facadeItem = (IFacadeItem)class_17922).createPartFromItemStack(itemInHand, side = blockHitResult.method_17780())) != null && FacadeItem.canPlaceFacade(partHost, facade)) {
            if (partHost.getPart(side) == null) {
                CableAnchorPart cableAnchor = AEParts.CABLE_ANCHOR.method_8389().createPart();
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, pos, cableAnchor, side, true);
            }
            RenderBlockOutlineHook.renderFacade(poseStack, buffers, camera, pos, facade, side, true);
            return true;
        }
        return false;
    }

    private static void showPartPlacementPreview(class_1657 player, class_4587 poseStack, class_4597 buffers, class_4184 camera, class_3965 blockHitResult, class_1799 itemInHand) {
        class_1792 class_17922 = itemInHand.method_7909();
        if (class_17922 instanceof IPartItem) {
            IPartItem partItem = (IPartItem)class_17922;
            PartPlacement.Placement placement = PartPlacement.getPartPlacement(player, player.field_6002, itemInHand, blockHitResult.method_17777(), blockHitResult.method_17780());
            if (placement != null) {
                Object part = partItem.createPart();
                RenderBlockOutlineHook.renderPart(poseStack, buffers, camera, placement.pos(), part, placement.side(), true);
            }
        }
    }

    private static void renderPart(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_2338 pos, IPart part, class_2350 side, boolean preview) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, side, true);
        part.getBoxes(helper);
        RenderBlockOutlineHook.renderBoxes(poseStack, buffers, camera, pos, boxes, preview);
    }

    private static void renderFacade(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_2338 pos, IFacadePart facade, class_2350 side, boolean preview) {
        ArrayList<class_238> boxes = new ArrayList<class_238>();
        BusCollisionHelper helper = new BusCollisionHelper(boxes, side, true);
        facade.getBoxes(helper, false);
        RenderBlockOutlineHook.renderBoxes(poseStack, buffers, camera, pos, boxes, preview);
    }

    private static void renderBoxes(class_4587 poseStack, class_4597 buffers, class_4184 camera, class_2338 pos, List<class_238> boxes, boolean preview) {
        for (class_238 box : boxes) {
            class_265 shape = class_259.method_1078((class_238)box);
            class_761.method_3291((class_4587)poseStack, (class_4588)buffers.getBuffer(class_1921.method_23594()), (class_265)shape, (double)((double)pos.method_10263() - camera.method_19326().field_1352), (double)((double)pos.method_10264() - camera.method_19326().field_1351), (double)((double)pos.method_10260() - camera.method_19326().field_1350), (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)(preview ? 1.0f : 0.0f), (float)0.4f);
        }
    }
}

