/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;

public final class FluidContainerHelper {
    private FluidContainerHelper() {
    }

    @Nullable
    public static GenericStack getContainedStack(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        ResourceAmount content = StorageUtil.findExtractableContent(FluidContainerHelper.getReadOnlyStorage(stack), null);
        if (content != null) {
            return new GenericStack(AEFluidKey.of((FluidVariant)content.resource()), content.amount());
        }
        return null;
    }

    public static Storage<FluidVariant> getReadOnlyStorage(class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        return (Storage)ContainerItemContext.withInitial((class_1799)stack).find(FluidStorage.ITEM);
    }

    public static long extractFromCarried(class_1657 player, AEFluidKey what, long amount, class_1799 carried) {
        if (player.field_7512 == null || player.field_7512.method_34255() != carried) {
            return 0L;
        }
        ContainerItemContext context = ContainerItemContext.ofPlayerCursor((class_1657)player, (class_1703)player.field_7512);
        return FluidContainerHelper.extractFromStorage(what, amount, context);
    }

    public static long extractFromPlayerInventory(class_1657 player, AEFluidKey what, long amount, class_1799 stack) {
        class_1661 inventory = player.method_31548();
        ContainerItemContext context = null;
        PlayerInventoryStorage playerInv = PlayerInventoryStorage.of((class_1661)inventory);
        for (int i = 0; i < inventory.method_5439(); ++i) {
            if (inventory.method_5438(i) != stack) continue;
            context = ContainerItemContext.ofPlayerSlot((class_1657)player, (SingleSlotStorage)((SingleSlotStorage)playerInv.getSlots().get(i)));
            break;
        }
        if (context == null) {
            return 0L;
        }
        return FluidContainerHelper.extractFromStorage(what, amount, context);
    }

    private static long extractFromStorage(AEFluidKey what, long amount, ContainerItemContext context) {
        Storage storage = (Storage)context.find(FluidStorage.ITEM);
        if (storage == null) {
            return 0L;
        }
        try (Transaction tx = Transaction.openOuter();){
            long extracted = storage.extract((Object)what.toVariant(), amount, (TransactionContext)tx);
            if (extracted > 0L) {
                tx.commit();
            }
            long l = extracted;
            return l;
        }
    }
}

