/*
 * Decompiled with CFR 0.152.
 */
package appeng.debug;

import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.spatial.ISpatialService;
import appeng.hooks.AEToolItem;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;

public class ReplicatorCardItem
extends AEBaseItem
implements AEToolItem {
    public ReplicatorCardItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 playerIn, class_1268 handIn) {
        if (!level.method_8608()) {
            class_2487 tag = playerIn.method_5998(handIn).method_7948();
            int replications = tag.method_10545("r") ? (tag.method_10550("r") + 1) % 4 : 0;
            tag.method_10569("r", replications);
            playerIn.method_9203((class_2561)new class_2585(replications + 1 + "\u00b3 Replications"), class_156.field_25140);
        }
        return super.method_7836(level, playerIn, handIn);
    }

    @Override
    public class_1269 onItemUseFirst(class_1799 stack, class_1838 context) {
        class_1937 level = context.method_8045();
        if (level.method_8608()) {
            return class_1269.method_29236((boolean)level.method_8608());
        }
        class_1657 player = context.method_8036();
        class_2338 pos = context.method_8037();
        class_2350 side = context.method_8038();
        class_1268 hand = context.method_20287();
        if (player == null) {
            return class_1269.field_5811;
        }
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        if (InteractionUtil.isInAlternateUseMode(player)) {
            IInWorldGridNodeHost gridHost = GridHelper.getNodeHost((class_1936)level, pos);
            if (gridHost != null) {
                class_2487 tag = player.method_5998(hand).method_7948();
                tag.method_10569("x", x);
                tag.method_10569("y", y);
                tag.method_10569("z", z);
                tag.method_10569("side", side.ordinal());
                tag.method_10582("w", level.method_27983().method_29177().toString());
                tag.method_10569("r", 0);
                this.outputMsg((class_1297)player, "Set replicator source");
            } else {
                this.outputMsg((class_1297)player, "This does not host a grid node");
            }
        } else {
            class_2487 ish = player.method_5998(hand).method_7969();
            if (ish != null) {
                int src_x = ish.method_10550("x");
                int src_y = ish.method_10550("y");
                int src_z = ish.method_10550("z");
                int src_side = ish.method_10550("side");
                String worldId = ish.method_10558("w");
                class_3218 src_w = level.method_8503().method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(worldId)));
                int replications = ish.method_10550("r") + 1;
                IInWorldGridNodeHost gh = GridHelper.getNodeHost((class_1936)src_w, new class_2338(src_x, src_y, src_z));
                if (gh != null) {
                    class_2350 sideOff = class_2350.values()[src_side];
                    class_2350 currentSideOff = side;
                    IGridNode n = gh.getGridNode(sideOff);
                    if (n != null) {
                        IGrid g = n.getGrid();
                        ISpatialService sc = g.getSpatialService();
                        if (sc.isValidRegion()) {
                            class_2338 min = sc.getMin();
                            class_2338 max = sc.getMax();
                            int sc_size_x = max.method_10263() - min.method_10263();
                            int sc_size_y = max.method_10264() - min.method_10264();
                            int sc_size_z = max.method_10260() - min.method_10260();
                            int min_x = min.method_10263();
                            int min_y = min.method_10264();
                            int min_z = min.method_10260();
                            int x_rot = (int)(-Math.signum(class_3532.method_15393((float)player.method_36454())));
                            int z_rot = (int)Math.signum(class_3532.method_15393((float)(player.method_36454() + 90.0f)));
                            for (int r_x = 0; r_x < replications; ++r_x) {
                                for (int r_y = 0; r_y < replications; ++r_y) {
                                    for (int r_z = 0; r_z < replications; ++r_z) {
                                        int rel_x = min.method_10263() - src_x + x + r_x * sc_size_x * x_rot;
                                        int rel_y = min.method_10264() - src_y + y + r_y * sc_size_y;
                                        int rel_z = min.method_10260() - src_z + z + r_z * sc_size_z * z_rot;
                                        for (int i = 1; i < sc_size_x; ++i) {
                                            for (int j = 1; j < sc_size_y; ++j) {
                                                for (int k = 1; k < sc_size_z; ++k) {
                                                    class_2586 ote;
                                                    class_2487 data;
                                                    class_2586 newBe;
                                                    class_2338 p = new class_2338(min_x + i, min_y + j, min_z + k);
                                                    class_2338 d = new class_2338(i + rel_x, j + rel_y, k + rel_z);
                                                    class_2680 state = src_w.method_8320(p);
                                                    class_2680 prev = level.method_8320(d);
                                                    level.method_8501(d, state);
                                                    if (state.method_31709() && (newBe = class_2586.method_11005((class_2338)d, (class_2680)state, (class_2487)(data = (ote = src_w.method_8321(p)).method_38243()))) != null) {
                                                        level.method_8438(newBe);
                                                    }
                                                    level.method_8413(d, prev, state, 3);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        } else {
                            this.outputMsg((class_1297)player, "requires valid spatial pylon setup.");
                        }
                    } else {
                        this.outputMsg((class_1297)player, "No grid node?");
                    }
                } else {
                    this.outputMsg((class_1297)player, "Src is no longer a grid block?");
                }
            } else {
                this.outputMsg((class_1297)player, "No Source Defined");
            }
        }
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private void outputMsg(class_1297 player, String string) {
        player.method_9203((class_2561)new class_2585(string), class_156.field_25140);
    }
}

