/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.AEKeyFilter;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.BasePacketHandler;
import appeng.core.sync.network.INetworkInfo;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.menu.me.common.IncrementalUpdateHelper;
import appeng.menu.me.common.MEStorageMenu;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;

public class MEInventoryUpdatePacket
extends BasePacket {
    private static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x20000000;
    private static final int INITIAL_BUFFER_CAPACITY = 2048;
    private final List<GridInventoryEntry> entries;
    private boolean fullUpdate;
    private int containerId;

    public MEInventoryUpdatePacket(class_2540 data) {
        this.containerId = data.method_10816();
        this.fullUpdate = data.readBoolean();
        int count = data.readShort();
        this.entries = new ArrayList<GridInventoryEntry>(count);
        for (int i = 0; i < count; ++i) {
            this.entries.add(MEInventoryUpdatePacket.readEntry(data));
        }
    }

    private MEInventoryUpdatePacket() {
        this.entries = null;
    }

    public static Builder builder(int containerId, boolean fullUpdate) {
        return new Builder(containerId, fullUpdate);
    }

    private static void writeEntry(class_2540 buffer, GridInventoryEntry entry) {
        buffer.method_10791(entry.getSerial());
        AEKey.writeOptionalKey(buffer, entry.getWhat());
        buffer.method_10791(entry.getStoredAmount());
        buffer.method_10791(entry.getRequestableAmount());
        buffer.writeBoolean(entry.isCraftable());
    }

    public static GridInventoryEntry readEntry(class_2540 buffer) {
        long serial = buffer.method_10792();
        AEKey what = AEKey.readOptionalKey(buffer);
        long storedAmount = buffer.method_10792();
        long requestableAmount = buffer.method_10792();
        boolean craftable = buffer.readBoolean();
        return new GridInventoryEntry(serial, what, storedAmount, requestableAmount, craftable);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientPacketData(INetworkInfo network, class_1657 player) {
        class_1703 class_17032;
        if (player.field_7512.field_7763 == this.containerId && (class_17032 = player.field_7512) instanceof MEStorageMenu) {
            MEStorageMenu meMenu = (MEStorageMenu)class_17032;
            IClientRepo clientRepo = meMenu.getClientRepo();
            if (clientRepo == null) {
                AELog.info("Ignoring ME inventory update packet because no client repo is available.", new Object[0]);
                return;
            }
            clientRepo.handleUpdate(this.fullUpdate, this.entries);
        }
    }

    public static class Builder {
        private final List<MEInventoryUpdatePacket> packets = new ArrayList<MEInventoryUpdatePacket>();
        private final int containerId;
        @Nullable
        private class_2540 data;
        private int itemCountOffset = -1;
        private int itemCount;
        @Nullable
        private AEKeyFilter filter;

        public Builder(int containerId, boolean fullUpdate) {
            this.containerId = containerId;
            this.data = fullUpdate ? this.createPacketHeader(true) : null;
        }

        public void setFilter(@Nullable AEKeyFilter filter) {
            this.filter = filter;
        }

        public void addFull(IncrementalUpdateHelper updateHelper, KeyCounter networkStorage, Set<AEKey> craftables, KeyCounter requestables) {
            HashSet<AEKey> keys = new HashSet<AEKey>();
            keys.addAll(networkStorage.keySet());
            keys.addAll(craftables);
            keys.addAll(requestables.keySet());
            for (AEKey key : keys) {
                if (this.filter != null && !this.filter.matches(key)) continue;
                long serial = updateHelper.getOrAssignSerial(key);
                this.add(new GridInventoryEntry(serial, key, networkStorage.get(key), requestables.get(key), craftables.contains(key)));
            }
        }

        public void addChanges(IncrementalUpdateHelper updateHelper, KeyCounter networkStorage, Set<AEKey> craftables, KeyCounter requestables) {
            for (AEKey key : updateHelper) {
                AEKey sendKey;
                if (this.filter != null && !this.filter.matches(key)) continue;
                Long serial = updateHelper.getSerial(key);
                if (serial == null) {
                    sendKey = key;
                    serial = updateHelper.getOrAssignSerial(key);
                } else {
                    sendKey = null;
                }
                long storedAmount = networkStorage.get(key);
                boolean craftable = craftables.contains(key);
                long requestable = requestables.get(key);
                if (storedAmount <= 0L && requestable <= 0L && !craftable) {
                    this.add(new GridInventoryEntry(serial, sendKey, 0L, 0L, false));
                    updateHelper.removeSerial(key);
                    continue;
                }
                this.add(new GridInventoryEntry(serial, sendKey, storedAmount, requestable, craftable));
            }
            updateHelper.commitChanges();
        }

        public void add(GridInventoryEntry entry) {
            class_2540 data = this.ensureData();
            MEInventoryUpdatePacket.writeEntry(data, entry);
            ++this.itemCount;
            if (data.writerIndex() >= 0x20000000 || this.itemCount >= Short.MAX_VALUE) {
                this.flushData();
            }
        }

        private void flushData() {
            if (this.data != null) {
                this.data.markWriterIndex();
                this.data.writerIndex(this.itemCountOffset);
                this.data.writeShort(this.itemCount);
                this.data.resetWriterIndex();
                MEInventoryUpdatePacket packet = new MEInventoryUpdatePacket();
                packet.configureWrite(this.data);
                this.packets.add(packet);
                this.data = null;
                this.itemCountOffset = -1;
                this.itemCount = 0;
            }
        }

        private class_2540 ensureData() {
            if (this.data == null) {
                this.data = this.createPacketHeader(false);
            }
            return this.data;
        }

        private class_2540 createPacketHeader(boolean fullUpdate) {
            class_2540 data = new class_2540(Unpooled.buffer((int)2048));
            data.writeInt(BasePacketHandler.PacketTypes.ME_INVENTORY_UPDATE.getPacketId());
            data.method_10804(this.containerId);
            data.writeBoolean(fullUpdate);
            this.itemCountOffset = data.writerIndex();
            data.writeShort(0);
            return data;
        }

        public List<MEInventoryUpdatePacket> build() {
            this.flushData();
            return this.packets;
        }

        public void buildAndSend(Consumer<MEInventoryUpdatePacket> sender) {
            for (MEInventoryUpdatePacket packet : this.build()) {
                sender.accept(packet);
            }
        }
    }
}

