/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.menu.AEBaseMenu;
import appeng.util.EnumCycler;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public final class ConfigButtonPacket
extends BasePacket {
    private final Setting<?> option;
    private final boolean rotationDirection;

    public ConfigButtonPacket(class_2540 stream) {
        this.option = Settings.getOrThrow(stream.method_19772());
        this.rotationDirection = stream.readBoolean();
    }

    public ConfigButtonPacket(Setting<?> option, boolean rotationDirection) {
        this.option = option;
        this.rotationDirection = rotationDirection;
        class_2540 data = new class_2540(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.method_10814(option.getName());
        data.writeBoolean(rotationDirection);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, class_3222 player) {
        AEBaseMenu baseMenu;
        Object object;
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof AEBaseMenu && (object = (baseMenu = (AEBaseMenu)class_17032).getTarget()) instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)object;
            IConfigManager cm = configurableObject.getConfigManager();
            if (cm.hasSetting(this.option)) {
                this.cycleSetting(cm, this.option);
            } else {
                AELog.info("Ignoring unsupported setting %s sent by client on %s", this.option, baseMenu.getTarget());
            }
        }
    }

    private <T extends Enum<T>> void cycleSetting(IConfigManager cm, Setting<T> setting) {
        T currentValue = cm.getSetting(setting);
        T nextValue = EnumCycler.rotateEnum(currentValue, this.rotationDirection, setting.getValues());
        cm.putSetting(setting, nextValue);
    }
}

