/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.localization;

import appeng.api.config.PowerUnits;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.stacks.GenericStack;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Side;
import appeng.menu.me.interaction.EmptyingAction;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;

public final class Tooltips {
    private static final char SEP;
    public static final class_124 MUTED_COLOR;
    public static final class_2583 NORMAL_TOOLTIP_TEXT;
    public static final class_2583 NUMBER_TEXT;
    public static final class_2583 UNIT_TEXT;
    public static final class_2583 RED;
    public static final class_2583 GREEN;
    public static final String[] units;
    public static final long[] DECIMAL_NUMS;
    public static final long[] BYTE_NUMS;

    private Tooltips() {
    }

    public static List<class_2561> inputSlot(Side ... sides) {
        List<class_2561> sidesText = Arrays.stream(sides).map(Tooltips::side).toList();
        return List.of(ButtonToolTips.CanInsertFrom.text(Tooltips.conjunction(sidesText)).method_27692(MUTED_COLOR));
    }

    public static List<class_2561> outputSlot(Side ... sides) {
        List<class_2561> sidesText = Arrays.stream(sides).map(Tooltips::side).toList();
        return List.of(ButtonToolTips.CanExtractFrom.text(Tooltips.conjunction(sidesText)).method_27692(MUTED_COLOR));
    }

    public static class_2561 side(Side side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Side.BOTTOM -> ButtonToolTips.SideBottom.text();
            case Side.TOP -> ButtonToolTips.SideTop.text();
            case Side.LEFT -> ButtonToolTips.SideLeft.text();
            case Side.RIGHT -> ButtonToolTips.SideRight.text();
            case Side.FRONT -> ButtonToolTips.SideFront.text();
            case Side.BACK -> ButtonToolTips.SideBack.text();
        };
    }

    public static class_2561 conjunction(List<class_2561> components) {
        return Tooltips.list(components, GuiText.And);
    }

    public static class_2561 disjunction(List<class_2561> components) {
        return Tooltips.list(components, GuiText.Or);
    }

    @NotNull
    private static class_2561 list(List<class_2561> components, GuiText lastJoiner) {
        if (components.isEmpty()) {
            return class_2585.field_24366;
        }
        if (components.size() == 2) {
            return components.get(0).method_27661().method_10852((class_2561)lastJoiner.text()).method_10852(components.get(1));
        }
        class_2561 current = components.get(0);
        for (int i = 1; i < components.size(); ++i) {
            current = i + 1 < components.size() ? current.method_27661().method_27693(", ").method_10852(components.get(i)) : current.method_27661().method_27693(", ").method_10852((class_2561)lastJoiner.text()).method_27693(" ").method_10852(components.get(i));
        }
        return current;
    }

    public static List<class_2561> getEmptyingTooltip(ButtonToolTips baseAction, class_1799 carried, EmptyingAction emptyingAction) {
        return List.of(baseAction.text(Tooltips.getMouseButtonText(0), carried.method_7964().method_27661().method_27696(NORMAL_TOOLTIP_TEXT)).method_27692(MUTED_COLOR), baseAction.text(Tooltips.getMouseButtonText(1), emptyingAction.description().method_27661().method_27696(NORMAL_TOOLTIP_TEXT)).method_27692(MUTED_COLOR));
    }

    public static class_2561 getSetAmountTooltip() {
        return ButtonToolTips.ModifyAmountAction.text(Tooltips.getMouseButtonText(2)).method_27692(MUTED_COLOR);
    }

    public static class_2561 getMouseButtonText(int button) {
        return switch (button) {
            case 0 -> ButtonToolTips.LeftClick.text();
            case 1 -> ButtonToolTips.RightClick.text();
            case 2 -> ButtonToolTips.MiddleClick.text();
            default -> new class_2585("Mouse " + button);
        };
    }

    public static boolean shouldShowAmountTooltip(AEKey what, long amount) {
        AEItemKey itemKey;
        long bigNumber = AEConfig.instance().isUseLargeFonts() ? 999L : 9999L;
        return amount > bigNumber * (long)what.getAmountPerUnit() || what.getUnitSymbol() != null || what instanceof AEItemKey && (itemKey = (AEItemKey)what).getItem().method_31567(itemKey.toStack());
    }

    public static class_2561 getAmountTooltip(ButtonToolTips baseText, GenericStack stack) {
        return Tooltips.getAmountTooltip(baseText, stack.what(), stack.amount());
    }

    public static class_2561 getAmountTooltip(ButtonToolTips baseText, AEKey what, long amount) {
        String amountText = what.formatAmount(amount, AmountFormat.FULL);
        return baseText.text(amountText).method_27692(MUTED_COLOR);
    }

    public static class_2561 ofDuration(long number, TimeUnit unit) {
        long minutes;
        long seconds = TimeUnit.SECONDS.convert(number, unit);
        if (seconds == 0L) {
            if (number > 0L) {
                return new class_2585("~").method_27696(NUMBER_TEXT).method_10852((class_2561)ButtonToolTips.DurationFormatSeconds.text(0));
            }
            return ButtonToolTips.DurationFormatSeconds.text(0).method_27696(NUMBER_TEXT);
        }
        class_2585 durationStr = new class_2585("");
        long hours = TimeUnit.HOURS.convert(seconds, TimeUnit.SECONDS);
        if (hours > 0L) {
            durationStr.method_27693(Long.toString(hours)).method_27693("h");
            seconds -= hours * 60L * 60L;
        }
        if ((minutes = TimeUnit.MINUTES.convert(seconds, TimeUnit.SECONDS)) > 0L) {
            durationStr.method_27693(Long.toString(minutes)).method_27693("m");
            seconds -= minutes * 60L;
        }
        if (seconds > 0L) {
            durationStr.method_27693(Long.toString(seconds)).method_27693("s");
        }
        return durationStr.method_27696(NUMBER_TEXT);
    }

    public static class_2561 ofAmount(GenericStack stack) {
        return new class_2585(stack.what().formatAmount(stack.amount(), AmountFormat.FULL)).method_27696(NUMBER_TEXT);
    }

    public static String getAmount(double amount, long num) {
        double fract = amount / (double)num;
        String returned = fract < 10.0 ? String.format("%.3f", fract) : (fract < 100.0 ? String.format("%.2f", fract) : String.format("%.1f", fract));
        while (returned.endsWith("0")) {
            returned = returned.substring(0, returned.length() - 1);
        }
        if (returned.endsWith(String.valueOf(SEP))) {
            returned = returned.substring(0, returned.length() - 1);
        }
        return returned;
    }

    public static Amount getAmount(double amount) {
        if (amount < 10000.0) {
            return new Amount(Tooltips.getAmount(amount, 1L), "");
        }
        int i = 0;
        while (amount / (double)DECIMAL_NUMS[i] >= 1000.0) {
            ++i;
        }
        return new Amount(Tooltips.getAmount(amount, DECIMAL_NUMS[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmount(double amount, double max) {
        if (max < 10000.0) {
            return new MaxedAmount(Tooltips.getAmount(amount, 1L), Tooltips.getAmount(max, 1L), "");
        }
        int i = 0;
        while (max / (double)DECIMAL_NUMS[i] >= 1000.0) {
            ++i;
        }
        return new MaxedAmount(Tooltips.getAmount(amount, DECIMAL_NUMS[i]), Tooltips.getAmount(max, DECIMAL_NUMS[i]), units[i]);
    }

    public static Amount getByteAmount(long amount) {
        int i;
        if (amount < BYTE_NUMS[0]) {
            return new Amount(String.valueOf(amount), "");
        }
        for (i = 0; i < BYTE_NUMS.length && amount / BYTE_NUMS[i] >= 1000L; ++i) {
        }
        return new Amount(Tooltips.getAmount(amount, BYTE_NUMS[i]), units[i]);
    }

    public static Amount getAmount(long amount) {
        int i;
        if (amount < 10000L) {
            return new Amount(String.valueOf(amount), "");
        }
        for (i = 0; i < DECIMAL_NUMS.length && amount / DECIMAL_NUMS[i] >= 1000L; ++i) {
        }
        return new Amount(Tooltips.getAmount(amount, DECIMAL_NUMS[i]), units[i]);
    }

    public static MaxedAmount getMaxedAmount(long amount, long max) {
        if (max < 10000L) {
            return new MaxedAmount(String.valueOf(amount), String.valueOf(max), "");
        }
        int i = 0;
        while (max / DECIMAL_NUMS[i] >= 1000L) {
            ++i;
        }
        return new MaxedAmount(Tooltips.getAmount(amount, DECIMAL_NUMS[i]), Tooltips.getAmount(max, DECIMAL_NUMS[i]), units[i]);
    }

    public static class_5250 of(class_2588 component) {
        return component.method_27661().method_27696(NORMAL_TOOLTIP_TEXT);
    }

    public static class_5250 of(ButtonToolTips buttonToolTips, Object ... args) {
        return Tooltips.of(buttonToolTips, NORMAL_TOOLTIP_TEXT, args);
    }

    public static class_5250 of(ButtonToolTips buttonToolTips, class_2583 style, Object ... args) {
        return buttonToolTips.text(args).method_27661().method_27696(style);
    }

    public static class_5250 of(GuiText guiText, Object ... args) {
        return Tooltips.of(guiText, NORMAL_TOOLTIP_TEXT, args);
    }

    public static class_5250 of(GuiText guiText, class_2583 style, Object ... args) {
        if (args.length > 0 && args[0] instanceof Integer) {
            return guiText.text(Arrays.stream(args).map(o -> Tooltips.ofUnformattedNumber(((Integer)o).intValue())).toArray()).method_27661().method_27696(style);
        }
        if (args.length > 0 && args[0] instanceof Long) {
            return guiText.text(Arrays.stream(args).map(o -> Tooltips.ofUnformattedNumber((Long)o)).toArray()).method_27661().method_27696(style);
        }
        return guiText.text(args).method_27661().method_27696(style);
    }

    public static class_5250 of(String s) {
        return new class_2585(s).method_27696(NORMAL_TOOLTIP_TEXT);
    }

    public static class_5250 of(PowerUnits pU) {
        return pU.textComponent().method_27661().method_27696(UNIT_TEXT);
    }

    public static class_5250 ofPercent(double percent, boolean oneIsGreen) {
        return new class_2585(MessageFormat.format("{0,number,#.##%}", percent)).method_27696(Tooltips.colorFromRatio(percent, oneIsGreen));
    }

    public static class_2583 colorFromRatio(double ratio, boolean oneIsGreen) {
        double p = ratio;
        if (!oneIsGreen) {
            p = 1.0 - p;
        }
        int r = (int)(255.0 * Math.max(0.0, Math.min(2.0 - 2.0 * p, 1.0)));
        int g = (int)(255.0 * Math.max(0.0, Math.min(2.0 * p, 1.0)));
        int rgb = -16777216 + (r << 16) + (g << 8);
        return class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27703(class_5251.method_27717((int)rgb));
    }

    public static class_5250 ofPercent(double percent) {
        return Tooltips.ofPercent(percent, true);
    }

    public static class_5250 ofUnformattedNumber(long number) {
        return new class_2585(String.valueOf(number)).method_27696(NUMBER_TEXT);
    }

    public static class_5250 ofUnformattedNumberWithRatioColor(long number, double ratio, boolean oneIsGreen) {
        return new class_2585(String.valueOf(number)).method_27696(Tooltips.colorFromRatio(ratio, oneIsGreen));
    }

    public static class_5250 ofBytes(long number) {
        Amount amount = Tooltips.getByteAmount(number);
        return Tooltips.ofNumber(amount);
    }

    public static class_5250 ofNumber(long number) {
        Amount amount = Tooltips.getAmount(number);
        return Tooltips.ofNumber(amount);
    }

    public static class_5250 ofNumber(double number) {
        Amount amount = Tooltips.getAmount(number);
        return Tooltips.ofNumber(amount);
    }

    private static class_5250 ofNumber(Amount number) {
        return new class_2585(number.digit() + number.unit()).method_27696(NUMBER_TEXT);
    }

    public static class_5250 ofNumber(long number, long max) {
        MaxedAmount amount = Tooltips.getMaxedAmount(number, max);
        return Tooltips.ofNumber(amount);
    }

    public static class_5250 ofNumber(double number, double max) {
        MaxedAmount amount = Tooltips.getMaxedAmount(number, max);
        return Tooltips.ofNumber(amount);
    }

    private static class_5250 ofNumber(MaxedAmount number) {
        boolean numberUnit = !number.digit().equals("0");
        return new class_2585(number.digit() + (numberUnit ? number.unit() : "")).method_27696(NUMBER_TEXT).method_10852((class_2561)new class_2585("/").method_27696(NORMAL_TOOLTIP_TEXT)).method_27693(number.maxDigit() + number.unit()).method_27696(NUMBER_TEXT);
    }

    public static class_5250 of(class_2561 ... components) {
        class_2585 s = new class_2585("");
        for (class_2561 c : components) {
            s = s.method_10852(c);
        }
        return s;
    }

    public static class_2561 energyStorageComponent(double energy, double max) {
        return Tooltips.of(new class_2561[]{Tooltips.of(GuiText.StoredEnergy, new Object[0]), Tooltips.of(": "), Tooltips.ofNumber(energy, max), Tooltips.of(" "), Tooltips.of(PowerUnits.AE), Tooltips.of(" ("), Tooltips.ofPercent(energy / max), Tooltips.of(")")});
    }

    public static class_2561 bytesUsed(long bytes, long max) {
        return Tooltips.of(new class_2561[]{Tooltips.ofUnformattedNumberWithRatioColor(bytes, (double)bytes / (double)max, false), Tooltips.of(" "), Tooltips.of(GuiText.Of, new Object[0]), Tooltips.of(" "), Tooltips.ofUnformattedNumber(max), Tooltips.of(" "), Tooltips.of(GuiText.BytesUsed, new Object[0])});
    }

    public static class_2561 typesUsed(long types, long max) {
        return Tooltips.of(new class_2561[]{Tooltips.ofUnformattedNumberWithRatioColor(types, (double)types / (double)max, false), Tooltips.of(" "), Tooltips.of(GuiText.Of, new Object[0]), Tooltips.of(" "), Tooltips.ofUnformattedNumber(max), Tooltips.of(" "), Tooltips.of(GuiText.Types, new Object[0])});
    }

    static {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        SEP = symbols.getDecimalSeparator();
        MUTED_COLOR = class_124.field_1063;
        NORMAL_TOOLTIP_TEXT = class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false));
        NUMBER_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)8941311)).method_10978(Boolean.valueOf(false));
        UNIT_TEXT = class_2583.field_24360.method_27703(class_5251.method_27717((int)16768637)).method_10978(Boolean.valueOf(false));
        RED = class_2583.field_24360.method_10977(class_124.field_1061);
        GREEN = class_2583.field_24360.method_10977(class_124.field_1060);
        units = new String[]{"k", "M", "G", "T", "P", "E"};
        DECIMAL_NUMS = new long[]{1000L, 1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
        BYTE_NUMS = new long[]{1024L, 0x100000L, 0x40000000L, 0x40000000L};
    }

    public record Amount(String digit, String unit) {
    }

    public record MaxedAmount(String digit, String maxDigit, String unit) {
    }
}

