/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.client.AEStackRendering;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.client.gui.Icon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class InfoBar {
    private final List<Widget> widgets = new ArrayList<Widget>();

    public void render(class_4587 poseStack, int x, int y, int z) {
        int maxHeight = this.widgets.stream().mapToInt(Widget::getHeight).max().orElse(0);
        for (Widget widget : this.widgets) {
            widget.render(poseStack, x, Math.round((float)y + (float)maxHeight / 2.0f - (float)widget.getHeight() / 2.0f), z);
            x += widget.getWidth();
        }
    }

    void add(Icon icon, float scale) {
        this.widgets.add(new IconWidget(icon, scale));
    }

    void add(String text, int color, float scale) {
        this.widgets.add(new TextWidget((class_2561)new class_2585(text), color, scale));
    }

    void add(class_2561 text, int color, float scale) {
        this.widgets.add(new TextWidget(text, color, scale));
    }

    void add(AEKey what, float scale) {
        this.widgets.add(new StackWidget(what, scale));
    }

    void add(class_1935 what, float scale) {
        this.widgets.add(new StackWidget(AEItemKey.of(what), scale));
    }

    void addSpace(int width) {
        this.widgets.add(new SpaceWidget(width));
    }

    static interface Widget {
        public int getWidth();

        public int getHeight();

        public void render(class_4587 var1, int var2, int var3, int var4);
    }

    private record IconWidget(Icon icon, float scale) implements Widget
    {
        @Override
        public int getWidth() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public int getHeight() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public void render(class_4587 poseStack, int x, int y, int z) {
            poseStack.method_22903();
            poseStack.method_22904((double)x, (double)y, 0.0);
            poseStack.method_22905(this.scale, this.scale, 1.0f);
            this.icon.getBlitter().dest(0, 0).blit(poseStack, z);
            poseStack.method_22909();
        }
    }

    private static final class TextWidget
    implements Widget {
        private final class_2561 text;
        private final int color;
        private final float scale;
        private final int width;
        private final int height;

        public TextWidget(class_2561 text, int color, float scale) {
            this.text = text;
            this.color = color;
            this.scale = scale;
            class_327 font = class_310.method_1551().field_1772;
            this.width = Math.round((float)font.method_27525((class_5348)text) * scale);
            Objects.requireNonNull(font);
            this.height = Math.round(9.0f * scale);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(class_4587 poseStack, int x, int y, int z) {
            class_327 font = class_310.method_1551().field_1772;
            poseStack.method_22903();
            poseStack.method_22904((double)x, (double)y, (double)z);
            poseStack.method_22905(this.scale, this.scale, 1.0f);
            font.method_30883(poseStack, this.text, 0.0f, 0.0f, this.color);
            poseStack.method_22909();
        }
    }

    private record StackWidget(AEKey what, float scale) implements Widget
    {
        @Override
        public int getWidth() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public int getHeight() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public void render(class_4587 poseStack, int x, int y, int z) {
            poseStack.method_22903();
            poseStack.method_22904((double)x, (double)y, (double)z);
            poseStack.method_22905(this.scale, this.scale, 1.0f);
            AEStackRendering.drawInGui(class_310.method_1551(), poseStack, 0, 0, 0, this.what);
            poseStack.method_22909();
        }
    }

    private static final class SpaceWidget
    implements Widget {
        private final int width;

        public SpaceWidget(int width) {
            this.width = width;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public void render(class_4587 poseStack, int x, int y, int z) {
        }
    }
}

