/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.core.definitions.AEItems;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;

public final class InscriberRecipes {
    public static final class_2960 NAMEPLATE_RECIPE_ID = new class_2960("ae2", "nameplate");

    private InscriberRecipes() {
    }

    public static Iterable<InscriberRecipe> getRecipes(class_1937 level) {
        Collection unfilteredRecipes = level.method_8433().method_17717(InscriberRecipe.TYPE).values();
        return Iterables.filter(unfilteredRecipes, InscriberRecipe.class);
    }

    @Nullable
    public static InscriberRecipe findRecipe(class_1937 level, class_1799 input, class_1799 plateA, class_1799 plateB, boolean supportNamePress) {
        if (supportNamePress) {
            boolean isNameA = AEItems.NAME_PRESS.isSameAs(plateA);
            boolean isNameB = AEItems.NAME_PRESS.isSameAs(plateB);
            if (isNameA && isNameB || isNameA && plateB.method_7960()) {
                return InscriberRecipes.makeNamePressRecipe(input, plateA, plateB);
            }
            if (plateA.method_7960() && isNameB) {
                return InscriberRecipes.makeNamePressRecipe(input, plateB, plateA);
            }
        }
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(level)) {
            boolean matchB;
            boolean matchA = recipe.getTopOptional().method_8093(plateA) && recipe.getBottomOptional().method_8093(plateB);
            boolean bl = matchB = recipe.getTopOptional().method_8093(plateB) && recipe.getBottomOptional().method_8093(plateA);
            if (!matchA && !matchB || !recipe.getMiddleInput().method_8093(input)) continue;
            return recipe;
        }
        return null;
    }

    private static InscriberRecipe makeNamePressRecipe(class_1799 input, class_1799 plateA, class_1799 plateB) {
        class_2487 tag;
        Object name = "";
        if (!plateA.method_7960()) {
            tag = plateA.method_7948();
            name = (String)name + tag.method_10558("InscribeName");
        }
        if (!plateB.method_7960()) {
            tag = plateB.method_7948();
            name = (String)name + " " + tag.method_10558("InscribeName");
        }
        class_1856 startingItem = class_1856.method_8101((class_1799[])new class_1799[]{input.method_7972()});
        class_1799 renamedItem = input.method_7972();
        if (!((String)name).isEmpty()) {
            renamedItem.method_7977((class_2561)new class_2585((String)name));
        } else {
            renamedItem.method_7977(null);
        }
        InscriberProcessType type = InscriberProcessType.INSCRIBE;
        return new InscriberRecipe(NAMEPLATE_RECIPE_ID, startingItem, renamedItem, plateA.method_7960() ? class_1856.field_9017 : class_1856.method_8101((class_1799[])new class_1799[]{plateA}), plateB.method_7960() ? class_1856.field_9017 : class_1856.method_8101((class_1799[])new class_1799[]{plateB}), type);
    }

    public static boolean isValidOptionalIngredientCombination(class_1937 level, class_1799 pressA, class_1799 pressB) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(level)) {
            if ((!recipe.getTopOptional().method_8093(pressA) || !recipe.getBottomOptional().method_8093(pressB)) && (!recipe.getTopOptional().method_8093(pressB) || !recipe.getBottomOptional().method_8093(pressA))) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOptionalIngredient(class_1937 level, class_1799 is) {
        for (InscriberRecipe recipe : InscriberRecipes.getRecipes(level)) {
            if (!recipe.getTopOptional().method_8093(is) && !recipe.getBottomOptional().method_8093(is)) continue;
            return true;
        }
        return false;
    }
}

