/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.parts;

import appeng.api.parts.CableRenderMode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlockEntities;
import appeng.core.definitions.AEBlocks;
import appeng.parts.PartPlacement;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public final class PartHelper {
    private PartHelper() {
    }

    public static class_1269 usePartItem(class_1838 context) {
        return PartPlacement.place(context);
    }

    @Nullable
    public static <T extends IPart> T getPart(IPartItem<T> partItem, class_1922 level, class_2338 pos, @Nullable class_2350 side) {
        Class<T> partClass;
        IPart part = PartHelper.getPart(level, pos, side);
        if (part != null && (partClass = partItem.getPartClass()).isInstance(part)) {
            return (T)((IPart)partClass.cast(part));
        }
        return null;
    }

    @Nullable
    public static IPart getPart(class_1922 level, class_2338 pos, @Nullable class_2350 side) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof IPartHost) {
            IPartHost partHost = (IPartHost)be;
            return partHost.getPart(side);
        }
        return null;
    }

    @Nullable
    public static <T extends IPart> T setPart(class_3218 level, class_2338 pos, @Nullable class_2350 side, @Nullable class_1657 player, IPartItem<T> partItem) {
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(pos, "pos");
        IPartHost host = PartHelper.getOrPlacePartHost((class_1937)level, pos, true, null);
        if (host == null) {
            return null;
        }
        T part = host.replacePart(partItem, side, player, null);
        if (host.isEmpty()) {
            host.cleanup();
        }
        return part;
    }

    @Nullable
    public static IPartHost getOrPlacePartHost(class_1937 level, class_2338 pos, boolean force, @Nullable class_1657 player) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof IPartHost) {
            IPartHost partHost = (IPartHost)blockEntity;
            return partHost;
        }
        if (!force && !PartHelper.canPlacePartHost(player, level, pos)) {
            return null;
        }
        class_2680 state = AEBlocks.CABLE_BUS.block().getStateForPlacement(level, pos);
        level.method_8501(pos, state);
        return level.method_35230(pos, AEBlockEntities.CABLE_BUS).orElse(null);
    }

    @Nullable
    public static IPartHost placePartHost(@Nullable class_1657 player, class_1937 level, class_2338 pos) {
        if (!PartHelper.canPlacePartHost(player, level, pos)) {
            return null;
        }
        class_2680 state = AEBlocks.CABLE_BUS.block().getStateForPlacement(level, pos);
        level.method_8501(pos, state);
        return level.method_35230(pos, AEBlockEntities.CABLE_BUS).orElse(null);
    }

    public static boolean canPlacePartHost(@Nullable class_1657 player, class_1937 level, class_2338 pos) {
        if (player != null && !level.method_8505(player, pos)) {
            return false;
        }
        return level.method_22347(pos) || level.method_8320(pos).method_26207().method_15800();
    }

    @Nullable
    public static IPartHost getPartHost(class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof IPartHost) {
            IPartHost partHost = (IPartHost)blockEntity;
            return partHost;
        }
        return null;
    }

    public static CableRenderMode getCableRenderMode() {
        return AppEng.instance().getCableRenderMode();
    }
}

