/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.api.features.IPlayerRegistry;
import appeng.core.AELog;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

final class PlayerRegistryInternal
extends class_18
implements IPlayerRegistry {
    private static final String NAME = "ae2_players";
    private static final String TAG_PLAYER_IDS = "playerIds";
    private static final String TAG_PROFILE_IDS = "profileIds";
    private final BiMap<UUID, Integer> mapping = HashBiMap.create();
    private final MinecraftServer server;
    private int nextPlayerId = 0;

    private PlayerRegistryInternal(MinecraftServer server) {
        this.server = server;
    }

    static PlayerRegistryInternal get(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_3218.field_25179);
        if (overworld == null) {
            throw new IllegalStateException("Cannot retrieve player data for a server that has no overworld.");
        }
        return (PlayerRegistryInternal)overworld.method_17983().method_17924(nbt -> PlayerRegistryInternal.load(server, nbt), () -> new PlayerRegistryInternal(server), NAME);
    }

    @Override
    @Nullable
    public UUID getProfileId(int playerId) {
        return (UUID)this.mapping.inverse().get((Object)playerId);
    }

    @Override
    public int getPlayerId(UUID profileId) {
        Objects.requireNonNull(profileId, "profileId");
        Integer playerId = (Integer)this.mapping.get((Object)profileId);
        if (playerId == null) {
            playerId = this.nextPlayerId++;
            this.mapping.put((Object)profileId, (Object)playerId);
            this.method_80();
            class_3222 player = this.server.method_3760().method_14602(profileId);
            String name = player != null ? player.method_7334().getName() : "[UNKNOWN]";
            AELog.info("Assigning ME player id %s to Minecraft profile %s (%s)", playerId, profileId, name);
        }
        return playerId;
    }

    private static PlayerRegistryInternal load(MinecraftServer server, class_2487 nbt) {
        long[] profileIds;
        int[] playerIds = nbt.method_10561(TAG_PLAYER_IDS);
        if (playerIds.length * 2 != (profileIds = nbt.method_10565(TAG_PROFILE_IDS)).length) {
            throw new IllegalStateException("Plaer ID mapping is corrupted. " + playerIds.length + " player IDs vs. " + profileIds.length + " profile IDs (latter must be 2 * the former)");
        }
        PlayerRegistryInternal result = new PlayerRegistryInternal(server);
        int highestPlayerId = -1;
        for (int i = 0; i < playerIds.length; ++i) {
            int playerId = playerIds[i];
            UUID profileId = new UUID(profileIds[i * 2], profileIds[i * 2 + 1]);
            highestPlayerId = Math.max(playerId, highestPlayerId);
            result.mapping.put((Object)profileId, (Object)playerId);
            AELog.debug("AE player ID %s is assigned to profile ID %s", playerId, profileId);
        }
        result.nextPlayerId = highestPlayerId + 1;
        return result;
    }

    public class_2487 method_75(class_2487 compound) {
        int index = 0;
        int[] playerIds = new int[this.mapping.size()];
        long[] profileIds = new long[this.mapping.size() * 2];
        for (Map.Entry entry : this.mapping.entrySet()) {
            profileIds[index * 2] = ((UUID)entry.getKey()).getMostSignificantBits();
            profileIds[index * 2 + 1] = ((UUID)entry.getKey()).getLeastSignificantBits();
            playerIds[index++] = (Integer)entry.getValue();
        }
        compound.method_10539(TAG_PLAYER_IDS, playerIds);
        compound.method_10564(TAG_PROFILE_IDS, profileIds);
        return compound;
    }
}

