/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.network.packets.cts;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.ESide;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class AdvancedDisplayUpdatePacket
implements IPacketBase<AdvancedDisplayUpdatePacket> {
    private class_2338 pos;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey key;
    private boolean doubleSided;
    private IDisplaySettings settings;

    public AdvancedDisplayUpdatePacket() {
    }

    public AdvancedDisplayUpdatePacket(class_1937 level, class_2338 pos, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
        this.apply(level, this);
    }

    protected AdvancedDisplayUpdatePacket(class_2338 pos, AdvancedDisplaysRegistry.DisplayTypeResourceKey key, boolean doubleSided, IDisplaySettings settings) {
        this.pos = pos;
        this.key = key;
        this.doubleSided = doubleSided;
        this.settings = settings;
    }

    public void encode(AdvancedDisplayUpdatePacket packet, class_2540 buffer) {
        class_2487 k = new class_2487();
        packet.key.toNbt(k);
        buffer.method_10807(packet.pos);
        buffer.method_10794(k);
        buffer.writeBoolean(packet.doubleSided);
        buffer.method_10794(packet.settings.serializeNbt());
    }

    public AdvancedDisplayUpdatePacket decode(class_2540 buffer) {
        class_2338 pos = buffer.method_10811();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey key = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(buffer.method_10798());
        boolean doubleSided = buffer.readBoolean();
        IDisplaySettings settings = AdvancedDisplaysRegistry.createSettings(key);
        settings.deserializeNbt(buffer.method_10798());
        return new AdvancedDisplayUpdatePacket(pos, key, doubleSided, settings);
    }

    private void apply(class_1937 level, AdvancedDisplayUpdatePacket packet) {
        class_2586 class_25862;
        if (level.method_8477(packet.pos) && (class_25862 = level.method_8321(packet.pos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity = (AdvancedDisplayBlockEntity)class_25862;
            blockEntity.applyToAll(be -> {
                be.setDisplayType(packet.key, packet.settings);
                if (level.method_8320(be.method_11016()).method_26204() instanceof AbstractAdvancedSidedDisplayBlock) {
                    class_2680 state = level.method_8320(be.method_11016());
                    state = (class_2680)state.method_11657(AbstractAdvancedSidedDisplayBlock.SIDE, (Comparable)((Object)(packet.doubleSided ? ESide.BOTH : ESide.FRONT)));
                    level.method_8501(be.method_11016(), state);
                }
                be.notifyUpdate();
            });
        }
    }

    public void handle(AdvancedDisplayUpdatePacket packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            class_1657 player = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer();
            if (player != null) {
                class_1937 level = player.method_37908();
                this.apply(level, packet);
            }
        });
    }
}

