/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.debug;

import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.debug.TrainDebugState;
import java.util.UUID;
import net.minecraft.class_2487;

public record TrainDebugData(UUID sessionId, UUID trainId, String trainName, int totalDuration, int predictionsCount, int predictionsInitialized, TrainDebugState state) {
    private static final String NBT_SESSION_ID = "SessionId";
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_DURATION = "Duration";
    private static final String NBT_PREDICTIONS = "Predictions";
    private static final String NBT_INITIALIZED_PREDICTIONS = "InitializedPredictions";
    private static final String NBT_STATE = "State";

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927(NBT_SESSION_ID, this.sessionId);
        nbt.method_25927(NBT_ID, this.trainId);
        nbt.method_10582(NBT_NAME, this.trainName);
        nbt.method_10569(NBT_DURATION, this.totalDuration);
        nbt.method_10569(NBT_PREDICTIONS, this.predictionsCount);
        nbt.method_10569(NBT_INITIALIZED_PREDICTIONS, this.predictionsInitialized);
        nbt.method_10567(NBT_STATE, this.state.getId());
        return nbt;
    }

    public static TrainDebugData fromNbt(class_2487 nbt) {
        return new TrainDebugData(nbt.method_25926(NBT_SESSION_ID), nbt.method_25926(NBT_ID), nbt.method_10558(NBT_NAME), nbt.method_10550(NBT_DURATION), nbt.method_10550(NBT_PREDICTIONS), nbt.method_10550(NBT_INITIALIZED_PREDICTIONS), TrainDebugState.getStateById(nbt.method_10571(NBT_STATE)));
    }

    public static TrainDebugData fromTrain(TrainData train) {
        return new TrainDebugData(train.getSessionId(), train.getTrainId(), train.getTrainName(), train.getTotalDuration(), train.getPredictionsRaw().size(), train.debug_initializedStationsCount(), train.isPreparing() ? TrainDebugState.PREPARING : (train.isInitialized() ? TrainDebugState.READY : TrainDebugState.INITIALIZING));
    }
}

