/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class NextConnectionsDisplayData {
    private final List<TrainStopDisplayData> stops;
    private static final String NBT_STOPS = "Stops";

    public NextConnectionsDisplayData(List<TrainStopDisplayData> stops) {
        this.stops = stops;
    }

    public static NextConnectionsDisplayData empty() {
        return new NextConnectionsDisplayData(List.of());
    }

    public static NextConnectionsDisplayData at(String stationName, UUID selfTrainId) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        List<TrainStop> departures = TrainUtils.getDeparturesAt(GlobalSettings.getInstance().getOrCreateStationTagFor(TagName.of(stationName)), selfTrainId);
        ArrayList<TrainStopDisplayData> displayData = new ArrayList<TrainStopDisplayData>(departures.size());
        for (TrainStop stop : departures) {
            displayData.add(TrainStopDisplayData.of(stop));
        }
        return new NextConnectionsDisplayData(displayData);
    }

    public List<TrainStopDisplayData> getConnections() {
        return this.stops;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        List<TrainStopDisplayData> displayData = this.stops;
        for (TrainStopDisplayData d : displayData) {
            list.add((Object)d.toNbt());
        }
        nbt.method_10566(NBT_STOPS, (class_2520)list);
        return nbt;
    }

    public static NextConnectionsDisplayData fromNbt(class_2487 nbt) {
        return new NextConnectionsDisplayData(nbt.method_10554(NBT_STOPS, 10).stream().map(x -> TrainStopDisplayData.fromNbt((class_2487)x)).toList());
    }
}

