/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.StationDepartureHistory;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.event.events.CreateTrainPredictionEvent;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPost;
import de.mrjulsen.crn.event.events.GlobalTrainDisplayDataRefreshEventPre;
import de.mrjulsen.crn.event.events.ScheduleResetEvent;
import de.mrjulsen.crn.event.events.SubmitTrainPredictionsEvent;
import de.mrjulsen.crn.event.events.TotalDurationTimeChangedEvent;
import de.mrjulsen.crn.event.events.TrainArrivalAndDepartureEvent;
import de.mrjulsen.crn.event.events.TrainDestinationChangedEvent;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_5218;

public final class TrainListener {
    private static final transient String FILENAME = "createrailwaysnavigator_train_data.nbt";
    public static final ConcurrentHashMap<UUID, TrainData> data = new ConcurrentHashMap();
    private static transient boolean trainDataListenerActive = false;
    private static transient long currentTrainDataListenerId = 0L;
    private static final transient Queue<Runnable> trainDataHookTasks = new ConcurrentLinkedQueue<Runnable>();

    public static void init() {
        CRNEventsManager.getEvent(GlobalTrainDisplayDataRefreshEventPre.class).register("createrailwaysnavigator", () -> TrainListener.queueTrainListenerTask(() -> {
            try {
                StationDepartureHistory.cleanUpDepartureHistory();
                TrainListener.refreshPre();
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#GlobalTrainDisplayDataRefreshEventPre': " + e.getMessage(), (Throwable)e);
            }
        }));
        CRNEventsManager.getEvent(GlobalTrainDisplayDataRefreshEventPost.class).register("createrailwaysnavigator", () -> TrainListener.queueTrainListenerTask(() -> {
            try {
                TrainUtils.refreshCache();
                TrainListener.refreshPost();
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#GlobalTrainDisplayDataRefreshEventPost': " + e.getMessage(), (Throwable)e);
            }
        }));
        CRNEventsManager.getEvent(TrainDestinationChangedEvent.class).register("createrailwaysnavigator", (train, current, next, nextIndex) -> {});
        CRNEventsManager.getEvent(TotalDurationTimeChangedEvent.class).register("createrailwaysnavigator", (train, old, newDuration) -> {
            if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                CreateRailwaysNavigator.LOGGER.info("The total duration of the train " + train.name.getString() + " (" + String.valueOf(train.id) + ") has changed from " + old + " Ticks to " + newDuration + " Ticks. This will result in changes to the scheduled departure times!");
            }
        });
        CRNEventsManager.getEvent(TrainArrivalAndDepartureEvent.class).register("createrailwaysnavigator", (train, station, isArrival) -> {
            long reachTime = DragonLib.getCurrentWorldTime();
            int ticksInTransit = ((ScheduleRuntimeAccessor)train.runtime).crn$getTicksInTransit();
            TrainListener.queueTrainListenerTask(() -> {
                try {
                    if (TrainUtils.canReadTrainSchedule(train)) {
                        if (data.containsKey(train.id) && train.runtime != null) {
                            if (isArrival) {
                                data.get(train.id).reachDestination(reachTime, ticksInTransit);
                            } else {
                                data.get(train.id).leaveDestination();
                            }
                        }
                    } else if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                        DragonLib.LOGGER.warn("Cannot run train listener task 'TrainListener#TrainArrivalAndDepartureEvent:1'. Unable to read the train schedule of train " + String.valueOf(train == null ? "null" : train.id) + ".");
                    }
                    if (TrainUtils.canReadTrainNavigation(train)) {
                        if (!isArrival && station.isPresent() && !((INavigationExtension)train.navigation).isDelayedWaitConditionPending()) {
                            StationDepartureHistory.updateDepartureHistory(train, ((GlobalStation)station.get()).name);
                        }
                    } else if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                        DragonLib.LOGGER.warn("Cannot run train listener task 'TrainListener#TrainArrivalAndDepartureEvent:2'. Unable to read the train navigation of train " + String.valueOf(train == null ? "null" : train.id) + ".");
                    }
                }
                catch (Exception e) {
                    DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#TrainArrivalAndDepartureEvent': " + e.getMessage(), (Throwable)e);
                }
            });
        });
        CRNEventsManager.getEvent(ScheduleResetEvent.class).register("createrailwaysnavigator", (train, soft) -> TrainListener.queueTrainListenerTask(() -> {
            try {
                if (data.containsKey(train.id)) {
                    TrainData trainData = data.get(train.id);
                    if (soft) {
                        trainData.resetPredictions();
                    } else {
                        trainData.hardResetPredictions();
                    }
                }
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#ScheduleResetEvent': " + e.getMessage(), (Throwable)e);
            }
        }));
        CRNEventsManager.getEvent(SubmitTrainPredictionsEvent.class).register("createrailwaysnavigator", (train, predictions, entryCount, accumulatedTime, current) -> {});
        CRNEventsManager.getEvent(CreateTrainPredictionEvent.class).register("createrailwaysnavigator", (train, schedule, predictables, index, stayDuration, minStayDuration, prediction) -> TrainListener.queueTrainListenerTask(() -> {
            if (!TrainUtils.canReadTrainSchedule(train)) {
                if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                    DragonLib.LOGGER.warn("Cannot run train listener task 'TrainListener#CreateTrainPredictionEvent'. Unable to read the train schedule of train " + String.valueOf(train == null ? "null" : train.id) + ".");
                }
                return;
            }
            try {
                ScheduleRuntimeAccessor accessor = (ScheduleRuntimeAccessor)schedule;
                UUID trainId = accessor.crn$getTrain().id;
                if (data.containsKey(trainId) && prediction != null) {
                    TrainData trainData = data.get(trainId);
                    TrainPrediction pred = trainData.setPredictionData(index, schedule.currentEntry, schedule.getSchedule().entries.size(), stayDuration, minStayDuration, accessor.crn$predictionTicks().get(index), prediction);
                    predictables.values().forEach(x -> x.predictForStation(trainData, pred, schedule, index, accessor.crn$getTrain()));
                }
            }
            catch (Exception e) {
                DragonLib.LOGGER.error("Cannot run train listener task 'TrainListener#CreateTrainPredictionEvent': " + e.getMessage(), (Throwable)e);
            }
        }));
    }

    public static Set<Train> getAllTrains() {
        HashSet<Train> result = new HashSet<Train>(data.size());
        for (TrainData v : data.values()) {
            result.add(v.getTrain());
        }
        return result;
    }

    public static boolean allTrainsInitialized() {
        for (TrainData data : TrainListener.data.values()) {
            if (GlobalSettings.getInstance().isTrainBlacklisted(data.getTrain()) || data.getPredictionsRaw().isEmpty() || data.getTrain().runtime.paused || data.getTrain().derailed || data.getTrain().runtime.completed || !TrainUtils.isTrainValid(data.getTrain()) || data.isInitialized() && !data.isPreparing()) continue;
            return false;
        }
        return true;
    }

    public static void start() {
        new Thread(() -> {
            long id;
            TrainListener.init();
            while (currentTrainDataListenerId == (id = System.nanoTime())) {
            }
            currentTrainDataListenerId = id;
            trainDataListenerActive = true;
            trainDataHookTasks.clear();
            data.clear();
            try {
                TrainListener.load();
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.error("Unable to load train listener data.", (Throwable)e);
            }
            long threadId = id;
            new Thread(() -> {
                try {
                    while (currentTrainDataListenerId == threadId && trainDataListenerActive) {
                        while (!trainDataHookTasks.isEmpty()) {
                            try {
                                trainDataHookTasks.poll().run();
                            }
                            catch (Exception e) {
                                CreateRailwaysNavigator.LOGGER.error("Error while executing train listener task.", (Throwable)e);
                            }
                        }
                        try {
                            TimeUnit.SECONDS.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            CreateRailwaysNavigator.LOGGER.error("Error while waiting for next task.", (Throwable)e);
                        }
                    }
                    TrainListener.save();
                    data.clear();
                    trainDataHookTasks.clear();
                    CreateRailwaysNavigator.LOGGER.info("Train listener has been stopped.");
                }
                catch (Exception e) {
                    CreateRailwaysNavigator.LOGGER.error("Error while executing Train Listener.", (Throwable)e);
                }
            }, "CRN Train Listener").start();
            CreateRailwaysNavigator.LOGGER.info("Train listener has been started.");
        }, "CRN Train Listener Launcher").start();
    }

    public static void stop() {
        trainDataListenerActive = false;
        CreateRailwaysNavigator.LOGGER.info("Stopping train listener...");
    }

    public static synchronized void save() {
        if (!trainDataListenerActive) {
            return;
        }
        class_2487 nbt = new class_2487();
        data.entrySet().forEach(x -> nbt.method_10566(((UUID)x.getKey()).toString(), (class_2520)((TrainData)x.getValue()).toNbt()));
        try {
            class_2507.method_30614((class_2487)nbt, (File)new File(ModCommonEvents.getCurrentServer().get().method_27050(new class_5218("data/createrailwaysnavigator_train_data.nbt")).toString()));
            CreateRailwaysNavigator.LOGGER.debug("Saved train listener data.");
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save train listener data.", (Throwable)e);
        }
    }

    private static void load() throws IOException {
        File settingsFile = new File(ModCommonEvents.getCurrentServer().get().method_27050(new class_5218("data/createrailwaysnavigator_train_data.nbt")).toString());
        if (!settingsFile.exists()) {
            return;
        }
        class_2487 nbt = class_2507.method_30613((File)settingsFile);
        for (String key : nbt.method_10541()) {
            try {
                UUID id = UUID.fromString(key);
                TrainData.fromNbt(nbt.method_10562(key)).ifPresent(x -> data.put(id, (TrainData)x));
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.warn("Unable to read train listener train data with ID '" + key + "'. " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void queueTrainListenerTask(Runnable task) {
        trainDataHookTasks.add(task);
    }

    public static synchronized void refreshPre() {
        if (!trainDataListenerActive) {
            return;
        }
        Set<Train> trains = TrainUtils.getTrains(true);
        Iterator<Train> iterator = trains.iterator();
        while (iterator.hasNext()) {
            Train train = iterator.next();
            if (GlobalSettings.getInstance().isTrainBlacklisted(train)) {
                iterator.remove();
                data.remove(train.id);
                continue;
            }
            data.computeIfAbsent(train.id, x -> TrainData.of(train)).refreshPre();
        }
    }

    public static synchronized void refreshPost() {
        if (!trainDataListenerActive) {
            return;
        }
        for (TrainData train : data.values()) {
            train.refreshPost();
        }
    }

    public static synchronized void tick() {
        if (!trainDataListenerActive) {
            return;
        }
        for (TrainData train : data.values()) {
            train.tick();
        }
    }
}

