/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import com.simibubi.create.content.trains.entity.Train;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.TrainInfo;
import de.mrjulsen.crn.data.schedule.condition.DynamicDelayCondition;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.CRNEventsManager;
import de.mrjulsen.crn.event.events.TotalDurationTimeChangedEvent;
import de.mrjulsen.crn.mixin.ScheduleRuntimeAccessor;
import de.mrjulsen.crn.util.IListenable;
import de.mrjulsen.crn.util.LockedList;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.Cache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class TrainData
implements IListenable<TrainData> {
    private static final transient int VERSION = 1;
    public static final transient String EVENT_TOTAL_DURATION_CHANGED = "total_duration_changed";
    public static final transient String EVENT_SECTION_CHANGED = "section_changed";
    public static final transient String EVENT_DESTINATION_CHANGED = "destination_changed";
    public static final transient String EVENT_STATION_REACHED = "station_reached";
    private static final transient String NBT_VERSION = "Version";
    private static final transient String NBT_ID = "SessionId";
    private static final transient String NBT_TRAIN_ID = "TrainId";
    private static final transient String NBT_PREDICTIONS = "Predictions";
    private static final transient String NBT_CURRENT_SCHEDULE_INDEX = "CurrentScheduleIndex";
    private static final transient String NBT_LINE_ID = "LineId";
    private static final transient String NBT_LAST_DELAY_OFFSET = "LastDelay";
    private static final transient String NBT_CANCELLED = "Cancelled";
    private static final transient String NBT_TRANSIT_TIMES = "TransitTimes";
    private static final transient int INVALID = -1;
    private final transient Map<String, IdentityHashMap<Object, Consumer<TrainData>>> listeners = new HashMap<String, IdentityHashMap<Object, Consumer<TrainData>>>();
    private final transient Train train;
    private UUID sessionId;
    private final ConcurrentHashMap<Integer, TrainPrediction> predictionsByIndex = new ConcurrentHashMap();
    private final transient ConcurrentHashMap<Integer, TrainTravelSection> sectionsByIndex = new ConcurrentHashMap();
    private final transient Cache<TrainTravelSection> defaultSection = new Cache(() -> TrainTravelSection.def(this), ECachingPriority.LOW);
    private final transient List<TrainPrediction> predictionsChronologically = new LockedList<TrainPrediction>();
    private final transient Set<Integer> validPredictionEntries = new HashSet<Integer>();
    private final transient Cache<Boolean> isDynamic = new Cache(() -> this.getTrain() != null && this.getTrain().runtime != null && this.getTrain().runtime.getSchedule() != null && this.getTrain().runtime.getSchedule().entries.stream().anyMatch(x -> x.conditions.stream().flatMap(y -> y.stream()).anyMatch(y -> {
        DynamicDelayCondition c;
        return y instanceof DynamicDelayCondition && (c = (DynamicDelayCondition)((Object)((Object)((Object)y)))).minWaitTicks() < c.totalWaitTicks();
    })));
    private int currentScheduleIndex = -1;
    private transient int currentTravelSectionIndex = -1;
    private transient int lastScheduleIndex = -1;
    private String lineId;
    private transient int totalDuration = -1;
    private transient long destinationReachTime;
    private transient boolean isAtStation = false;
    private transient boolean wasWaitingForSignal = false;
    public transient UUID waitingForSignalId;
    public final transient Set<Train> occupyingTrains = new HashSet<Train>();
    public transient int waitingForSignalTicks;
    public transient boolean isManualControlled;
    public transient int transitTime = 0;
    private final transient Map<Integer, Integer> measuredTransitTimes = new HashMap<Integer, Integer>();
    public final Map<Integer, Queue<Integer>> transitTimeHistory = new HashMap<Integer, Queue<Integer>>();
    public final Map<Integer, Integer> currentTransitTime = new HashMap<Integer, Integer>();
    private long lastSectionDelayOffset;
    private boolean cancelled = false;
    private final transient Map<UUID, Integer> delaysBySignal = new HashMap<UUID, Integer>();
    private final Set<class_2960> currentStatusInfos = new HashSet<class_2960>();
    private int refreshTimingsCounter = 0;
    private transient boolean hardResetPredictions = false;
    private transient boolean initializationFinishTask = false;
    private transient boolean initializationCompleted = false;
    private boolean hasStarted = false;
    private boolean sectionChanged;
    private boolean destinationChanged;
    private final Cache<Boolean> isDelayedCache = new Cache(() -> {
        for (TrainPrediction pred : this.predictionsChronologically) {
            if (!pred.isAnyDelayed()) continue;
            return true;
        }
        return false;
    });
    private final Cache<Long> highestDeviationCache = new Cache(() -> {
        long max = 0L;
        for (TrainPrediction pred : this.predictionsByIndex.values()) {
            long m = Math.max(pred.getArrivalTimeDeviation(), pred.getDepartureTimeDeviation());
            if (m <= max) continue;
            max = m;
        }
        return max;
    });
    private final Cache<TrainTravelSection> currentSectionCache = new Cache(() -> this.currentTravelSectionIndex < 0 || !this.hasCustomTravelSections() || !this.sectionsByIndex.containsKey(this.currentTravelSectionIndex) ? (TrainTravelSection)this.defaultSection.get() : this.sectionsByIndex.get(this.currentTravelSectionIndex));
    private final Cache<List<TrainTravelSection>> sectionsCache = new Cache(() -> this.sectionsByIndex.isEmpty() ? List.of((TrainTravelSection)this.defaultSection.get()) : this.sectionsByIndex.values().stream().sorted((a, b) -> Integer.compare(a.getScheduleIndex(), b.getScheduleIndex())).toList());

    private TrainData(Train train, UUID sessionId) {
        this.train = train;
        this.sessionId = sessionId;
        this.totalDuration = -1;
        this.createEvent(EVENT_TOTAL_DURATION_CHANGED);
        this.createEvent(EVENT_DESTINATION_CHANGED);
        this.createEvent(EVENT_SECTION_CHANGED);
        this.createEvent(EVENT_STATION_REACHED);
    }

    public static Optional<TrainData> of(UUID trainId) {
        Optional<Train> train = TrainUtils.getTrain(trainId);
        if (train.isPresent()) {
            return Optional.of(new TrainData(train.get(), UUID.randomUUID()));
        }
        return Optional.empty();
    }

    public static TrainData of(Train train) {
        return new TrainData(train, UUID.randomUUID());
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getTrainId() {
        return this.getTrain().id;
    }

    public Train getTrain() {
        return this.train;
    }

    public TrainInfo getTrainInfo(int scheduleIndex) {
        return new TrainInfo(this.getSectionForIndex(scheduleIndex).getTrainLine().orElse(null), this.getSectionForIndex(scheduleIndex).getTrainGroup().orElse(null));
    }

    public boolean isDynamic() {
        return (Boolean)this.isDynamic.get();
    }

    private int getHistoryBufferSize() {
        return (Integer)ModCommonConfig.TOTAL_DURATION_BUFFER_SIZE.get() * 2 + 1;
    }

    public boolean isAtStation() {
        return this.train.navigation.destination == null;
    }

    public long waitingAtStationTicks() {
        return this.isAtStation() ? DragonLib.getCurrentWorldTime() - this.destinationReachTime : 0L;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getTotalDuration() {
        return this.totalDuration;
    }

    public int getTransitTicks() {
        return this.transitTime;
    }

    public int getTransitTimeOf(int scheduleIndex) {
        return this.currentTransitTime.containsKey(scheduleIndex) ? this.currentTransitTime.get(scheduleIndex) : -1;
    }

    public boolean isWaitingAtStation() {
        return this.isAtStation;
    }

    public TrainTravelSection getSectionByIndex(int scheduleIndex) {
        return this.sectionsByIndex.isEmpty() ? (TrainTravelSection)this.defaultSection.get() : this.sectionsByIndex.get(scheduleIndex);
    }

    public void addTravelSection(TrainTravelSection section) {
        this.sectionsByIndex.put(section.getScheduleIndex(), section);
        this.sectionsCache.clear();
        this.currentSectionCache.clear();
    }

    public String getCurrentTitle() {
        return this.predictionsByIndex.containsKey(this.currentScheduleIndex) ? this.predictionsByIndex.get(this.currentScheduleIndex).getTitle() : "";
    }

    public String getTrainName() {
        return this.train.name.getString();
    }

    public String getTrainDisplayName() {
        return this.getCurrentSection() == null || this.getCurrentSection().getTrainLine().map(x -> x.getLineName().isEmpty()).orElse(true) != false ? this.getTrainName() : this.getCurrentSection().getTrainLine().get().getLineName();
    }

    public int getCurrentScheduleIndex() {
        return this.currentScheduleIndex;
    }

    public boolean hasCustomTravelSections() {
        return !this.sectionsByIndex.isEmpty();
    }

    public boolean isSingleSection() {
        return this.sectionsByIndex.size() <= 1;
    }

    public List<TrainTravelSection> getSections() {
        return (List)this.sectionsCache.get();
    }

    public TrainTravelSection getSectionForIndex(int anyIndex) {
        if (this.isSingleSection()) {
            return this.getSections().get(0);
        }
        TrainTravelSection selectedSection = this.getSections().get(this.getSections().size() - 1);
        for (TrainTravelSection section : this.getSections()) {
            if (section.getScheduleIndex() > anyIndex) break;
            selectedSection = section;
        }
        return selectedSection;
    }

    public synchronized List<TrainPrediction> getPredictions() {
        return new ArrayList<TrainPrediction>(this.predictionsByIndex.values());
    }

    public synchronized Map<Integer, TrainPrediction> getPredictionsRaw() {
        return new HashMap<Integer, TrainPrediction>(this.predictionsByIndex);
    }

    public synchronized List<TrainPrediction> getPredictionsChronologically() {
        return new ArrayList<TrainPrediction>(this.predictionsChronologically);
    }

    public synchronized Optional<TrainPrediction> getNextStopPrediction() {
        return this.predictionsChronologically.isEmpty() ? Optional.empty() : Optional.ofNullable(this.predictionsChronologically.get(0));
    }

    public void resetPredictions() {
        for (TrainPrediction pred : this.predictionsByIndex.values()) {
            pred.reset();
        }
        this.lastSectionDelayOffset = 0L;
        this.refreshTimingsCounter = 0;
        this.resetStatus(true);
        this.isDynamic.clear();
        if (CreateRailwaysNavigator.isDebug() || ((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
            CreateRailwaysNavigator.LOGGER.info(this.getTrainName() + " has reset their scheduled times.");
        }
    }

    public void hardResetPredictions() {
        this.hardResetPredictions = true;
    }

    public synchronized boolean isDelayed() {
        return (Boolean)this.isDelayedCache.get();
    }

    public boolean isCurrentSectionDelayed() {
        return this.isDelayed() && this.getHighestDeviation() - this.lastSectionDelayOffset > (long)((Integer)ModCommonConfig.SCHEDULE_DEVIATION_THRESHOLD.get()).intValue();
    }

    public long getHighestDeviation() {
        return (Long)this.highestDeviationCache.get();
    }

    public long getDeviationDelayOffset() {
        return this.lastSectionDelayOffset;
    }

    public TrainTravelSection getCurrentSection() {
        return (TrainTravelSection)this.currentSectionCache.get();
    }

    public Map<UUID, Integer> getWaitingForSignalsTime() {
        return new HashMap<UUID, Integer>(this.delaysBySignal);
    }

    public Set<class_2960> getStatus() {
        return this.currentStatusInfos;
    }

    public int debug_statusInfoCount() {
        return this.currentStatusInfos.size();
    }

    private void resetStatus(boolean keepPreviousDelays) {
        this.currentStatusInfos.clear();
        if (keepPreviousDelays && this.isDelayed()) {
            this.currentStatusInfos.add(TrainStatus.DELAY_FROM_PREVIOUS_JOURNEY.getLocation());
        }
    }

    public void applyStatus() {
        if (this.isCancelled()) {
            this.currentStatusInfos.clear();
            this.currentStatusInfos.add(TrainStatus.CANCELLED.getLocation());
            return;
        }
        for (Map.Entry x : TrainStatus.Registry.getRegisteredStatus().entrySet()) {
            if (!((TrainStatus)x.getValue()).isTriggerd(this)) continue;
            this.currentStatusInfos.add((class_2960)x.getKey());
        }
        boolean unknownDelayReason = this.isCurrentSectionDelayed();
        if (unknownDelayReason) {
            for (class_2960 loc : this.currentStatusInfos) {
                if (((TrainStatus)TrainStatus.Registry.getRegisteredStatus().get((Object)loc)).getImportance() != TrainStatus.TrainStatusType.DELAY || loc.equals((Object)TrainStatus.DEFAULT_DELAY.getLocation())) continue;
                unknownDelayReason = false;
                break;
            }
        }
        if (unknownDelayReason) {
            this.currentStatusInfos.add(TrainStatus.DEFAULT_DELAY.getLocation());
        } else {
            this.currentStatusInfos.remove(TrainStatus.DEFAULT_DELAY.getLocation());
        }
    }

    public boolean hasSectionChanged() {
        return this.sectionChanged;
    }

    public boolean isInitialized() {
        if (this.currentTransitTime.isEmpty()) {
            return false;
        }
        for (int i : this.currentTransitTime.values()) {
            if (i >= 0) continue;
            return false;
        }
        return true;
    }

    public int debug_initializedStationsCount() {
        return (int)this.currentTransitTime.values().stream().filter(x -> x > 0).count();
    }

    public boolean isPreparing() {
        return !this.hasStarted;
    }

    public synchronized TrainPrediction setPredictionData(int entryIndex, int currentIndex, int maxEntries, int stayDuration, int minStayDuration, int createTransitTime, GlobalTrainDisplayData.TrainDeparturePrediction predictionData) {
        this.destinationChanged = this.destinationChanged || this.currentScheduleIndex != currentIndex;
        this.currentScheduleIndex = currentIndex;
        TrainPrediction pred = this.predictionsByIndex.computeIfAbsent(entryIndex, i -> new TrainPrediction(this, entryIndex, predictionData, stayDuration, minStayDuration));
        boolean useCreateTimesOnInit = (Boolean)ModCommonConfig.USE_CREATE_TRANSIT_TIMES_ON_INIT.get();
        if (useCreateTimesOnInit) {
            int ticks = ((ScheduleRuntimeAccessor)this.train.runtime).crn$predictionTicks().get(entryIndex);
            this.currentTransitTime.computeIfAbsent(entryIndex, x -> {
                this.fillHistory(this.transitTimeHistory.computeIfAbsent(entryIndex, y -> new ConcurrentLinkedQueue()), createTransitTime);
                return ticks;
            });
        } else {
            this.currentTransitTime.computeIfAbsent(entryIndex, x -> -1);
        }
        this.validPredictionEntries.add(entryIndex);
        pred.updateRealTime(predictionData.destination, predictionData.ticks);
        this.predictionsChronologically.add(pred);
        return pred;
    }

    public void changeCurrentSection(int sectionEntryIndex) {
        this.currentTravelSectionIndex = this.sectionsByIndex.containsKey(sectionEntryIndex) ? sectionEntryIndex : -1;
        this.sectionChanged = true;
        this.lastSectionDelayOffset = Math.max(0L, this.getHighestDeviation());
        ++this.refreshTimingsCounter;
        this.currentSectionCache.clear();
    }

    private void clearAll() {
        this.predictionsByIndex.clear();
        this.sectionsByIndex.clear();
        this.defaultSection.clear();
        this.predictionsChronologically.clear();
        this.validPredictionEntries.clear();
        this.currentStatusInfos.clear();
        this.measuredTransitTimes.clear();
        this.transitTimeHistory.clear();
        this.currentTransitTime.clear();
        this.currentSectionCache.clear();
        this.sectionsCache.clear();
        this.lastScheduleIndex = -1;
        this.totalDuration = -1;
        this.hasStarted = false;
        this.resetCaches();
    }

    public synchronized void refreshPre() {
        if (this.train.runtime.paused) {
            return;
        }
        if (this.hardResetPredictions) {
            this.hardResetPredictions = false;
            this.clearAll();
        }
        this.validPredictionEntries.clear();
        this.predictionsChronologically.clear();
    }

    public synchronized void refreshPost() {
        boolean isNowCancelled;
        if (!this.train.runtime.paused) {
            ((ConcurrentHashMap.CollectionView)((Object)this.predictionsByIndex.keySet())).retainAll(this.validPredictionEntries);
            this.measuredTransitTimes.keySet().retainAll(this.validPredictionEntries);
            this.transitTimeHistory.keySet().retainAll(this.validPredictionEntries);
            this.currentTransitTime.keySet().retainAll(this.validPredictionEntries);
        }
        if (this.lastScheduleIndex >= 0 && this.lastScheduleIndex != this.currentScheduleIndex && this.predictionsByIndex.containsKey(this.lastScheduleIndex)) {
            this.predictionsByIndex.get(this.lastScheduleIndex).nextCycle();
        }
        if (!this.hasCustomTravelSections() && this.lastScheduleIndex > this.currentScheduleIndex) {
            this.changeCurrentSection(this.currentTravelSectionIndex);
        }
        this.lastScheduleIndex = this.currentScheduleIndex;
        boolean bl = isNowCancelled = !TrainUtils.isTrainValid(this.train) || !this.isInitialized() || this.train.runtime.paused;
        if (this.cancelled && !isNowCancelled) {
            this.hasStarted = false;
            this.initializationCompleted = false;
            this.initializationFinishTask = false;
            this.sessionId = UUID.randomUUID();
            this.resetPredictions();
        }
        this.cancelled = isNowCancelled;
        this.applyStatus();
        if (this.destinationChanged) {
            this.destinationChanged = false;
            this.notifyListeners(EVENT_DESTINATION_CHANGED, this);
        }
        if (this.initializationFinishTask) {
            this.initializationFinishTask = false;
            this.onInitialize();
        }
        this.resetCaches();
    }

    private void resetCaches() {
        this.isDelayedCache.clear();
        this.highestDeviationCache.clear();
    }

    public void tick() {
        boolean isWaitingForSignal;
        if (this.train.runtime.paused) {
            return;
        }
        if (!this.isAtStation()) {
            ++this.transitTime;
        }
        boolean bl = isWaitingForSignal = this.train.navigation.waitingForSignal != null;
        if (this.wasWaitingForSignal != isWaitingForSignal) {
            if (isWaitingForSignal) {
                this.waitingForSignalId = (UUID)this.train.navigation.waitingForSignal.getFirst();
                this.occupyingTrains.clear();
                this.occupyingTrains.addAll(TrainUtils.isSignalOccupied(this.waitingForSignalId, Set.of(this.train.id)));
            } else {
                this.delaysBySignal.put(this.waitingForSignalId, this.waitingForSignalTicks);
                this.waitingForSignalTicks = 0;
                this.occupyingTrains.clear();
            }
        }
        if (isWaitingForSignal) {
            ++this.waitingForSignalTicks;
        }
        this.wasWaitingForSignal = isWaitingForSignal;
    }

    public void updateTotalDuration() {
        int newDuration = this.currentTransitTime.values().stream().mapToInt(x -> x).sum() + this.getPredictions().stream().mapToInt(x -> x.getStayDuration()).sum();
        int oldTotalDuration = this.totalDuration;
        if (CRNEventsManager.isRegistered(TotalDurationTimeChangedEvent.class) && this.totalDuration > 0 && this.totalDuration != newDuration) {
            CRNEventsManager.getEvent(TotalDurationTimeChangedEvent.class).run(this.train, this.totalDuration, newDuration);
        }
        this.totalDuration = newDuration;
        if (oldTotalDuration != -1) {
            this.notifyListeners(EVENT_TOTAL_DURATION_CHANGED, this);
        }
        this.resetPredictions();
    }

    public void reachDestination(long destinationReachTime, int createTicksInTransit) {
        this.destinationReachTime = destinationReachTime;
        if (!((Boolean)ModCommonConfig.CUSTOM_TRANSIT_TIME_CALCULATION.get()).booleanValue()) {
            this.transitTime = createTicksInTransit;
        }
        if (this.hasStarted) {
            this.processTransitHistory(this.transitTimeHistory.computeIfAbsent(this.currentScheduleIndex, x -> new ConcurrentLinkedQueue()));
            this.measuredTransitTimes.put(this.currentScheduleIndex, this.transitTime);
        }
        this.transitTime = 0;
        this.waitingForSignalTicks = 0;
        this.waitingForSignalId = null;
        this.delaysBySignal.clear();
        this.hasStarted = true;
        this.isAtStation = true;
        if (!this.initializationCompleted && this.isInitialized()) {
            this.initializationCompleted = true;
            this.initializationFinishTask = true;
        }
        if (this.sectionChanged) {
            this.sectionChanged = false;
            if (!this.isDynamic() || (Integer)ModCommonConfig.AUTO_RESET_TIMINGS.get() > 0 && this.refreshTimingsCounter >= (Integer)ModCommonConfig.AUTO_RESET_TIMINGS.get()) {
                this.resetPredictions();
            } else {
                this.resetStatus(true);
            }
            this.notifyListeners(EVENT_SECTION_CHANGED, this);
        }
        this.notifyListeners(EVENT_STATION_REACHED, this);
    }

    public void leaveDestination() {
        this.currentScheduleIndex = this.getTrain().runtime.currentEntry;
        this.isAtStation = false;
    }

    public void onInitialize() {
        this.updateTotalDuration();
        this.isDynamic.clear();
    }

    private void processTransitHistory(Queue<Integer> history) {
        if (!this.currentTransitTime.containsKey(this.currentScheduleIndex) || this.currentTransitTime.get(this.currentScheduleIndex) < 0) {
            this.fillHistory(history, this.transitTime);
            this.currentTransitTime.put(this.currentScheduleIndex, this.transitTime);
        }
        while (history.size() >= this.getHistoryBufferSize()) {
            history.poll();
        }
        history.add(this.transitTime);
        int refCurrentTransitTime = this.currentTransitTime.get(this.currentScheduleIndex);
        double median = ModUtils.calculateMedian(history, (Integer)ModCommonConfig.TOTAL_DURATION_DEVIATION_THRESHOLD.get(), x -> true);
        if (Math.abs((double)refCurrentTransitTime - median) > (double)((Integer)ModCommonConfig.TOTAL_DURATION_DEVIATION_THRESHOLD.get()).intValue()) {
            int newValue = ModUtils.calculateMedian(history, (Integer)ModCommonConfig.TOTAL_DURATION_DEVIATION_THRESHOLD.get(), x -> Math.abs(refCurrentTransitTime - x) > (Integer)ModCommonConfig.TOTAL_DURATION_DEVIATION_THRESHOLD.get());
            this.currentTransitTime.put(this.currentScheduleIndex, newValue);
            this.fillHistory(history, newValue);
            this.updateTotalDuration();
        } else if (Math.abs(refCurrentTransitTime - this.transitTime) < (Integer)ModCommonConfig.TOTAL_DURATION_DEVIATION_THRESHOLD.get()) {
            this.fillHistory(history, refCurrentTransitTime);
        }
    }

    private void fillHistory(Queue<Integer> history, int value) {
        history.clear();
        for (int i = 0; i < this.getHistoryBufferSize(); ++i) {
            history.add(value);
        }
    }

    @Override
    public Map<String, IdentityHashMap<Object, Consumer<TrainData>>> getListeners() {
        return this.listeners;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569(NBT_VERSION, 1);
        class_2487 predictions = new class_2487();
        for (Map.Entry<Integer, TrainPrediction> entry : this.predictionsByIndex.entrySet()) {
            predictions.method_10566(String.valueOf(entry.getKey()), (class_2520)entry.getValue().toNbt());
        }
        class_2487 transitTimes = new class_2487();
        for (Map.Entry<Integer, Integer> entry : this.currentTransitTime.entrySet()) {
            transitTimes.method_10569(String.valueOf(entry.getKey()), entry.getValue().intValue());
        }
        nbt.method_25927(NBT_ID, this.getSessionId());
        nbt.method_25927(NBT_TRAIN_ID, this.getTrainId());
        nbt.method_10566(NBT_PREDICTIONS, (class_2520)predictions);
        nbt.method_10566(NBT_TRANSIT_TIMES, (class_2520)transitTimes);
        nbt.method_10569(NBT_CURRENT_SCHEDULE_INDEX, this.currentScheduleIndex);
        nbt.method_10544(NBT_LAST_DELAY_OFFSET, this.lastSectionDelayOffset);
        nbt.method_10556(NBT_CANCELLED, this.cancelled);
        nbt.method_10582(NBT_LINE_ID, this.lineId == null ? "" : this.lineId);
        return nbt;
    }

    public static Optional<TrainData> fromNbt(class_2487 nbt) {
        UUID trainId = nbt.method_25926(NBT_TRAIN_ID);
        UUID sessionId = nbt.method_25926(NBT_ID);
        Optional<Train> train = TrainUtils.getTrain(trainId);
        if (train.isPresent()) {
            TrainData data = new TrainData(train.get(), sessionId);
            data.deserializeNbt(nbt);
            return Optional.ofNullable(data);
        }
        CreateRailwaysNavigator.LOGGER.warn("Cannot load data for train with id " + String.valueOf(trainId) + ", because that train does not exist.");
        return Optional.empty();
    }

    protected void deserializeNbt(class_2487 nbt) {
        class_2487 predictions = nbt.method_10562(NBT_PREDICTIONS);
        for (String key : predictions.method_10541()) {
            try {
                int idx = Integer.parseInt(key);
                this.predictionsByIndex.put(idx, TrainPrediction.fromNbt(this, predictions.method_10562(key)));
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.warn("Unable to load prediction with index '" + key + "': The value is not an integer.", (Throwable)e);
            }
        }
        class_2487 transitTimes = nbt.method_10562(NBT_TRANSIT_TIMES);
        for (String key : transitTimes.method_10541()) {
            try {
                int idx = Integer.parseInt(key);
                int time = transitTimes.method_10550(key);
                if (time <= 0) continue;
                this.fillHistory(this.transitTimeHistory.computeIfAbsent(idx, x -> new ConcurrentLinkedQueue()), time);
                this.measuredTransitTimes.put(idx, time);
                this.currentTransitTime.put(idx, time);
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.warn("Unable to load transit time with index '" + key + "': The value is not an integer.", (Throwable)e);
            }
        }
        this.lastScheduleIndex = this.currentScheduleIndex = nbt.method_10550(NBT_CURRENT_SCHEDULE_INDEX);
        this.currentTravelSectionIndex = this.getSectionForIndex(this.currentScheduleIndex).getScheduleIndex();
        this.lineId = nbt.method_10558(NBT_LINE_ID);
        this.lastSectionDelayOffset = nbt.method_10537(NBT_LAST_DELAY_OFFSET);
        this.cancelled = nbt.method_10577(NBT_CANCELLED);
    }

    public synchronized void shiftTime(long l) {
        this.destinationReachTime += l;
        this.predictionsByIndex.values().forEach(x -> x.shiftTime(l));
    }
}

