/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TrainInfo;
import de.mrjulsen.crn.data.navigation.ITrainListenerClient;
import de.mrjulsen.crn.data.train.TrainState;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.util.IListenable;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class ClientTrainStop
extends TrainStop
implements ITrainListenerClient<TrainStopRealTimeData>,
IListenable<ClientTrainStop> {
    public static final String EVENT_UPDATE = "update";
    public static final String EVENT_DELAY = "delayed";
    public static final String EVENT_SCHEDULE_CHANGED = "schedule_changed";
    public static final String EVENT_STATION_CHANGED = "station_changed";
    public static final String EVENT_STATION_REACHED = "station_reached";
    public static final String EVENT_STATION_LEFT = "station_left";
    public static final String EVENT_ANNOUNCE_NEXT_STOP = "announce_next_stop";
    private final Map<String, IdentityHashMap<Object, Consumer<ClientTrainStop>>> listeners = new HashMap<String, IdentityHashMap<Object, Consumer<ClientTrainStop>>>();
    private boolean isClosed = false;

    public ClientTrainStop(int scheduleIndex, int sectionIndex, UUID trainId, String trainName, TrainIconType trainIcon, TrainInfo trainInfo, String scheduleTitle, boolean isCustomTitle, String terminusText, int stayDuration, boolean simulated, long scheduledDepartureTime, long scheduledArrivalTime, int cycle, StationTag.ClientStationTag tag, long realTimeArrivalTime, long realTimeDepartureTime, int realTimeCycle, StationTag.ClientStationTag realTimeTag, long arrivalTimeDeviation, long departureTimeDeviation, int realTimeTicksUntilArrival, TrainState trainPosition) {
        super(scheduleIndex, sectionIndex, trainId, trainName, trainIcon, trainInfo, scheduleTitle, isCustomTitle, terminusText, stayDuration, simulated, scheduledDepartureTime, scheduledArrivalTime, cycle, tag, realTimeArrivalTime, realTimeDepartureTime, realTimeCycle, realTimeTag, arrivalTimeDeviation, departureTimeDeviation, realTimeTicksUntilArrival, trainPosition);
        this.initEvents();
    }

    private void initEvents() {
        this.createEvent(EVENT_UPDATE);
        this.createEvent(EVENT_DELAY);
        this.createEvent(EVENT_SCHEDULE_CHANGED);
        this.createEvent(EVENT_STATION_CHANGED);
        this.createEvent(EVENT_STATION_REACHED);
        this.createEvent(EVENT_STATION_LEFT);
        this.createEvent(EVENT_ANNOUNCE_NEXT_STOP);
    }

    @Override
    public Map<String, IdentityHashMap<Object, Consumer<ClientTrainStop>>> getListeners() {
        return this.listeners;
    }

    public long getRoundedRealTimeArrivalTime() throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        return (this.getScheduledArrivalTime() + this.getArrivalTimeDeviation()) / (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue() * (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue();
    }

    public long getRoundedRealTimeDepartureTime() throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        return (this.getScheduledDepartureTime() + this.getDepartureTimeDeviation()) / (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue() * (long)((Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get()).intValue();
    }

    @Override
    public void update(TrainStopRealTimeData data) {
        if (this.isClosed) {
            return;
        }
        if (data.cycle() != this.getScheduledCycle()) {
            if (data.cycle() > this.getScheduledCycle() && this.trainState != TrainState.AFTER) {
                this.trainState = TrainState.AFTER;
                this.notifyListeners(EVENT_STATION_LEFT, this);
                this.close();
            }
            return;
        }
        boolean wasDelayed = this.isDepartureDelayed();
        String oldRealTimeStation = this.getRealTimeStationTag().stationName();
        int oldTimeUntilArrival = this.getTicksUntilArrival();
        if (this.scheduledArrivalTime != data.scheduledArrivalTime() || this.scheduledDepartureTime != data.scheduledDepartureTime()) {
            this.notifyListeners(EVENT_SCHEDULE_CHANGED, this);
        }
        this.scheduledArrivalTime = data.scheduledArrivalTime();
        this.scheduledDepartureTime = data.scheduledDepartureTime();
        this.realTimeArrivalTime = data.realTimeArrivalTime();
        this.realTimeDepartureTime = data.realTimeDepartureTime();
        this.arrivalTimeDeviation = data.deltaArrivalTime();
        this.departureTimeDeviation = data.deltaDepartureTime();
        this.realTimeCycle = data.cycle();
        this.realTimeTag = data.station();
        this.realTimeTicksUntilArrival = data.ticksUntilArrival();
        if (!wasDelayed && this.isAnyDelayed()) {
            this.notifyListeners(EVENT_DELAY, this);
        }
        if (!oldRealTimeStation.equals(this.getRealTimeStationTag().stationName())) {
            this.notifyListeners(EVENT_STATION_CHANGED, this);
        }
        if (this.trainState == TrainState.BEFORE && oldTimeUntilArrival > this.getTicksUntilArrival() && this.getTicksUntilArrival() <= (Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()) {
            this.trainState = TrainState.ANNOUNCED;
            this.notifyListeners(EVENT_ANNOUNCE_NEXT_STOP, this);
        }
        if (this.trainState.getPositionMultiplier() < 0 && this.getTicksUntilArrival() <= 0) {
            this.trainState = TrainState.STAYING;
            this.notifyListeners(EVENT_STATION_REACHED, this);
        }
        this.notifyListeners(EVENT_UPDATE, this);
    }

    public static TrainStop fromNbt(class_2487 nbt) {
        return new ClientTrainStop(nbt.method_10550("ScheduleIndex"), nbt.method_10550("SectionIndex"), nbt.method_25926("TrainId"), nbt.method_10558("TrainName"), TrainIconType.byId((class_2960)new class_2960(nbt.method_10558("TrainIcon"))), TrainInfo.fromNbt(nbt.method_10562("TrainInfo")), nbt.method_10558("ScheduleTitle"), nbt.method_10577("IsCustomTitle"), nbt.method_10558("TerminusText"), nbt.method_10550("StayDuration"), nbt.method_10537("SimulationTime") != 0L, nbt.method_10537("ScheduledDeparture"), nbt.method_10537("ScheduledArrival"), nbt.method_10550("Cycle"), StationTag.ClientStationTag.fromNbt(nbt.method_10562("StationTag")), nbt.method_10537("RealArrival"), nbt.method_10537("RealDeparture"), nbt.method_10550("RealCycle"), StationTag.ClientStationTag.fromNbt(nbt.method_10562("RealTimeTag")), nbt.method_10545("RealArrival") ? nbt.method_10537("RealArrival") - nbt.method_10537("ScheduledArrival") : 0L, nbt.method_10545("RealDeparture") ? nbt.method_10537("RealDeparture") - nbt.method_10537("ScheduledDeparture") : 0L, 0, TrainState.BEFORE);
    }

    @Override
    public void close() {
        this.clearEvents();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public record TrainStopRealTimeData(StationTag.ClientStationTag station, int entryIndex, long scheduledArrivalTime, long scheduledDepartureTime, long realTimeArrivalTime, long realTimeDepartureTime, long deltaArrivalTime, long deltaDepartureTime, int ticksUntilArrival, int cycle) {
        private static final String NBT_INDEX = "Index";
        private static final String NBT_STATION = "Station";
        private static final String NBT_SCHEDULED_ARRIVAL = "Arrival";
        private static final String NBT_SCHEDULED_DEPARTURE = "Departure";
        private static final String NBT_REAL_TIME_ARRIVAL = "RealArrival";
        private static final String NBT_REAL_TIME_DEPARTURE = "RealDeparture";
        private static final String NBT_DELTA_ARRIVAL = "DeltaArrival";
        private static final String NBT_DELTA_DEPARTURE = "DeltaDeparture";
        private static final String NBT_CYCLE = "Cycle";
        private static final String NBT_TICKS_UNTIL_ARRIVAL = "TUA";

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10566(NBT_STATION, (class_2520)this.station.toNbt());
            nbt.method_10569(NBT_INDEX, this.entryIndex);
            nbt.method_10544(NBT_SCHEDULED_ARRIVAL, this.scheduledArrivalTime);
            nbt.method_10544(NBT_SCHEDULED_DEPARTURE, this.scheduledDepartureTime);
            nbt.method_10544(NBT_REAL_TIME_ARRIVAL, this.realTimeArrivalTime);
            nbt.method_10544(NBT_REAL_TIME_DEPARTURE, this.realTimeDepartureTime);
            nbt.method_10544(NBT_DELTA_ARRIVAL, this.deltaArrivalTime);
            nbt.method_10544(NBT_DELTA_DEPARTURE, this.deltaDepartureTime);
            nbt.method_10569(NBT_CYCLE, this.cycle);
            nbt.method_10569(NBT_TICKS_UNTIL_ARRIVAL, this.ticksUntilArrival);
            return nbt;
        }

        public static TrainStopRealTimeData fromNbt(class_2487 nbt) {
            return new TrainStopRealTimeData(StationTag.ClientStationTag.fromNbt(nbt.method_10562(NBT_STATION)), nbt.method_10550(NBT_INDEX), nbt.method_10537(NBT_SCHEDULED_ARRIVAL), nbt.method_10537(NBT_SCHEDULED_DEPARTURE), nbt.method_10537(NBT_REAL_TIME_ARRIVAL), nbt.method_10537(NBT_REAL_TIME_DEPARTURE), nbt.method_10537(NBT_DELTA_ARRIVAL), nbt.method_10537(NBT_DELTA_DEPARTURE), nbt.method_10550(NBT_TICKS_UNTIL_ARRIVAL), nbt.method_10550(NBT_CYCLE));
        }
    }
}

