/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.ETimeSource;
import de.mrjulsen.crn.data.schedule.IConditionsRequiresInstruction;
import de.mrjulsen.crn.data.schedule.INavigationExtension;
import de.mrjulsen.crn.data.schedule.condition.IDelayedWaitCondition;
import de.mrjulsen.crn.data.train.StationDepartureHistory;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.utils.GameInstance;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class TrainSeparationCondition
extends ScheduledDelay
implements IDelayedWaitCondition,
IConditionsRequiresInstruction {
    @Deprecated
    public static final String NBT_TIME = "Value";
    @Deprecated
    public static final String NBT_TIME_UNIT = "TimeUnit";
    public static final String NBT_TICKS = "Ticks";
    public static final String NBT_TRAIN_FILTER = "TrainFilter";
    public static final String NBT_TIME_SOURCE = "TimeSource";

    public TrainSeparationCondition() {
        this.data.method_10567(NBT_TRAIN_FILTER, StationDepartureHistory.ETrainFilter.ANY.getIndex());
        this.data.method_10569(NBT_TICKS, 100);
    }

    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)class_1799.field_8037, (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().method_12832() + ".title"), (Object[])new Object[]{this.formatTime(true)}));
    }

    public class_1799 getSecondLineIcon() {
        return new class_1799((class_1935)class_1802.field_8537);
    }

    public int totalWaitTicks() {
        return 0;
    }

    private int getDeparationTime() {
        if (this.data.method_10545(NBT_TICKS)) {
            return this.data.method_10550(NBT_TICKS);
        }
        return 0;
    }

    protected class_2561 formatTime(boolean compact) {
        int remainingTicks = this.getDeparationTime();
        int minutes = remainingTicks / 1200;
        int seconds = (remainingTicks %= 1200) / 20;
        remainingTicks %= 20;
        if (compact) {
            return TextUtils.text((String)String.format("%d:%02d,%02d", minutes, seconds, remainingTicks));
        }
        return TextUtils.text((String)String.format("%dm %ds %dt", minutes, seconds, remainingTicks));
    }

    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832())), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".description"), (Object[])new Object[]{this.formatTime(false)}).method_27692(class_124.field_1062), (Object)TextUtils.translate((String)this.getTrainFilter().getValueTranslationKey("createrailwaysnavigator")).method_27692(class_124.field_1075));
    }

    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        ScheduleEntry entry = (ScheduleEntry)train.runtime.getSchedule().entries.get(train.runtime.currentEntry);
        ((INavigationExtension)train.navigation).addDelayedWaitCondition((de.mrjulsen.mcdragonlib.data.Pair<IDelayedWaitCondition, IDelayedWaitCondition.DelayedWaitConditionContext>)de.mrjulsen.mcdragonlib.data.Pair.of((Object)this, (Object)new IDelayedWaitCondition.DelayedWaitConditionContext(level, train, context, train.getCurrentStation(), entry)));
        return true;
    }

    @Override
    public boolean runDelayed(IDelayedWaitCondition.DelayedWaitConditionContext context) {
        int delayValue = this.getDeparationTime();
        long lastDepartureTimestamp = Long.MIN_VALUE;
        String stationName = "";
        ScheduleEntry entry = context.scheduleEntry();
        ScheduleInstruction scheduleInstruction = entry.instruction;
        if (scheduleInstruction instanceof DestinationInstruction) {
            DestinationInstruction instruction = (DestinationInstruction)scheduleInstruction;
            stationName = instruction.getFilter();
            lastDepartureTimestamp = StationDepartureHistory.getLastMatchingDepartureTime(this.getTrainFilter(), context.train(), stationName);
        }
        if (lastDepartureTimestamp + (long)delayValue < GameInstance.getServer().method_30002().method_8510()) {
            StationDepartureHistory.updateDepartureHistory(context.train(), context.station().name);
            return true;
        }
        return false;
    }

    public class_2960 getId() {
        return new class_2960("createrailwaysnavigator", "train_separation");
    }

    public StationDepartureHistory.ETrainFilter getTrainFilter() {
        return StationDepartureHistory.ETrainFilter.getByIndex(this.data.method_10571(NBT_TRAIN_FILTER));
    }

    public ETimeSource getTimeSource() {
        return ETimeSource.getByIndex(this.data.method_10571(NBT_TIME_SOURCE));
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initTimingAdjustmentGui(this, builder);
    }
}

