/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.ScheduledDelay;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class DynamicDelayCondition
extends ScheduledDelay {
    public static final String NBT_MIN = "Min";

    public DynamicDelayCondition() {
        this.data.method_10569(NBT_MIN, 5);
    }

    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)new class_1799((class_1935)class_1802.field_8857), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule.condition." + this.getId().method_12832() + ".title"), (Object[])new Object[]{this.formatCustomTime(this.getMinValue(), true), this.formatTime(true)}));
    }

    protected class_2561 formatCustomTime(int time, boolean compact) {
        if (compact) {
            return Components.literal((String)(time + this.getUnit().suffix));
        }
        return Components.literal((String)(time + " ")).method_10852((class_2561)Lang.translateDirect((String)this.getUnit().key, (Object[])new Object[0]));
    }

    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832())), (Object)Lang.translateDirect((String)"schedule.condition.for_x_time", (Object[])new Object[]{this.formatTime(false)}).method_27692(class_124.field_1062), (Object)TextUtils.translate((String)("createrailwaysnavigator.schedule." + type + "." + this.getId().method_12832() + ".at_least"), (Object[])new Object[]{this.formatCustomTime(this.getMinValue(), false)}).method_27692(class_124.field_1062));
    }

    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        TrainData data;
        Optional<TrainPrediction> pred;
        int time = context.method_10550("Time");
        long currentDelay = 0L;
        long scheduledDepartureTime = 0L;
        boolean initialized = false;
        if (TrainListener.data.containsKey(train.id) && (pred = (data = TrainListener.data.get(train.id)).getNextStopPrediction()).isPresent()) {
            currentDelay = pred.get().getArrivalTimeDeviation();
            initialized = data.isInitialized() && !data.isPreparing();
            scheduledDepartureTime = pred.get().getScheduledDepartureTime();
        }
        long totalTicks = initialized ? Math.max((long)this.totalWaitTicks() - currentDelay, (long)this.minWaitTicks()) : (long)this.totalWaitTicks();
        if (!((long)time < (initialized ? Math.max((long)this.totalWaitTicks() - currentDelay, (long)this.minWaitTicks()) : (long)this.totalWaitTicks()) || initialized && DragonLib.getCurrentWorldTime() < scheduledDepartureTime)) {
            return true;
        }
        context.method_10569("Time", time + 1);
        context.method_10544("TotalTicks", Math.max(totalTicks, scheduledDepartureTime - DragonLib.getCurrentWorldTime() + (long)time));
        this.requestDisplayIfNecessary(context, time);
        return false;
    }

    public class_2960 getId() {
        return new class_2960("createrailwaysnavigator", "dynamic_delay");
    }

    public int getMinValue() {
        return this.intData(NBT_MIN);
    }

    public int minWaitTicks() {
        return this.getMinValue() * this.getUnit().ticksPer;
    }

    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        ClientWrapper.initDynamicDelayCondition(this, builder);
    }

    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        int time = tag.method_10550("Time");
        long totalTime = tag.method_10550("TotalTicks");
        long ticksUntilDeparture = Math.max(totalTime - (long)time, 0L);
        boolean showInMinutes = ticksUntilDeparture >= 1200L;
        int num = (int)(showInMinutes ? Math.floor((float)ticksUntilDeparture / 1200.0f) : Math.ceil((float)ticksUntilDeparture / 100.0f) * 5.0);
        String key = "generic." + (showInMinutes ? (num == 1 ? "daytime.minute" : "unit.minutes") : (num == 1 ? "daytime.second" : "unit.seconds"));
        return Lang.translateDirect((String)("schedule.condition." + this.getId().method_12832() + ".status"), (Object[])new Object[]{Components.literal((String)(num + " ")).method_10852((class_2561)Lang.translateDirect((String)key, (Object[])new Object[0]))});
    }
}

