/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.navigation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.TrainSchedule;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainData;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainTravelSection;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class RoutePart
implements Comparable<RoutePart> {
    protected static final String NBT_SESSION_ID = "SessionId";
    protected static final String NBT_TRAIN_ID = "TrainId";
    protected static final String NBT_STOPS = "Stops";
    protected static final String NBT_JOURNEY = "EntireJourney";
    protected final UUID sessionId;
    protected final UUID trainId;
    protected final List<TrainStop> routeStops;
    protected final List<TrainStop> allStops;
    protected boolean cancelled;
    protected final Set<TrainStatus.CompiledTrainStatus> status = new HashSet<TrainStatus.CompiledTrainStatus>();

    public static RoutePart get(UUID sessionId, TrainSchedule schedule, StationTag from, StationTag to, UserSettings settings) {
        List<TrainStop> stops = RoutePart.getBetween(schedule, from, to, settings).stream().filter(x -> !x.isEmpty() && x.stream().limit(x.size() - 1).allMatch(y -> y.getSectionIndex() == ((TrainStop)x.get(0)).getSectionIndex())).findFirst().orElse(List.of());
        List<TrainStop> entireJourney = List.of();
        if (stops.isEmpty()) {
            return null;
        }
        TrainStop firstStop = (TrainStop)stops.get(0);
        entireJourney = TrainSchedule.ofSectionForIndex(sessionId, schedule.getTrain(), firstStop.getScheduleIndex(), firstStop.getScheduleIndex(), firstStop.getSimulationTime()).getAllStops();
        return new RoutePart(sessionId, schedule.getTrain().id, stops, entireJourney);
    }

    public static boolean validate(RoutePart part, TrainData trainData) {
        if (part == null || part.isEmpty()) {
            return false;
        }
        int startSectionIndex = part.getFirstStop().getSectionIndex();
        int endSectionIndex = part.getLastStop().getSectionIndex();
        TrainTravelSection startSection = trainData.getSectionByIndex(startSectionIndex);
        TrainTravelSection endSection = trainData.getSectionByIndex(endSectionIndex);
        return startSectionIndex == endSectionIndex || endSection.isFirstStop(part.getLastStop().getScheduleIndex()) && endSection.previousSection() == startSection && startSection.shouldIncludeNextStationOfNextSection() && startSection.isUsable();
    }

    public RoutePart(UUID sessionId, TrainSchedule schedule) {
        this(sessionId, schedule.getTrain().id, schedule.getAllStops(), TrainSchedule.ofSectionForIndex(sessionId, schedule.getTrain(), schedule.getAllStops().isEmpty() ? 0 : schedule.getAllStops().get(schedule.getAllStops().size() - 1).getScheduleIndex(), schedule.getAllStops().isEmpty() ? 0 : schedule.getAllStops().get(0).getScheduleIndex(), schedule.getAllStops().isEmpty() ? 0L : schedule.getAllStops().get(0).getSimulationTime()).getAllStops());
    }

    public RoutePart(UUID sessionId, UUID trainId, List<TrainStop> routeStops, List<TrainStop> allStops) {
        this.sessionId = sessionId;
        this.routeStops = routeStops;
        this.trainId = trainId;
        this.allStops = allStops;
    }

    public boolean isEmpty() {
        return this.routeStops.isEmpty();
    }

    public TrainStop getFirstStop() {
        return this.routeStops.get(0);
    }

    public TrainStop getLastStop() {
        return this.routeStops.get(this.routeStops.size() - 1);
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getTrainId() {
        return this.trainId;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public List<TrainStop> getStopovers() {
        return this.routeStops.size() <= 2 ? List.of() : ImmutableList.copyOf(this.routeStops.subList(1, this.routeStops.size() - 1));
    }

    public ImmutableList<TrainStop> getAllStops() {
        return ImmutableList.copyOf(this.routeStops);
    }

    public ImmutableList<TrainStop> getAllJourneyStops() {
        return ImmutableList.copyOf(this.allStops);
    }

    public long departureIn() {
        return this.getFirstStop().getScheduledDepartureTime() - DragonLib.getCurrentWorldTime();
    }

    public long arrivalIn() {
        return this.getFirstStop().getScheduledArrivalTime() - DragonLib.getCurrentWorldTime();
    }

    public long travelTime() {
        return this.getLastStop().getScheduledArrivalTime() - this.getFirstStop().getScheduledDepartureTime();
    }

    public long timeUntilEnd() {
        return this.departureIn() + this.travelTime();
    }

    public Set<TrainStatus.CompiledTrainStatus> getStatus() {
        return ImmutableSet.copyOf(this.status);
    }

    private static Set<List<TrainStop>> getBetween(TrainSchedule schedule, StationTag start, StationTag end, UserSettings settings) {
        List<TrainStop> stops = schedule.getAllStopsChronologicallyDeparture();
        if (stops.stream().noneMatch(x -> x.getTag().equals(start)) || stops.stream().noneMatch(x -> x.getTag().equals(end))) {
            return Set.of();
        }
        HashSet<Pair> sections = new HashSet<Pair>();
        int firstStartIndex = -1;
        int startIndex = -1;
        int i = 0;
        int index = 0;
        while (i < stops.size() + (firstStartIndex < 0 ? stops.size() : firstStartIndex)) {
            TrainStop stop = stops.get(index);
            if (stop.getTag().equals(start)) {
                startIndex = index;
                if (firstStartIndex < 0) {
                    firstStartIndex = index;
                }
            }
            if (startIndex >= 0 && stop.getTag().equals(end)) {
                sections.add(new Pair((Object)startIndex, (Object)index));
                startIndex = -1;
            }
            index = ++i % stops.size();
        }
        if (sections.isEmpty()) {
            return Set.of();
        }
        HashSet<List<TrainStop>> routeParts = new HashSet<List<TrainStop>>();
        for (Pair startStopPair : sections) {
            if (GlobalSettings.getInstance().isTrainStationExcludedByUser(schedule.getTrain(), stops.get((Integer)startStopPair.getFirst()), settings) || GlobalSettings.getInstance().isTrainStationExcludedByUser(schedule.getTrain(), stops.get((Integer)startStopPair.getSecond()), settings)) continue;
            ArrayList<TrainStop> stopovers = new ArrayList<TrainStop>();
            int index2 = (Integer)startStopPair.getFirst() - 1;
            do {
                TrainStop stop = stops.get(++index2 % stops.size());
                stop.simulateCycles(index2 / stops.size());
                stopovers.add(stop);
            } while (index2 % stops.size() != (Integer)startStopPair.getSecond());
            routeParts.add(stopovers);
        }
        return routeParts;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_25927(NBT_SESSION_ID, this.sessionId);
        nbt.method_25927(NBT_TRAIN_ID, this.trainId);
        class_2499 stopsList = new class_2499();
        for (TrainStop stop : this.routeStops) {
            stopsList.add((Object)stop.toNbt(true));
        }
        nbt.method_10566(NBT_STOPS, (class_2520)stopsList);
        class_2499 journeyList = new class_2499();
        for (TrainStop stop : this.allStops) {
            journeyList.add((Object)stop.toNbt(true));
        }
        nbt.method_10566(NBT_JOURNEY, (class_2520)journeyList);
        return nbt;
    }

    public static RoutePart fromNbt(class_2487 nbt) {
        return new RoutePart(nbt.method_10545(NBT_SESSION_ID) ? nbt.method_25926(NBT_SESSION_ID) : new UUID(0L, 0L), nbt.method_25926(NBT_TRAIN_ID), nbt.method_10554(NBT_STOPS, 10).stream().map(x -> TrainStop.fromNbt((class_2487)x)).toList(), nbt.method_10554(NBT_JOURNEY, 10).stream().map(x -> TrainStop.fromNbt((class_2487)x)).toList());
    }

    @Override
    public int compareTo(RoutePart o) {
        return Long.compare(this.departureIn(), o.departureIn());
    }
}

