/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_5218;

public class UserSettings {
    private static final String FILENAME = "crn_usersettings_";
    private static final int VERSION = 1;
    private static final String NBT_VERSION = "Version";
    private static final String NBT_DEPARTURE_IN = "DepartureIn";
    private static final String NBT_TRANSFER_TIME = "TransferTime";
    private static final String NBT_TRAIN_GROUPS = "ExcludedTrainGroups";
    private static final String NBT_SAVED_ROUTES = "SavedRoutes";
    private static final String NBT_SEARCH_DEPARTURE_TIME = "SearchDepartureIn";
    private static final String NBT_SEARCH_TRAIN_GROUPS = "SearchExcludedTrainGroups";
    private static final Map<UUID, UserSettings> settingsInstances = new LinkedHashMap<UUID, UserSettings>();
    private final Collection<UserSetting<?>> allSettings = new ArrayList();
    private final UUID owner;
    private final boolean readOnly;
    public final UserSetting<Integer> navigationDepartureInTicks = this.registerSetting(new UserSetting<Integer>(() -> 0, "DepartureIn", (nbt, val, name) -> nbt.method_10569(name, val.intValue()), (nbt, name) -> nbt.method_10550(name), val -> TimeUtils.parseDurationShort((long)val.intValue())));
    public final UserSetting<Integer> navigationTransferTime = this.registerSetting(new UserSetting<Integer>(() -> 1000, "TransferTime", (nbt, val, name) -> nbt.method_10569(name, val.intValue()), (nbt, name) -> nbt.method_10550(name), val -> TimeUtils.parseDurationShort((long)val.intValue())));
    public final UserSetting<Set<String>> navigationExcludedTrainGroups = this.registerSetting(new UserSetting<Set>(() -> new HashSet(), "ExcludedTrainGroups", (nbt, val, name) -> {
        class_2499 list = new class_2499();
        list.addAll(val.stream().map(x -> class_2519.method_23256((String)x)).toList());
        nbt.method_10566(name, (class_2520)list);
    }, (nbt, name) -> nbt.method_10554(name, 8).stream().filter(x -> GlobalSettings.hasInstance() ? GlobalSettings.getInstance().trainGroupExists(x.method_10714()) : true).map(x -> x.method_10714()).collect(Collectors.toSet()), val -> val.isEmpty() ? TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups.all").getString() : TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups.excluded", (Object[])new Object[]{val.size()}).getString()));
    public final UserSetting<Set<class_2487>> savedRoutes = this.registerSetting(new UserSetting<Set>(() -> new HashSet(), "SavedRoutes", (nbt, val, name) -> {
        class_2499 list = new class_2499();
        list.addAll((Collection)val);
        nbt.method_10566(name, (class_2520)list);
    }, (nbt, name) -> nbt.method_10554(name, 10).stream().map(x -> (class_2487)x).collect(Collectors.toSet()), val -> TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.saved", (Object[])new Object[]{val.size()}).getString()));
    public final UserSetting<Integer> searchDepartureInTicks = this.registerSetting(new UserSetting<Integer>(() -> 0, "SearchDepartureIn", (nbt, val, name) -> nbt.method_10569(name, val.intValue()), (nbt, name) -> nbt.method_10550(name), val -> TimeUtils.parseDurationShort((long)val.intValue())));
    public final UserSetting<Set<String>> searchExcludedTrainGroups = this.registerSetting(new UserSetting<Set>(() -> new HashSet(), "SearchExcludedTrainGroups", (nbt, val, name) -> {
        class_2499 list = new class_2499();
        list.addAll(val.stream().map(x -> class_2519.method_23256((String)x)).toList());
        nbt.method_10566(name, (class_2520)list);
    }, (nbt, name) -> nbt.method_10554(name, 8).stream().filter(x -> GlobalSettings.hasInstance() ? GlobalSettings.getInstance().trainGroupExists(x.method_10714()) : true).map(x -> x.method_10714()).collect(Collectors.toSet()), val -> val.isEmpty() ? TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups.all").getString() : TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups.excluded", (Object[])new Object[]{val.size()}).getString()));

    public UserSettings(UUID playerId, boolean readOnly) {
        this.owner = playerId;
        this.readOnly = readOnly;
    }

    public UUID getOwnerId() {
        return this.owner;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void checkReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalAccessError("This instance of the user settings is read-only!");
        }
    }

    private static void update(UserSettings settings) {
        if (settingsInstances.containsKey(settings.getOwnerId())) {
            settingsInstances.get(settings.getOwnerId()).checkReadOnly();
        }
        settingsInstances.put(settings.getOwnerId(), settings);
    }

    protected <T extends UserSetting<?>> T registerSetting(T setting) {
        this.allSettings.add(setting);
        return setting;
    }

    public static UserSettings getSettingsFor(UUID playerId, boolean readOnly) {
        return settingsInstances.computeIfAbsent(playerId, x -> UserSettings.load(x, readOnly));
    }

    public final void clientSave(Runnable andThen) throws RuntimeSideException {
        if (Platform.getEnv() == EnvType.SERVER) {
            throw new RuntimeSideException(true);
        }
        this.checkReadOnly();
        DataAccessor.getFromServer((Object)this, ModAccessorTypes.SAVE_USER_SETTINGS, $ -> DLUtils.doIfNotNull((Object)andThen, x -> x.run()));
    }

    public final synchronized void save() throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        this.checkReadOnly();
        UserSettings.update(this);
        class_2487 nbt = this.toNbt();
        try {
            class_2507.method_30614((class_2487)nbt, (File)new File(ModCommonEvents.getCurrentServer().get().method_27050(new class_5218("data/crn_usersettings_" + String.valueOf(this.getOwnerId()) + ".nbt")).toString()));
            if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                CreateRailwaysNavigator.LOGGER.info("Saved user settings.");
            }
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save user settings.", (Throwable)e);
        }
    }

    public static UserSettings load(UUID playerId, boolean readOnly) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        File settingsFile = new File(ModCommonEvents.getCurrentServer().get().method_27050(new class_5218("data/crn_usersettings_" + String.valueOf(playerId) + ".nbt")).toString());
        if (settingsFile.exists()) {
            try {
                return UserSettings.fromNbt(class_2507.method_30613((File)settingsFile), playerId, readOnly);
            }
            catch (IOException e) {
                CreateRailwaysNavigator.LOGGER.error("Cannot load user settings for player: " + String.valueOf(playerId), (Throwable)e);
            }
        }
        return new UserSettings(playerId, readOnly);
    }

    public final class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        this.allSettings.forEach(x -> x.serialize(nbt));
        nbt.method_10569(NBT_VERSION, 1);
        return nbt;
    }

    public static final UserSettings fromNbt(class_2487 nbt, UUID playerId, boolean readOnly) {
        UserSettings settings = new UserSettings(playerId, readOnly);
        int version = nbt.method_10550(NBT_VERSION);
        settings.allSettings.forEach(x -> x.deserialize(nbt));
        return settings;
    }

    public static class UserSetting<T> {
        private T value;
        private final String serializationName;
        private final Supplier<T> defaultValue;
        private final ISerializationContext<T> serializer;
        private final BiFunction<class_2487, String, T> deserializer;
        private final Function<T, String> stringRepresentation;

        public UserSetting(Supplier<T> defaultValue, String serializationName, ISerializationContext<T> serializer, BiFunction<class_2487, String, T> deserializer, Function<T, String> stringRepresentation) {
            this.defaultValue = defaultValue;
            this.serializer = serializer;
            this.serializationName = serializationName;
            this.deserializer = deserializer;
            this.stringRepresentation = stringRepresentation;
            this.value = defaultValue.get();
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public void setToDefault() {
            this.value = this.getDefault();
        }

        public T getDefault() {
            return this.defaultValue.get();
        }

        private void serialize(class_2487 nbt) {
            this.serializer.execute(nbt, this.value, this.getSerializationName());
        }

        private T deserialize(class_2487 nbt) {
            this.value = this.deserializer.apply(nbt, this.getSerializationName());
            return this.value;
        }

        private String getSerializationName() {
            return this.serializationName;
        }

        public String toString() {
            return this.stringRepresentation.apply(this.value);
        }
    }

    @FunctionalInterface
    private static interface ISerializationContext<T> {
        public void execute(class_2487 var1, T var2, String var3);
    }
}

