/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.mcdragonlib.DragonLib;
import java.util.Date;
import java.util.Objects;
import net.minecraft.class_2487;

public class TrainGroup {
    public static int MAX_NAME_LENGTH = 32;
    private static final String NBT_NAME = "Name";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_LAST_EDITOR = "LastEditor";
    private static final String NBT_LAST_EDITED_TIME = "LastEditedTimestamp";
    private final String name;
    private int color;
    protected String lastEditorName;
    protected long lastEditedTime;

    public TrainGroup(String name) {
        this.name = name;
        this.updateLastEdited("Server");
    }

    public String getGroupName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public String getLastEditorName() {
        return this.lastEditorName;
    }

    public void updateLastEdited(String name) {
        this.lastEditorName = name;
        this.lastEditedTime = new Date().getTime();
    }

    public Date getLastEditedTime() {
        return new Date(this.lastEditedTime);
    }

    public String getLastEditedTimeFormatted() {
        return DragonLib.DATE_FORMAT.format(this.getLastEditedTime());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrainGroup) {
            TrainGroup o = (TrainGroup)obj;
            return this.name.equals(o.name);
        }
        return false;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        if (this.lastEditorName != null) {
            nbt.method_10582(NBT_LAST_EDITOR, this.getLastEditorName());
        }
        if (this.lastEditedTime > 0L) {
            nbt.method_10544(NBT_LAST_EDITED_TIME, this.lastEditedTime);
        }
        nbt.method_10582(NBT_NAME, this.getGroupName());
        nbt.method_10569(NBT_COLOR, this.getColor());
        return nbt;
    }

    public static TrainGroup fromNbt(class_2487 nbt) {
        String groupName = nbt.method_10558(NBT_NAME);
        TrainGroup group = new TrainGroup(groupName);
        group.setColor(nbt.method_10550(NBT_COLOR));
        if (nbt.method_10545(NBT_LAST_EDITOR)) {
            group.lastEditorName = nbt.method_10558(NBT_LAST_EDITOR);
        }
        if (nbt.method_10545(NBT_LAST_EDITED_TIME)) {
            group.lastEditedTime = nbt.method_10537(NBT_LAST_EDITED_TIME);
        }
        return group;
    }
}

