/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.modular;

import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetBuilder;
import de.mrjulsen.crn.client.gui.widgets.modular.ModularWidgetLine;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLScrollableWidgetContainer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class ModularWidgetContainer
extends DLScrollableWidgetContainer {
    public static final int DEFAULT_PADDING = 10;
    private final DLScreen screen;
    private final DLAbstractScrollBar<?> scrollBar;
    private final BiConsumer<ModularWidgetContainer, ModularWidgetBuilder> builder;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;

    public ModularWidgetContainer(DLScreen screen, int x, int y, int width, int height, BiConsumer<ModularWidgetContainer, ModularWidgetBuilder> builder, DLAbstractScrollBar<?> scrollBar) {
        this(screen, x, y, width, height, builder, scrollBar, 10, 10, 10, 10);
    }

    public ModularWidgetContainer(DLScreen screen, int x, int y, int width, int height, BiConsumer<ModularWidgetContainer, ModularWidgetBuilder> builder, DLAbstractScrollBar<?> scrollBar, int paddingLeft, int paddingRight, int paddingTop, int paddingBottom) {
        super(x, y, width, height);
        this.screen = screen;
        this.scrollBar = scrollBar;
        this.builder = builder;
        this.paddingLeft = paddingLeft;
        this.paddingRight = paddingRight;
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        this.build();
    }

    public void build() {
        this.clearWidgets();
        ModularWidgetBuilder mb = new ModularWidgetBuilder(this);
        this.builder.accept(this, mb);
        mb.build();
    }

    int addLine(ModularWidgetLine line, int yOffset) {
        line.set_x(this.x() + this.paddingLeft);
        line.set_y(this.y() + this.paddingTop + yOffset);
        line.set_width(this.width() - this.paddingLeft - this.paddingRight);
        this.addRenderableWidget((class_364)line);
        return line.height();
    }

    public DLScreen getParentScreen() {
        return this.screen;
    }

    public DLAbstractScrollBar<?> getScrollbar() {
        return this.scrollBar;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollBar.getScrollValue() > 0.0) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)this.y(), (int)0, (int)this.width(), (int)10, (int)0x77000000, (int)0);
        }
        if (this.scrollBar.getScrollValue() < (double)this.scrollBar.getMaxScroll()) {
            GuiUtils.fillGradient((Graphics)graphics, (int)this.x(), (int)(this.y() + this.height() - 10), (int)0, (int)this.width(), (int)10, (int)0, (int)0x77000000);
        }
    }

    public void set_width(int w) {
        throw new IllegalStateException("Changing the width is not supported.");
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }
}

