/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.TrainDebugViewer;
import de.mrjulsen.crn.debug.TrainDebugData;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class TrainDebugWidget
extends DLButton {
    public static final int HEADER_HEIGHT = 20;
    public static final int DEFAULT_LINE_HEIGHT = 12;
    public static final float DEFAULT_SCALE = 0.75f;
    private final TrainDebugData data;

    public TrainDebugWidget(class_437 parent, TrainDebugViewer viewer, int x, int y, int width, TrainDebugData data) {
        super(x, y, width, 32, (class_2561)TextUtils.empty(), b -> {});
        this.data = data;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((class_339)this), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((class_2561)TextUtils.text((String)"Reset Predictions"), Sprite.empty(), true, b -> DataAccessor.getFromServer((Object)data.trainId(), ModAccessorTypes.TRAIN_SOFT_RESET, $ -> viewer.reload()), null)).addSeparator().add(new DLContextMenuItem.ContextMenuItemData((class_2561)TextUtils.text((String)"Hard Reset"), Sprite.empty(), true, b -> DataAccessor.getFromServer((Object)data.trainId(), ModAccessorTypes.TRAIN_HARD_RESET, $ -> viewer.reload()), null))));
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ColorShade.DARK.getColor());
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)0x22FFFFFF);
        }
        float scale = 0.75f;
        class_5250 trainName = TextUtils.text((String)this.data.trainName()).method_27692(class_124.field_1067);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22904((double)this.x(), (double)this.y(), 0.0);
        graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
        class_5250 predictionsText = TextUtils.text((String)(this.data.predictionsInitialized() + " / " + this.data.predictionsCount()));
        int platformTextWidth = this.font.method_27525((class_5348)predictionsText);
        CreateDynamicWidgets.renderTextHighlighted(graphics, 5, 4, this.font, (class_2561)trainName, -13027015);
        int maxIdWidth = (int)((float)this.width() - (float)platformTextWidth * 0.75f - 15.0f - (float)(45 + this.font.method_27525((class_5348)trainName)) * 0.75f);
        class_5250 idText = TextUtils.text((String)this.data.trainId().toString());
        if (this.font.method_27525((class_5348)idText) > maxIdWidth) {
            idText = TextUtils.text((String)this.font.method_1714((class_5348)idText, maxIdWidth).getString()).method_10852((class_2561)TextUtils.text((String)"...")).method_27696(idText.method_10866());
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(20 + this.font.method_27525((class_5348)trainName)), (int)6, (class_5348)idText, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)((float)this.width() / 0.75f) - 6), (int)6, (class_5348)predictionsText, (int)0xFFFFFF, (EAlignment)EAlignment.RIGHT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)5, (int)20, (class_5348)TextUtils.text((String)("Session: " + String.valueOf(this.data.sessionId()))), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)5, (int)30, (class_5348)TextUtils.text((String)("Status: " + this.data.state().getName())), (int)this.data.state().getColor(), (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22909();
    }
}

