/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.foundation.gui.AllIcons;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.TrainJourneyScreen;
import de.mrjulsen.crn.client.gui.widgets.StationDeparturesViewer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class StationDeparturesWidget
extends DLButton
implements AutoCloseable {
    public static final int HEADER_HEIGHT = 20;
    public static final int DEFAULT_LINE_HEIGHT = 12;
    public static final float DEFAULT_SCALE = 0.75f;
    private final class_5250 connectionInPast = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final class_5250 trainCanceled = CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.stop_cancelled");
    private final ClientRoute route;
    private final boolean arrival;

    public StationDeparturesWidget(class_437 parent, StationDeparturesViewer viewer, int x, int y, int width, ClientRoute route, boolean arrival) {
        super(x, y, width, 32, (class_2561)TextUtils.empty(), b -> DLScreen.setScreen((DLScreen)new TrainJourneyScreen(parent, route, route.getStart().getTrainId())));
        this.route = route;
        this.arrival = arrival;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((class_339)this), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.view_details"), Sprite.empty(), true, b -> this.field_22767.onPress((class_4185)b), null))));
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        class_5250 stationText;
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.x(), this.y(), this.width(), this.height(), CreateDynamicWidgets.ColorShade.DARK.getColor());
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)0x22FFFFFF);
        }
        float scale = 0.75f;
        class_5250 trainName = TextUtils.text((String)this.route.getStart().getTrainDisplayName()).method_27692(class_124.field_1067);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22904((double)this.x(), (double)this.y(), 0.0);
        graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
        if (this.arrival) {
            AllIcons.I_CONFIG_OPEN.render(graphics.poseStack(), 8, 5);
        } else {
            AllIcons.I_CONFIG_BACK.render(graphics.poseStack(), 8, 5);
        }
        if (this.route.isAnyCancelled()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)((float)(this.field_22760 + this.width() - 5) / 0.75f)), (int)((int)((float)(this.y() + 15) / 0.75f)), (class_5348)this.trainCanceled, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        } else if (this.route.getStart().isDeparted()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)((float)(this.field_22760 + this.width() - 5) / 0.75f)), (int)((int)((float)(this.y() + 15) / 0.75f)), (class_5348)this.connectionInPast, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        }
        CreateDynamicWidgets.renderTextHighlighted(graphics, 30, 6, this.font, (class_2561)trainName, this.route.getStart().getTrainDisplayColor());
        graphics.poseStack().method_22909();
        class_5250 platformText = TextUtils.text((String)this.route.getStart().getRealTimeStationTag().info().platform());
        int platformTextWidth = this.font.method_27525((class_5348)platformText);
        int maxStationNameWidth = this.width() - platformTextWidth - 15 - (int)((float)(45 + this.font.method_27525((class_5348)trainName)) * 0.75f);
        class_5250 class_52502 = stationText = this.arrival ? TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.train_from", (Object[])new Object[]{this.route.getEnd().getClientTag().tagName()}) : TextUtils.text((String)this.route.getStart().getDisplayTitle());
        if (this.font.method_27525((class_5348)stationText) > maxStationNameWidth) {
            stationText = TextUtils.text((String)this.font.method_1714((class_5348)stationText, maxStationNameWidth).getString()).method_10852((class_2561)TextUtils.text((String)"...")).method_27696(stationText.method_10866());
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.x() + (int)((float)(45 + this.font.method_27525((class_5348)trainName)) * 0.75f)), (int)(this.y() + 6), (class_5348)stationText, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.x() + this.width() - 6), (int)(this.y() + 6), (class_5348)platformText, (int)0xFFFFFF, (EAlignment)EAlignment.RIGHT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.x() + 22), (int)(this.y() + 20), (String)ModUtils.formatTime(this.arrival ? this.route.getStart().getScheduledArrivalTime() : this.route.getStart().getScheduledDepartureTime(), false), (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(this.x() + 22 + 40), (int)(this.y() + 20), (String)ModUtils.formatTime(this.arrival ? this.route.getStart().getRealTimeArrivalTime() : this.route.getStart().getRealTimeDepartureTime(), false), (int)((this.arrival ? this.route.getStart().isArrivalDelayed() : this.route.getStart().isDepartureDelayed()) ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
    }

    @Override
    public void close() {
        this.route.closeAll();
    }
}

