/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.station.NoShadowFontWrapper;
import de.mrjulsen.crn.client.ModGuiUtils;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.screen.RouteDetailsScreen;
import de.mrjulsen.crn.client.gui.widgets.RouteViewer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.SavedRoutesManager;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.RoutePart;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RouteWidget
extends DLButton {
    public static final int WIDTH = 214;
    public static final int HEIGHT = 54;
    private static final int DISPLAY_WIDTH = 204;
    private final ClientRoute route;
    private final class_5250 transferText = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.transfer");
    private final class_5250 connectionInPast = CustomLanguage.translate("gui.createrailwaysnavigator.navigator.route_entry.connection_in_past");
    private final class_5250 trainCanceled = CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.stop_cancelled");
    private final class_5250 textShowDetails = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.show_details");
    private final class_5250 textSave = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.save");
    private final class_5250 textShare = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.share");
    private final class_5250 textRemove = TextUtils.translate((String)"gui.createrailwaysnavigator.route_widget.remove");

    public RouteWidget(RouteViewer parent, ClientRoute route, int x, int y) {
        super(x, y, 214, 54, (class_2561)TextUtils.empty(), b -> class_310.method_1551().method_1507((class_437)new RouteDetailsScreen(parent.getParent(), route)));
        this.route = route;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.FLAT);
        this.setMenu(new DLContextMenu(() -> GuiAreaDefinition.of((class_339)this), () -> new DLContextMenuItem.Builder().add(new DLContextMenuItem.ContextMenuItemData((class_2561)this.textShowDetails, Sprite.empty(), true, b -> this.field_22767.onPress((class_4185)b), null)).addSeparator().add(new DLContextMenuItem.ContextMenuItemData((class_2561)(SavedRoutesManager.isSaved(route) ? this.textRemove : this.textSave), Sprite.empty(), true, b -> {
            if (SavedRoutesManager.isSaved(route)) {
                SavedRoutesManager.removeRoute(route);
            } else {
                SavedRoutesManager.saveRoute(route);
            }
        }, null))));
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int color;
        int i;
        int precision = (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get();
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, this.field_22760, this.field_22761, 214, 54, CreateDynamicWidgets.ColorShade.DARK.getColor());
        CreateDynamicWidgets.renderHorizontalSeparator(graphics, this.field_22760 + 6, this.field_22761 + 22, 202);
        if (this.isMouseSelected()) {
            GuiUtils.fill((Graphics)graphics, (int)this.x(), (int)this.y(), (int)this.width(), (int)this.height(), (int)0x22FFFFFF);
        }
        class_310 minecraft = class_310.method_1551();
        ImmutableList<RoutePart> parts = this.route.getParts();
        NoShadowFontWrapper shadowlessFont = new NoShadowFontWrapper(minecraft.field_1772);
        String timeStart = TimeUtils.parseTime((long)((int)((this.route.getStart().getScheduledDepartureTime() + DragonLib.daytimeShift()) % DragonLib.ticksPerDay())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String timeEnd = TimeUtils.parseTime((long)((int)((this.route.getEnd().getScheduledArrivalTime() + DragonLib.daytimeShift()) % DragonLib.ticksPerDay())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        String dash = " - ";
        class_5250 summary = TextUtils.text((String)String.format("%s%s%s | %s %s | %s", timeStart, dash, timeEnd, this.route.getTransferCount(), this.transferText.getString(), TimeUtils.parseDurationShort((long)((int)this.route.travelTime()))));
        float scale = 0.75f;
        float localScale = shadowlessFont.method_27525((class_5348)summary) > 202 ? 0.75f : 1.0f;
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(localScale, 1.0f, 1.0f);
        GuiUtils.drawString((Graphics)graphics, (class_327)minecraft.field_1772, (int)((int)((float)(this.field_22760 + 6) / localScale)), (int)(this.field_22761 + 5), (class_5348)summary, (int)0xFFFFFF, (EAlignment)EAlignment.LEFT, (boolean)false);
        graphics.poseStack().method_22909();
        int routePartWidth = 204 / parts.size();
        String endStationName = this.route.getEnd().getClientTag().tagName();
        int textW = shadowlessFont.method_1727(endStationName);
        for (i = 0; i < parts.size(); ++i) {
            color = ((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayColor();
            GuiUtils.fill((Graphics)graphics, (int)(this.field_22760 + 6 + i * routePartWidth + 1), (int)(this.field_22761 + 27), (int)(routePartWidth - 4), (int)1, (int)color);
            GuiUtils.fill((Graphics)graphics, (int)(this.field_22760 + 5 + i * routePartWidth + 1), (int)(this.field_22761 + 28), (int)(routePartWidth - 2), (int)9, (int)color);
            GuiUtils.fill((Graphics)graphics, (int)(this.field_22760 + 6 + i * routePartWidth + 1), (int)(this.field_22761 + 37), (int)(routePartWidth - 4), (int)1, (int)color);
        }
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(0.75f, 0.75f, 0.75f);
        for (i = 0; i < parts.size(); ++i) {
            color = ((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayColor();
            int fontColor = ModGuiUtils.useWhiteOrBlackForeColor(color) ? -1 : -16777216;
            class_2561 trainName = GuiUtils.ellipsisString((class_327)this.font, (class_2561)TextUtils.text((String)((RoutePart)parts.get(i)).getFirstStop().getTrainDisplayName()), (int)((int)((float)(routePartWidth - 10) / 0.75f)));
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)((float)(this.field_22760 + 5 + i * routePartWidth + routePartWidth / 2) / 0.75f)), (int)((int)((float)(this.field_22761 + 30) / 0.75f)), (class_5348)trainName, (int)fontColor, (EAlignment)EAlignment.CENTER, (boolean)false);
        }
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)((float)(this.field_22760 + 6) / 0.75f)), (int)((int)((float)(this.field_22761 + 43) / 0.75f)), (class_5348)TextUtils.text((String)this.route.getStart().getClientTag().tagName()), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)((float)(this.field_22760 + 214 - 6) / 0.75f) - textW), (int)((int)((float)(this.field_22761 + 43) / 0.75f)), (class_5348)TextUtils.text((String)endStationName), (int)0xDBDBDB, (EAlignment)EAlignment.LEFT, (boolean)false);
        if (this.route.getStart().shouldRenderRealTime()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)(((float)(this.field_22760 + 6) + (float)this.font.method_1727(timeStart) * localScale / 2.0f) / 0.75f) - this.font.method_1727(timeStart) / 2), (int)((int)((float)(this.field_22761 + 15) / 0.75f)), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((int)((this.route.getStart().getScheduledDepartureTime() + this.route.getStart().getDepartureTimeDeviation() / (long)precision * (long)precision) % 24000L + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getStart().isDepartureDelayed() ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (this.route.getEnd().shouldRenderRealTime()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)(((float)(this.field_22760 + 6) + (float)this.font.method_1727(timeEnd) * localScale * 1.5f + (float)this.font.method_1727(dash) * localScale) / 0.75f) - this.font.method_1727(timeEnd) / 2), (int)((int)((float)(this.field_22761 + 15) / 0.75f)), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((int)((this.route.getEnd().getScheduledArrivalTime() + this.route.getEnd().getArrivalTimeDeviation() / (long)precision * (long)precision) % 24000L + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))), (int)(this.route.getEnd().isArrivalDelayed() ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        if (this.route.isAnyCancelled()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)((float)(this.field_22760 + 214 - 5) / 0.75f)), (int)((int)((float)(this.field_22761 + 15) / 0.75f)), (class_5348)this.trainCanceled, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        } else if (this.route.getStart().isDeparted()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)shadowlessFont, (int)((int)((float)(this.field_22760 + 214 - 5) / 0.75f)), (int)((int)((float)(this.field_22761 + 15) / 0.75f)), (class_5348)this.connectionInPast, (int)-48574, (EAlignment)EAlignment.RIGHT, (boolean)false);
        }
        graphics.poseStack().method_22909();
    }
}

