/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.Animator;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public abstract class AbstractFlyoutWidget<T extends class_364 & class_4068>
extends DLWidgetContainer {
    protected final DLScreen screen;
    protected final FlyoutPointer pointer;
    protected final CreateDynamicWidgets.ColorShade pointerShade;
    protected final int distanceToParent = 0;
    protected final Animator animator = (Animator)this.addRenderableOnly((class_4068)new Animator());
    private final Consumer<T> addRenderableWidgetFunc;
    private final Consumer<class_364> removeWidgetFunc;
    private int xOffset;
    private int yOffset;
    private boolean isClosing = false;
    private final Cache<GuiAreaDefinition> contentArea = new Cache(() -> new GuiAreaDefinition(this.x() + 5, this.y() + 5, this.width() - 10, this.height() - 10));

    public AbstractFlyoutWidget(DLScreen screen, int width, int height, FlyoutPointer pointer, CreateDynamicWidgets.ColorShade pointerShade, Consumer<T> addRenderableWidgetFunc, Consumer<class_364> removeWidgetFunc) {
        super(0, 0, width, height);
        this.screen = screen;
        this.pointerShade = pointerShade;
        this.pointer = pointer;
        this.addRenderableWidgetFunc = addRenderableWidgetFunc;
        this.removeWidgetFunc = removeWidgetFunc;
    }

    public GuiAreaDefinition getContentArea() {
        return (GuiAreaDefinition)this.contentArea.get();
    }

    public void open(IDragonLibWidget parent) {
        this.screen.setAllowedLayer(this.screen.getAllowedLayer() + 1);
        this.setWidgetLayerIndex(this.screen.getAllowedLayer());
        switch (this.pointer.ordinal()) {
            case 0: {
                this.set_x(MathUtils.clamp((int)(this.xOffset + parent.x() + parent.width() / 2 - this.width() / 2), (int)0, (int)(class_310.method_1551().field_1755.field_22789 - this.width())));
                this.set_y(MathUtils.clamp((int)(this.yOffset + parent.y() + parent.height() + 0), (int)0, (int)(class_310.method_1551().field_1755.field_22790 - this.height() - 0)));
                break;
            }
            case 1: {
                this.set_x(MathUtils.clamp((int)(this.xOffset + parent.x() + parent.width() / 2 - this.width() / 2), (int)0, (int)(class_310.method_1551().field_1755.field_22789 - this.width())));
                this.set_y(MathUtils.clamp((int)(this.yOffset + parent.y() - this.height() - 0), (int)0, (int)(class_310.method_1551().field_1755.field_22790 - this.height() - 0)));
                break;
            }
            case 2: {
                this.set_x(MathUtils.clamp((int)(this.xOffset + parent.x() - this.width() - 0), (int)0, (int)(class_310.method_1551().field_1755.field_22789 - this.width() - 0)));
                this.set_y(MathUtils.clamp((int)(this.yOffset + parent.y() + parent.height() / 2 - this.height() / 2), (int)0, (int)(class_310.method_1551().field_1755.field_22790 - this.height())));
                break;
            }
            case 3: {
                this.set_x(MathUtils.clamp((int)(this.xOffset + parent.x() + parent.width() + 0), (int)0, (int)(class_310.method_1551().field_1755.field_22789 - this.width() - 0)));
                this.set_y(MathUtils.clamp((int)(this.yOffset + parent.y() + parent.height() / 2 - this.height() / 2), (int)0, (int)(class_310.method_1551().field_1755.field_22790 - this.height())));
            }
        }
        this.contentArea.clear();
        this.animator.start(3, null, null, null);
        this.addRenderableWidgetFunc.accept(this);
    }

    public void close() {
        this.isClosing = true;
        this.screen.setAllowedLayer(this.getWidgetLayerIndex() - 1);
        this.animator.start(3, null, null, () -> {
            this.screen.setAllowedLayer(this.getWidgetLayerIndex() - 1);
            this.removeWidgetFunc.accept((class_364)this);
        });
    }

    public void closeImmediately() {
        this.isClosing = true;
        this.screen.setAllowedLayer(this.getWidgetLayerIndex() - 1);
        this.removeWidgetFunc.accept((class_364)this);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22904(0.0, 0.0, 100.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (this.animator.isRunning()) {
            if (this.isClosing) {
                switch (this.pointer.ordinal()) {
                    case 0: {
                        graphics.poseStack().method_22904(0.0, (double)(-this.animator.getCurrentTicksSmooth() * 2.0f), 0.0);
                        break;
                    }
                    case 1: {
                        graphics.poseStack().method_22904(0.0, (double)((float)(this.animator.getTotalTicks() * 2) - this.animator.getCurrentTicksSmooth() * 2.0f), 0.0);
                        break;
                    }
                    case 3: {
                        graphics.poseStack().method_22904((double)((float)(this.animator.getTotalTicks() * 2) - this.animator.getCurrentTicksSmooth() * 2.0f), 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        graphics.poseStack().method_22904((double)(this.animator.getCurrentTicksSmooth() * 2.0f), 0.0, 0.0);
                    }
                }
                GuiUtils.setTint((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - this.animator.getPercentage()));
            } else {
                switch (this.pointer.ordinal()) {
                    case 0: {
                        graphics.poseStack().method_22904(0.0, (double)((float)(-this.animator.getTotalTicks() * 2) + this.animator.getCurrentTicksSmooth() * 2.0f), 0.0);
                        break;
                    }
                    case 1: {
                        graphics.poseStack().method_22904(0.0, (double)(this.animator.getCurrentTicksSmooth() * 2.0f), 0.0);
                        break;
                    }
                    case 3: {
                        graphics.poseStack().method_22904((double)(-this.animator.getCurrentTicksSmooth() * 2.0f), 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        graphics.poseStack().method_22904((double)((float)(this.animator.getTotalTicks() * 2) - this.animator.getCurrentTicksSmooth() * 2.0f), 0.0, 0.0);
                    }
                }
                GuiUtils.setTint((float)1.0f, (float)1.0f, (float)1.0f, (float)this.animator.getPercentage());
            }
        }
        this.renderFlyout(graphics, mouseX, mouseY, partialTicks, this.getContentArea());
        this.renderFlyoutContent(graphics, mouseX, mouseY, partialTicks, this.getContentArea());
        graphics.poseStack().method_22909();
    }

    public void renderFlyoutContent(Graphics graphics, int mouseX, int mouseY, float partialTicks, GuiAreaDefinition contentArea) {
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFlyout(Graphics graphics, int mouseX, int mouseY, float partialTicks, GuiAreaDefinition contentArea) {
        CreateDynamicWidgets.renderShadow(graphics, contentArea.getX(), contentArea.getY(), contentArea.getWidth(), contentArea.getHeight());
        CreateDynamicWidgets.renderSingleShadeWidget(graphics, contentArea.getX(), contentArea.getY(), contentArea.getWidth(), contentArea.getHeight(), this.pointerShade);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        switch (this.pointer.ordinal()) {
            case 0: {
                this.pointer.render(graphics, this.x() + this.width() / 2 - 3, this.y(), this.pointerShade);
                break;
            }
            case 1: {
                this.pointer.render(graphics, this.x() + this.width() / 2 - 3, this.y() + this.height() - 7, this.pointerShade);
                break;
            }
            case 3: {
                this.pointer.render(graphics, this.x(), this.y() + this.height() / 2 - 3, this.pointerShade);
                break;
            }
            case 2: {
                this.pointer.render(graphics, this.x() + this.width() - 7, this.y() + this.height() / 2 - 3, this.pointerShade);
                break;
            }
        }
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33785;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            this.close();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return true;
    }

    public static enum FlyoutPointer {
        UP(0, 54),
        DOWN(14, 54),
        RIGHT(28, 54),
        LEFT(42, 54);

        private final int u;
        private final int v;
        public static final int WIDTH = 7;
        public static final int HEIGHT = 7;

        private FlyoutPointer(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }

        public void render(Graphics graphics, int x, int y, CreateDynamicWidgets.ColorShade shade) {
            int u = shade == CreateDynamicWidgets.ColorShade.LIGHT ? this.getU() : this.getU() + 7;
            GuiUtils.drawTexture((class_2960)CRNGui.GUI, (Graphics)graphics, (int)x, (int)y, (int)7, (int)7, (int)u, (int)this.v, (int)64, (int)64);
        }
    }
}

