/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.foundation.gui.element.ScreenElement;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.options.DLOptionsList;
import de.mrjulsen.crn.client.gui.widgets.options.DataListContainer;
import de.mrjulsen.crn.client.gui.widgets.options.NewEntryWidget;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class StationTagSettingsScreen
extends AbstractNavigatorScreen {
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private DLOptionsList viewer;
    private DLEditBox searchBox;
    private final class_5250 tooltipDeleteTag = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.delete_alias.tooltip");
    private final class_5250 textAdd = TextUtils.translate((String)"gui.createrailwaysnavigator.common.add");
    private final class_5250 textStationName = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.hint.station_name");
    private final class_5250 textPlatformName = TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.hint.platform");
    private ModStationSuggestions destinationSuggestions;
    private StationTag selectedTag;
    private String searchText = "";
    private final List<String> stationNames = new ArrayList<String>();

    public StationTagSettingsScreen(class_437 lastScreen) {
        super(lastScreen, (class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.title"), CreateDynamicWidgets.BarColor.GRAY);
    }

    public void method_25393() {
        super.method_25393();
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.destinationSuggestions.getEditBox().method_20315()) {
                this.clearSuggestions();
            }
        });
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.lastScreen);
    }

    public void reload() {
        this.method_37067();
        this.method_25426();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_NAMES, names -> {
            this.stationNames.clear();
            this.stationNames.addAll((Collection<String>)names);
        });
        DLCreateIconButton helpButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 240 - 18 - 8, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                class_156.method_668().method_670("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Station-Tags");
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)Constants.TEXT_HELP).assignedTo((class_339)helpButton));
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1;
        this.searchBox = (DLEditBox)this.method_37063((class_364)new DLEditBox(this.field_22793, this.guiLeft + 4, this.guiTop + dy + 1, 232, 16, (class_2561)TextUtils.empty()){

            public boolean method_25404(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
                if (code == 257) {
                    StationTagSettingsScreen.this.searchText = this.method_1882();
                    StationTagSettingsScreen.this.reload();
                    return true;
                }
                return super.method_25404(code, p_keyPressed_2_, p_keyPressed_3_);
            }
        });
        this.searchBox.method_1852(this.searchText);
        this.searchBox.withHint(DragonLib.TEXT_SEARCH);
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((class_437)this, this.guiLeft + 240 - 8, this.guiTop + (dy += 18), 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, null);
        this.viewer = new DLOptionsList((class_437)this, this.guiLeft + 3, this.guiTop + dy, 234, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, (DLAbstractScrollBar<?>)scrollBar);
        this.method_37063((class_364)this.viewer);
        this.method_37063((class_364)scrollBar);
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_TAGS, tgs -> {
            List tags = tgs.stream().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList();
            for (StationTag tag : tags) {
                if (!tag.getTagName().get().toLowerCase(Locale.ROOT).contains(this.searchText.toLowerCase(Locale.ROOT))) continue;
                StationTag stationTag = tag;
                OptionEntry<DataListContainer> opt = this.viewer.addOption(option -> {
                    GuiAreaDefinition workspace = option.getContentSpace();
                    DataListContainer<StationTag, Map.Entry> cont = new DataListContainer<StationTag, Map.Entry>((OptionEntry<?>)((Object)((Object)option)), workspace.getX(), workspace.getY(), workspace.getWidth(), stationTag, tg -> tg.getAllStations().entrySet().stream().sorted((a, b) -> ((String)a.getKey()).compareToIgnoreCase((String)b.getKey())).iterator(), (data, entryWidget) -> {
                        entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> GlobalSettingsClient.removeStationTagEntry(tag.getId(), (String)entry.getKey(), newTag -> newTag.ifPresent(a -> refreshAction.accept(newTag))));
                        entryWidget.addDataSection(40, entry -> ((StationTag.StationInfo)entry.getValue()).platform(), EAlignment.RIGHT, (tg, entry, newValue, refreshAction) -> {
                            if (!newValue.isBlank() && !((StationTag.StationInfo)entry.getValue()).platform().equals(newValue)) {
                                GlobalSettingsClient.updateStationTagEntry(tg.getId(), (String)entry.getKey(), new StationTag.StationInfo(newValue), newTag -> newTag.ifPresent(a -> refreshAction.accept(newTag)));
                            }
                        });
                        return (String)data.getKey();
                    }, (data, entryWidget) -> {
                        entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), (class_2561)this.textAdd, (btn, tg, inputValues, refreshAction) -> {
                            String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                            String platform = (String)((Supplier)inputValues.get((Object)"platform")).get();
                            if (name == null || platform == null || name.isBlank() || platform.isBlank()) {
                                return false;
                            }
                            GlobalSettingsClient.addStationTagEntry(tg.getId(), name, new StationTag.StationInfo(platform), newTag -> newTag.ifPresent(a -> refreshAction.accept(newTag)));
                            return true;
                        });
                        entryWidget.editNameEditBox(box -> {
                            box.method_1863(b -> this.updateEditorSubwidgets((class_342)box, (StationTag)data));
                            box.method_1880(32);
                        });
                        entryWidget.setNameEditBoxTooltip(box -> this.textStationName);
                        entryWidget.addDataSection(40, "platform", (class_2561)this.textPlatformName, box -> box.method_1880(8));
                    }, self -> option.notifyContentSizeChanged());
                    cont.setPadding(3, 0, 3, 18);
                    cont.setFilter((entry, searchText) -> ((String)entry.getKey()).toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
                    cont.setBordered(false);
                    return cont;
                }, (class_2561)TextUtils.text((String)tag.getTagName().get()), (class_2561)TextUtils.empty(), (a, b) -> OptionEntry.expandOrCollapse(a), str -> {
                    if (!str.isBlank()) {
                        GlobalSettingsClient.updateStationTagNameData(stationTag.getId(), str, () -> {});
                        return true;
                    }
                    return false;
                });
                opt.addAdditionalButton(ModGuiIcons.DELETE.getAsSprite(16, 16), (class_2561)this.tooltipDeleteTag, (entry, btn) -> GlobalSettingsClient.deleteStationTag(((StationTag)((DataListContainer)((Object)((Object)((Object)entry.getContentContainer())))).getData()).getId(), () -> this.reload()));
                opt.setTooltip(List.of(TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.summary", (Object[])new Object[]{stationTag.getAllStationNames().size()}), TextUtils.translate((String)"gui.createrailwaysnavigator.station_tags.editor", (Object[])new Object[]{stationTag.getLastEditorName(), stationTag.getLastEditedTimeFormatted()})));
            }
            this.viewer.addRenderableWidget(new NewEntryWidget((class_437)this, () -> Pair.of((Object)(-this.viewer.getXScrollOffset()), (Object)(-this.viewer.getYScrollOffset())), val -> {
                GlobalSettingsClient.createStationTag(val, tag -> this.reload());
                return true;
            }, 0, 0, this.viewer.getContentWidth()));
        });
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderNavigatorBackground(graphics, mouseX, mouseY, partialTicks);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        int h = 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size();
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, h + 1, CreateDynamicWidgets.ContainerColor.PURPLE);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_22904(-this.viewer.getXScrollOffset(), -this.viewer.getYScrollOffset(), 0.0);
            x.render(graphics.poseStack(), (int)((double)mouseX + this.viewer.getXScrollOffset()), (int)((double)mouseY + this.viewer.getYScrollOffset()));
            graphics.poseStack().method_22909();
        });
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), MathUtils.clamp((double)delta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().method_1887("");
        }
        this.destinationSuggestions = null;
    }

    public void updateEditorSubwidgets(class_342 field, StationTag tag) {
        this.clearSuggestions();
        this.selectedTag = tag;
        this.destinationSuggestions = new ModStationSuggestions(class_310.method_1551(), (class_437)this, field, this.field_22793, this.getViableStations(this.stationNames, field), field.method_25364() + 2 + field.field_22761);
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<String> getViableStations(Collection<String> src, class_342 field) {
        return src.stream().distinct().filter(x -> !this.selectedTag.contains((String)x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }
}

