/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.screen.GlobalSettingsScreen;
import de.mrjulsen.crn.client.gui.screen.SavedRoutesScreen;
import de.mrjulsen.crn.client.gui.screen.ScheduleBoardScreen;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.AbstractNotificationPopup;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModDestinationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.RouteViewer;
import de.mrjulsen.crn.client.gui.widgets.SearchOptionButton;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutAdvancedSearchsettingsWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutDepartureInWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutTrainGroupsWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutTransferTimeWidget;
import de.mrjulsen.crn.client.gui.widgets.notifications.NotificationTrainInitialization;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.GuiIcons;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;

public class NavigatorScreen
extends AbstractNavigatorScreen {
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private boolean initialized = false;
    private int angle = 0;
    private DLCreateIconButton locationButton;
    private DLCreateIconButton searchButton;
    private DLCreateIconButton globalSettingsButton;
    private DLEditBox fromBox;
    private DLEditBox toBox;
    private RouteViewer routeViewer;
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0.0);
    private ModDestinationSuggestions destinationSuggestions;
    private AbstractNotificationPopup notificationPopup;
    private UserSettings userSettings;
    private final Collection<ClientRoute> routes;
    private final List<StationTag> stationNames;
    private String stationFrom;
    private String stationTo;
    private final NavigatorScreen instance;
    private boolean isLoadingRoutes;
    private boolean generatingRouteEntries;
    private final class_5250 searchingText;
    private final class_5250 noConnectionsText;
    private final class_5250 notSearchedText;
    private final class_5250 errorTitle;
    private final class_5250 startEndEqualText;
    private final class_5250 startEndNullText;
    private final class_5250 tooltipSearch;
    private final class_5250 tooltipLocation;
    private final class_5250 tooltipSwitch;
    private final class_5250 tooltipGlobalSettings;
    private final class_5250 tooltipSavedRoutes;
    private final class_5250 tooltipScheduleViewer;

    public NavigatorScreen(class_437 lastScreen) {
        super(lastScreen, (class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.title"), CreateDynamicWidgets.BarColor.GRAY);
        this.userSettings = new UserSettings(class_310.method_1551().field_1724.method_5667(), false);
        this.routes = new ArrayList<ClientRoute>();
        this.stationNames = new ArrayList<StationTag>();
        this.stationFrom = "";
        this.stationTo = "";
        this.isLoadingRoutes = false;
        this.generatingRouteEntries = false;
        this.searchingText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.searching");
        this.noConnectionsText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.no_connections");
        this.notSearchedText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.not_searched");
        this.errorTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.error_title");
        this.startEndEqualText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_equal");
        this.startEndNullText = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.start_end_null");
        this.tooltipSearch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.search.tooltip");
        this.tooltipLocation = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.location.tooltip");
        this.tooltipSwitch = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.switch.tooltip");
        this.tooltipGlobalSettings = TextUtils.translate((String)"gui.createrailwaysnavigator.navigator.global_settings.tooltip");
        this.tooltipSavedRoutes = TextUtils.translate((String)"gui.createrailwaysnavigator.saved_routes.title");
        this.tooltipScheduleViewer = TextUtils.translate((String)"gui.createrailwaysnavigator.schedule_board.title");
        this.instance = this;
    }

    private void generateRouteEntries() {
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        super.method_25419();
        this.clearRoutes();
    }

    public void method_25432() {
        super.method_25432();
    }

    public synchronized void clearRoutes() {
        this.routes.stream().forEach(x -> x.close());
        this.routes.clear();
    }

    private void switchButtonClick() {
        String fromInput = this.fromBox.method_1882();
        String toInput = this.toBox.method_1882();
        this.fromBox.method_1852(toInput);
        this.toBox.method_1852(fromInput);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.setAllowedLayer(0);
        this.initialized = false;
        DataAccessor.getFromServer((Object)true, ModAccessorTypes.GET_ALL_STATIONS_AS_TAGS, names -> {
            this.stationNames.clear();
            this.stationNames.addAll((Collection<StationTag>)names);
        });
        this.locationButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 195, this.guiTop + 20, 18, 18, (ScreenElement)ModGuiIcons.POSITION.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                DataAccessor.getFromServer((Object)((NavigatorScreen)NavigatorScreen.this).field_22787.field_1724.method_24515(), ModAccessorTypes.GET_NEAREST_STATION, result -> {
                    if (result.tagName.isPresent()) {
                        NavigatorScreen.this.fromBox.method_1852(result.tagName.get().get());
                    }
                });
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipLocation).assignedTo((class_339)this.locationButton));
        this.fromBox = this.addEditBox(this.guiLeft + 32 + 5, this.guiTop + 25, 157, 12, this.stationFrom, (class_2561)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationFrom = v;
            this.updateEditorSubwidgets(this.fromBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.fromBox.method_1880(32);
        this.toBox = this.addEditBox(this.guiLeft + 32 + 5, this.guiTop + 47, 157, 12, this.stationTo, (class_2561)TextUtils.empty(), false, v -> {
            if (!this.initialized) {
                return;
            }
            this.stationTo = v;
            this.updateEditorSubwidgets(this.toBox);
        }, this.NO_EDIT_BOX_FOCUS_CHANGE_ACTION, null);
        this.toBox.method_1880(32);
        if (this.field_22787.field_1724.method_5687(((Integer)ModCommonConfig.GLOBAL_SETTINGS_PERMISSION_LEVEL.get()).intValue())) {
            this.globalSettingsButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 30, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.SETTINGS.getAsCreateIcon()){

                public void method_25348(double mouseX, double mouseY) {
                    super.method_25348(mouseX, mouseY);
                    NavigatorScreen.this.field_22787.method_1507((class_437)new GlobalSettingsScreen((class_437)NavigatorScreen.this.instance));
                }
            });
            this.addTooltip(DLTooltip.of((class_5348)this.tooltipGlobalSettings).assignedTo((class_339)this.globalSettingsButton));
        }
        DLCreateIconButton savedRoutes = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 240 - 18 - 8, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.MAP_PATH.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                NavigatorScreen.this.field_22787.method_1507((class_437)new SavedRoutesScreen((class_437)NavigatorScreen.this.instance));
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipSavedRoutes).assignedTo((class_339)savedRoutes));
        DLCreateIconButton scheduleBoardBtn = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 240 - 18 - 30, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.VERY_DETAILED.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                NavigatorScreen.this.field_22787.method_1507((class_437)new ScheduleBoardScreen((class_437)NavigatorScreen.this.instance, null));
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipScheduleViewer).assignedTo((class_339)scheduleBoardBtn));
        DLIconButton btn = (DLIconButton)this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, new Sprite(CRNGui.GUI, 64, 64, 55, 0, 9, 12), this.guiLeft + 176, this.guiTop + 33, 13, 14, (class_2561)TextUtils.empty(), b -> this.switchButtonClick()));
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipSwitch).assignedTo((class_339)btn));
        btn.setBackColor(0);
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((class_437)this, this.guiLeft + 240 - 8, this.guiTop + 88, 128, GuiAreaDefinition.empty());
        this.routeViewer = (RouteViewer)this.method_37063((class_364)new RouteViewer((class_437)this, this.guiLeft + 3, this.guiTop + 88, 234, 128, (DLAbstractScrollBar<?>)scrollBar));
        this.method_37063((class_364)scrollBar);
        DLUtils.doIfNotNull((Object)((Object)this.routeViewer), x -> x.displayRoutes((List<ClientRoute>)ImmutableList.copyOf(this.routes)));
        this.searchButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 195, this.guiTop + 42, 18, 18, (ScreenElement)AllIcons.I_MTD_SCAN){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                if (NavigatorScreen.this.stationFrom == null || NavigatorScreen.this.stationTo == null || NavigatorScreen.this.stationFrom.isBlank() || NavigatorScreen.this.stationTo.isBlank()) {
                    class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)NavigatorScreen.this.errorTitle, (class_2561)NavigatorScreen.this.startEndNullText));
                    return;
                }
                if (NavigatorScreen.this.stationFrom.equals(NavigatorScreen.this.stationTo)) {
                    class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_371.field_36445, (class_2561)NavigatorScreen.this.errorTitle, (class_2561)NavigatorScreen.this.startEndEqualText));
                    return;
                }
                NavigatorScreen.this.isLoadingRoutes = true;
                NavigatorScreen.this.clearRoutes();
                NavigatorScreen.this.routeViewer.clear();
                DataAccessor.getFromServer((Object)new ModAccessorTypes.NavigationData(NavigatorScreen.this.stationFrom, NavigatorScreen.this.stationTo, class_310.method_1551().field_1724.method_5667()), ModAccessorTypes.NAVIGATE, routeList -> {
                    NavigatorScreen.this.routes.addAll((Collection<ClientRoute>)routeList);
                    NavigatorScreen.this.routeViewer.displayRoutes((List<ClientRoute>)ImmutableList.copyOf(NavigatorScreen.this.routes));
                    NavigatorScreen.this.isLoadingRoutes = false;
                    DataAccessor.getFromServer(null, ModAccessorTypes.ALL_TRAINS_INITIALIZED, result -> {
                        DLUtils.doIfNotNull((Object)((Object)NavigatorScreen.this.notificationPopup), x -> x.close());
                        if (!result.booleanValue()) {
                            NavigatorScreen.this.notificationPopup = (AbstractNotificationPopup)NavigatorScreen.this.method_37063((class_364)new NotificationTrainInitialization(NavigatorScreen.this.instance, NavigatorScreen.this.guiLeft + 10, NavigatorScreen.this.guiTop + 247 - CreateDynamicWidgets.FooterSize.DEFAULT.size() - 20, 220, arg_0 -> ((NavigatorScreen)NavigatorScreen.this.instance).method_37066(arg_0)));
                        }
                    });
                });
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)this.tooltipSearch).assignedTo((class_339)this.searchButton));
        int btnCount = 3;
        int btnWidth = 72;
        this.method_37063((class_364)new SearchOptionButton(this.guiLeft + 3, this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.departure_in"), () -> this.userSettings.navigationDepartureInTicks.toString(), b -> new FlyoutDepartureInWidget<class_6379>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> {
            class_6379 cfr_ignored_0 = (class_6379)this.method_37063((class_364)x$0);
        }, this.userSettings, () -> this.userSettings.navigationDepartureInTicks, w -> {
            this.method_37066((class_364)w);
            this.reloadUserSettings();
        }).open((IDragonLibWidget)b)));
        this.method_37063((class_364)new SearchOptionButton(this.guiLeft + 3 + btnWidth, this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.transfer_time"), () -> this.userSettings.navigationTransferTime.toString(), b -> new FlyoutTransferTimeWidget<class_6379>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> {
            class_6379 cfr_ignored_0 = (class_6379)this.method_37063((class_364)x$0);
        }, this.userSettings, () -> this.userSettings.navigationTransferTime, w -> {
            this.method_37066((class_364)w);
            this.reloadUserSettings();
        }).open((IDragonLibWidget)b)));
        this.method_37063((class_364)new SearchOptionButton(this.guiLeft + 3 + btnWidth * 2, this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, btnWidth, 18, (class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.search_options.train_groups"), () -> this.userSettings.navigationExcludedTrainGroups.toString(), b -> new FlyoutTrainGroupsWidget<class_6379>((DLScreen)this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> {
            class_6379 cfr_ignored_0 = (class_6379)this.method_37063((class_364)x$0);
        }, this.userSettings, () -> this.userSettings.navigationExcludedTrainGroups, w -> {
            this.method_37066((class_364)w);
            this.reloadUserSettings();
        }).open((IDragonLibWidget)b)));
        DLIconButton moreSearchOptionsBtn = (DLIconButton)this.method_37063((class_364)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, GuiIcons.ARROW_RIGHT.getAsSprite(16, 16), this.guiLeft + 240 - 3 - (240 - btnWidth * 3 - 6), this.guiTop + 54 + CreateDynamicWidgets.FooterSize.DEFAULT.size() - 2, 240 - btnWidth * 3 - 6, 18, (class_2561)TextUtils.empty(), b -> new FlyoutAdvancedSearchsettingsWidget<class_6379>(this, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, x$0 -> {
            class_6379 cfr_ignored_0 = (class_6379)this.method_37063((class_364)x$0);
        }, w -> this.method_37066((class_364)w)).open((IDragonLibWidget)b)));
        moreSearchOptionsBtn.setBackColor(0);
        this.generateRouteEntries();
        this.reloadUserSettings();
        this.initialized = true;
    }

    private void reloadUserSettings() {
        DataAccessor.getFromServer((Object)class_310.method_1551().field_1724.method_5667(), ModAccessorTypes.GET_USER_SETTINGS, settings -> {
            this.userSettings = settings;
        });
    }

    protected void updateEditorSubwidgets(DLEditBox field) {
        this.updateEditorSubwidgetsInternal(field, this.getViableStations(this.stationNames));
    }

    protected void updateEditorSubwidgetsInternal(DLEditBox field, List<StationTag> list) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModDestinationSuggestions(this.field_22787, (class_437)this, (class_342)field, this.field_22793, list, field.method_25364() + 2 + field.y());
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<StationTag> getViableStations(Collection<StationTag> src) {
        return src.stream().distinct().sorted((a, b) -> a.getTagName().get().compareToIgnoreCase(b.getTagName().get())).toList();
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().method_1887("");
        }
        this.destinationSuggestions = null;
    }

    public void method_25393() {
        this.scroll.tickChaser();
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.toBox.method_20315() && !this.fromBox.method_20315()) {
                this.clearSuggestions();
            }
        });
        DLUtils.doIfNotNull((Object)((Object)this.searchButton), x -> x.set_active(!this.isLoadingRoutes));
        super.method_25393();
    }

    public void renderMainLayer(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = this.field_22787.method_1488();
        this.angle = (int)((float)this.angle + 6.0f * pPartialTick);
        if (this.angle > 360) {
            this.angle = 0;
        }
        this.renderNavigatorBackground(graphics, pMouseX, pMouseY, pPartialTick);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, 52, CreateDynamicWidgets.ContainerColor.BLUE);
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y + 52 - 1, 238, 22, CreateDynamicWidgets.ContainerColor.GOLD);
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + (y += 72), 238, 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size() + 1, CreateDynamicWidgets.ContainerColor.GRAY);
        CreateDynamicWidgets.renderTextBox(graphics, this.guiLeft + 32, this.guiTop + 20, 159);
        CreateDynamicWidgets.renderTextBox(graphics, this.guiLeft + 32, this.guiTop + 42, 159);
        GuiUtils.drawTexture((class_2960)CRNGui.GUI, (Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 16), (int)7, (int)24, (int)0, (int)30, (int)7, (int)24, (int)64, (int)64);
        GuiUtils.drawTexture((class_2960)CRNGui.GUI, (Graphics)graphics, (int)(this.guiLeft + 16), (int)(this.guiTop + 16 + 24), (int)7, (int)24, (int)7, (int)30, (int)7, (int)24, (int)64, (int)64);
        if (!this.isLoadingRoutes && !this.generatingRouteEntries) {
            if (this.routes == null) {
                GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 120), (int)(this.guiTop + 32 + 123), (class_5348)this.notSearchedText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                ModGuiIcons.INFO.render(graphics, this.guiLeft + 120 - 8, this.guiTop + 123);
            } else if (this.routes.isEmpty()) {
                GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 120), (int)(this.guiTop + 32 + 123), (class_5348)this.noConnectionsText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
                AllIcons.I_ACTIVE.render(graphics.poseStack(), this.guiLeft + 120 - 8, this.guiTop + 123);
            }
        } else {
            double offsetX = Math.sin(Math.toRadians(this.angle)) * 5.0;
            double offsetY = Math.cos(Math.toRadians(this.angle)) * 5.0;
            GuiUtils.drawString((Graphics)graphics, (class_327)this.field_22793, (int)(this.guiLeft + 120), (int)(this.guiTop + 32 + 123), (class_5348)this.searchingText, (int)0xFFFFFF, (EAlignment)EAlignment.CENTER, (boolean)false);
            AllIcons.I_MTD_SCAN.render(graphics.poseStack(), (int)((double)(this.guiLeft + 120 - 8) + offsetX), (int)((double)(this.guiTop + 123) + offsetY));
        }
        super.renderMainLayer(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.destinationSuggestions != null) {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_22904(0.0, 0.0, 500.0);
            this.destinationSuggestions.render(graphics.poseStack(), mouseX, mouseY);
            graphics.poseStack().method_22909();
        }
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked((int)pMouseX, (int)pMouseY, pButton)) {
            return true;
        }
        return super.method_25402(pMouseX, pMouseY, pButton);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(pMouseX, pMouseY, class_3532.method_15350((double)pDelta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.method_25401(pMouseX, pMouseY, pDelta);
    }
}

