/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.screen;

import com.simibubi.create.foundation.gui.element.ScreenElement;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.screen.AbstractNavigatorScreen;
import de.mrjulsen.crn.client.gui.screen.StationTagSettingsScreen;
import de.mrjulsen.crn.client.gui.widgets.DLCreateIconButton;
import de.mrjulsen.crn.client.gui.widgets.ModStationSuggestions;
import de.mrjulsen.crn.client.gui.widgets.ModernVerticalScrollBar;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutColorPicker;
import de.mrjulsen.crn.client.gui.widgets.options.DLOptionsList;
import de.mrjulsen.crn.client.gui.widgets.options.DataListContainer;
import de.mrjulsen.crn.client.gui.widgets.options.OptionEntry;
import de.mrjulsen.crn.data.TrainGroup;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.storage.GlobalSettingsClient;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLVerticalScrollBar;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;

public class GlobalSettingsScreen
extends AbstractNavigatorScreen {
    private static final int DEFAULT_ICON_BUTTON_WIDTH = 18;
    private static final int DEFAULT_ICON_BUTTON_HEIGHT = 18;
    private DLOptionsList viewer;
    private ModStationSuggestions destinationSuggestions;
    private final class_2561 optionTagTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_alias.title");
    private final class_2561 optionTagDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_alias.description");
    private final class_2561 optionBlacklistTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_blacklist.title");
    private final class_2561 optionBlacklistDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.option_blacklist.description");
    private final class_2561 optionTrainGroupTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_group.title");
    private final class_2561 optionTrainGroupDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_group.description");
    private final class_2561 optionTrainBlacklistTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_blacklist.title");
    private final class_2561 optionTrainBlacklistDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_blacklist.description");
    private final class_2561 optionTrainLineTitle = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.title");
    private final class_2561 optionTrainLineDescription = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.description");
    private final class_2561 textAdd = TextUtils.translate((String)"gui.createrailwaysnavigator.common.add");
    private final class_2561 textColor = TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.train_line.color");
    private final List<String> stationNames = new ArrayList<String>();
    private final List<String> trainNames = new ArrayList<String>();

    public GlobalSettingsScreen(class_437 lastScreen) {
        super(lastScreen, (class_2561)TextUtils.translate((String)"gui.createrailwaysnavigator.global_settings.title"), CreateDynamicWidgets.BarColor.GRAY);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.lastScreen);
    }

    public void method_25393() {
        super.method_25393();
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            x.tick();
            if (!this.destinationSuggestions.getEditBox().method_20315()) {
                this.clearSuggestions();
            }
        });
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.setAllowedLayer(0);
        DLCreateIconButton helpButton = (DLCreateIconButton)this.method_37063((class_364)new DLCreateIconButton(this.guiLeft + 240 - 18 - 8, this.guiTop + 223, 18, 18, (ScreenElement)ModGuiIcons.HELP.getAsCreateIcon()){

            public void method_25348(double mouseX, double mouseY) {
                super.method_25348(mouseX, mouseY);
                class_156.method_668().method_670("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Global-Settings");
            }
        });
        this.addTooltip(DLTooltip.of((class_5348)Constants.TEXT_HELP).assignedTo((class_339)helpButton));
        int dy = CreateDynamicWidgets.FooterSize.DEFAULT.size() + 1;
        ModernVerticalScrollBar scrollBar = new ModernVerticalScrollBar((class_437)this, this.guiLeft + 240 - 8, this.guiTop + dy, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, null);
        this.viewer = new DLOptionsList((class_437)this, this.guiLeft + 3, this.guiTop + dy, 234, 247 - dy - CreateDynamicWidgets.FooterSize.SMALL.size() - 1, (DLAbstractScrollBar<?>)scrollBar);
        this.method_37063((class_364)this.viewer);
        this.method_37063((class_364)scrollBar);
        this.viewer.addOption(null, this.optionTagTitle, this.optionTagDescription, (a, b) -> class_310.method_1551().method_1507((class_437)new StationTagSettingsScreen((class_437)this)), null);
        GlobalSettingsClient.getBlacklistedStations(datalist -> {
            this.addBlacklistedStationsWidget(datalist.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).toList(), scrollBar);
            GlobalSettingsClient.getBlacklistedTrains(datalist2 -> {
                this.addBlacklistedTrainsWidget(datalist2.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).toList(), scrollBar);
                GlobalSettingsClient.getTrainGroups(datalist3 -> {
                    this.addTrainGroupsWidget(datalist3.stream().sorted((a, b) -> a.getGroupName().compareToIgnoreCase(b.getGroupName())).toList(), scrollBar);
                    GlobalSettingsClient.getTrainLines(datalist4 -> this.addTrainLinesWidget(datalist4.stream().sorted((a, b) -> a.getLineName().compareToIgnoreCase(b.getLineName())).toList(), scrollBar));
                });
            });
        });
        DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_TRAIN_NAMES, names -> {
            this.trainNames.clear();
            this.trainNames.addAll((Collection<String>)names);
            DataAccessor.getFromServer(null, ModAccessorTypes.GET_ALL_STATION_NAMES, names2 -> {
                this.stationNames.clear();
                this.stationNames.addAll((Collection<String>)names2);
            });
        });
    }

    private void addBlacklistedStationsWidget(List<String> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, String> cont = new DataListContainer<Collection, String>((OptionEntry<?>)((Object)option), workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).iterator(), (data, entryWidget) -> {
                entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> GlobalSettingsClient.removeStationFromBlacklist(entry, res -> refreshAction.accept(Optional.ofNullable(res))));
                return data;
            }, (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), this.textAdd, (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.addStationToBlacklist(name, res -> refreshAction.accept(Optional.ofNullable(res)));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.method_1863(b -> this.updateEditorSubwidgetsStations((DLEditBox)box, (Collection<String>)data));
                    box.method_1880(32);
                });
            }, self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionBlacklistTitle, this.optionBlacklistDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), Constants.TEXT_HELP, (entry, btn) -> class_156.method_668().method_670("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Station-Blacklist"));
    }

    private void addBlacklistedTrainsWidget(List<String> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, String> cont = new DataListContainer<Collection, String>((OptionEntry<?>)((Object)option), workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.compareToIgnoreCase((String)b)).iterator(), (data, entryWidget) -> {
                entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> GlobalSettingsClient.removeTrainFromBlacklist(entry, res -> refreshAction.accept(Optional.ofNullable(res))));
                return data;
            }, (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), this.textAdd, (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.addTrainToBlacklist(name, res -> refreshAction.accept(Optional.ofNullable(res)));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.method_1863(b -> this.updateEditorSubwidgetsTrains((DLEditBox)box, (Collection<String>)data));
                    box.method_1880(32);
                });
            }, self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionTrainBlacklistTitle, this.optionTrainBlacklistDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), Constants.TEXT_HELP, (entry, btn) -> class_156.method_668().method_670("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Blacklist"));
    }

    private void addTrainGroupsWidget(List<TrainGroup> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, TrainGroup> cont = new DataListContainer<Collection, TrainGroup>((OptionEntry<?>)((Object)option), workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.getGroupName().compareToIgnoreCase(b.getGroupName())).iterator(), (data, entryWidget) -> {
                entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> GlobalSettingsClient.deleteTrainGroup(entry.getGroupName(), () -> GlobalSettingsClient.getTrainGroups(res -> refreshAction.accept(Optional.ofNullable(res)))));
                DLIconButton colorBtn = entryWidget.addButton(ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16), this.textColor, (btn, tg, entry, refreshAction) -> {
                    TrainGroup e = entry;
                    FlyoutColorPicker<class_6379> flyout = new FlyoutColorPicker<class_6379>(this, e.getColor(), Constants.DEFAULT_TRAIN_TYPE_COLORS, 5, true, true, x$0 -> {
                        class_6379 cfr_ignored_0 = (class_6379)this.method_37063((class_364)x$0);
                    }, w -> {
                        GlobalSettingsClient.updateTrainGroupColor(e.getGroupName(), ((FlyoutColorPicker)((Object)((Object)((Object)((Object)w))))).getColorPicker().getSelectedColor(), () -> GlobalSettingsClient.getTrainGroups(res -> refreshAction.accept(Optional.ofNullable(res))));
                        this.method_37066((class_364)w);
                    });
                    flyout.setYOffset((int)(-scrollBar.getScrollValue()));
                    flyout.open((IDragonLibWidget)btn);
                });
                colorBtn.setBackColor(data.getColor());
                return data.getGroupName();
            }, (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), this.textAdd, (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.createTrainGroup(name, res -> GlobalSettingsClient.getTrainGroups(r -> refreshAction.accept(Optional.ofNullable(r))));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.method_1863(b -> {});
                    box.method_1880(32);
                });
            }, self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.getGroupName().toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionTrainGroupTitle, this.optionTrainGroupDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), Constants.TEXT_HELP, (entry, btn) -> class_156.method_668().method_670("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Groups"));
    }

    private void addTrainLinesWidget(List<TrainLine> datalist, DLVerticalScrollBar scrollBar) {
        OptionEntry<DLWidgetContainer> opt = this.viewer.addOption(option -> {
            GuiAreaDefinition workspace = option.getContentSpace();
            DataListContainer<Collection, TrainLine> cont = new DataListContainer<Collection, TrainLine>((OptionEntry<?>)((Object)option), workspace.getX(), workspace.getY(), workspace.getWidth(), datalist, list -> list.stream().sorted((a, b) -> a.getLineName().compareToIgnoreCase(b.getLineName())).iterator(), (data, entryWidget) -> {
                entryWidget.addDeleteButton((btn, tg, entry, refreshAction) -> GlobalSettingsClient.deleteTrainLine(entry.getLineName(), () -> GlobalSettingsClient.getTrainLines(res -> refreshAction.accept(Optional.ofNullable(res)))));
                DLIconButton colorBtn = entryWidget.addButton(ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16), this.textColor, (btn, tg, entry, refreshAction) -> {
                    TrainLine e = entry;
                    FlyoutColorPicker<class_6379> flyout = new FlyoutColorPicker<class_6379>(this, e.getColor(), Constants.DEFAULT_TRAIN_TYPE_COLORS, 5, true, true, x$0 -> {
                        class_6379 cfr_ignored_0 = (class_6379)this.method_37063((class_364)x$0);
                    }, w -> {
                        GlobalSettingsClient.updateTrainLineColor(e.getLineName(), ((FlyoutColorPicker)((Object)((Object)((Object)((Object)w))))).getColorPicker().getSelectedColor(), () -> GlobalSettingsClient.getTrainLines(res -> refreshAction.accept(Optional.ofNullable(res))));
                        this.method_37066((class_364)w);
                    });
                    flyout.setYOffset((int)(-scrollBar.getScrollValue()));
                    flyout.open((IDragonLibWidget)btn);
                });
                colorBtn.setBackColor(data.getColor());
                return data.getLineName();
            }, (data, entryWidget) -> {
                entryWidget.addAddButton(ModGuiIcons.ADD.getAsSprite(16, 16), this.textAdd, (btn, tg, inputValues, refreshAction) -> {
                    String name = (String)((Supplier)inputValues.get((Object)"name")).get();
                    if (name == null || name.isBlank()) {
                        return false;
                    }
                    GlobalSettingsClient.createTrainLine(name, res -> GlobalSettingsClient.getTrainLines(r -> refreshAction.accept(Optional.ofNullable(r))));
                    return true;
                });
                entryWidget.editNameEditBox(box -> {
                    box.method_1863(b -> {});
                    box.method_1880(32);
                });
            }, self -> option.notifyContentSizeChanged());
            cont.setPadding(3, 0, 3, 18);
            cont.setFilter((entry, searchText) -> entry.getLineName().toLowerCase(Locale.ROOT).contains(((String)searchText.get()).toLowerCase(Locale.ROOT)));
            cont.setBordered(false);
            return cont;
        }, this.optionTrainLineTitle, this.optionTrainLineDescription, (a, b) -> OptionEntry.expandOrCollapse(a), null);
        opt.addAdditionalButton(ModGuiIcons.HELP.getAsSprite(16, 16), Constants.TEXT_HELP, (entry, btn) -> class_156.method_668().method_670("https://github.com/MisterJulsen/Create-Train-Navigator/wiki/Train-Lines"));
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderNavigatorBackground(graphics, mouseX, mouseY, partialTicks);
        int y = CreateDynamicWidgets.FooterSize.DEFAULT.size() - 1;
        int h = 247 - y - CreateDynamicWidgets.FooterSize.SMALL.size();
        CreateDynamicWidgets.renderContainer(graphics, this.guiLeft + 1, this.guiTop + y, 238, h + 1, CreateDynamicWidgets.ContainerColor.PURPLE);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTick);
        DLUtils.doIfNotNull((Object)this.destinationSuggestions, x -> {
            graphics.poseStack().method_22903();
            graphics.poseStack().method_22904(-this.viewer.getXScrollOffset(), -this.viewer.getYScrollOffset(), 0.0);
            x.render(graphics.poseStack(), (int)((double)mouseX + this.viewer.getXScrollOffset()), (int)((double)mouseY + this.viewer.getYScrollOffset()));
            graphics.poseStack().method_22909();
        });
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseScrolled(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), MathUtils.clamp((double)delta, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.destinationSuggestions != null && this.destinationSuggestions.mouseClicked(mouseX + this.viewer.getXScrollOffset(), mouseY + this.viewer.getYScrollOffset(), button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void clearSuggestions() {
        if (this.destinationSuggestions != null) {
            this.destinationSuggestions.getEditBox().method_1887("");
        }
        this.destinationSuggestions = null;
    }

    public void updateEditorSubwidgetsTrains(DLEditBox field, Collection<String> blacklisted) {
        this.updateEditorSubwidgetsInternal(field, this.getViableTrains(this.trainNames, blacklisted));
    }

    public void updateEditorSubwidgetsStations(DLEditBox field, Collection<String> blacklisted) {
        this.updateEditorSubwidgetsInternal(field, this.getViableStations(this.stationNames, blacklisted));
    }

    private void updateEditorSubwidgetsInternal(DLEditBox field, List<String> data) {
        this.clearSuggestions();
        this.destinationSuggestions = new ModStationSuggestions(class_310.method_1551(), (class_437)this, (class_342)field, this.field_22793, data, field.method_25364() + 2 + field.field_22761);
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
    }

    private List<String> getViableStations(Collection<String> src, Collection<String> blacklisted) {
        return src.stream().distinct().filter(x -> !blacklisted.contains(x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }

    private List<String> getViableTrains(Collection<String> src, Collection<String> blacklisted) {
        return src.stream().distinct().filter(x -> !blacklisted.contains(x)).sorted((a, b) -> a.compareTo((String)b)).toList();
    }
}

