/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay.pages;

import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.ClientRoutePart;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class RouteOverviewPage
extends AbstractRouteDetailsPage {
    public static final int ENTRY_HEIGHT = 14;
    private static final class_5250 textTransfer = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.schedule_transfer");
    private static final class_5250 textConnectionEndangered = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.connection_endangered");
    private static final class_5250 textConnectionMissed = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.connection_missed");

    public RouteOverviewPage(ClientRoute route) {
        super(route);
    }

    @Override
    public boolean isImportant() {
        return false;
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        int y = -2;
        int n = 0;
        List parts = this.route.getClientParts().stream().skip(Math.max(this.route.getCurrentPartIndex(), 0)).toList();
        for (int i = 0; i < parts.size(); ++i) {
            ClientRoutePart part = (ClientRoutePart)parts.get(i);
            int toSkip = Math.max(part.getNextStopIndex(), 0);
            List stops = part.getAllStops().stream().skip(toSkip).toList();
            for (int k = 0; k < stops.size() && n < 5; ++k, ++n) {
                TrainStop stop = (TrainStop)stops.get(k);
                RouteOverviewPage.renderStation(graphics, y, this.width(), this.font, stop, toSkip <= 0 && i > 0 && k == 0 ? RoutePathIcons.TRANSFER_STOP : RoutePathIcons.STOP, stop == part.getFirstStop(), !this.route.isPartReachable(part));
                y += 14;
                if (i >= parts.size() - 1 || k < stops.size() - 1) continue;
                Optional<TransferConnection> connection = this.route.getConnectionWith(stop);
                if (connection.isPresent()) {
                    RouteOverviewPage.renderTransfer(graphics, y, this.width(), this.font, connection.get());
                }
                y += 14;
            }
        }
    }

    public static void renderStation(Graphics graphics, int y, int width, class_327 font, TrainStop stop, RoutePathIcons icon, boolean isStart, boolean isMissed) {
        int precision = (Integer)ModClientConfig.REALTIME_PRECISION_THRESHOLD.get();
        Objects.requireNonNull(font);
        GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)7, (int)(y + 14 - 2 - 9 / 2), (class_5348)TextUtils.text((String)TimeUtils.parseTime((long)((isStart ? stop.getScheduledDepartureTime() : stop.getScheduledArrivalTime()) + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))).method_27692(isMissed ? class_124.field_1055 : class_124.field_1070), (int)(isMissed ? -48574 : -2368549), (EAlignment)EAlignment.LEFT, (boolean)false);
        if (stop.shouldRenderRealTime() && !isMissed) {
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)39, (int)(y + 14 - 2 - 9 / 2), (String)TimeUtils.parseTime((long)((isStart ? stop.getScheduledDepartureTime() + stop.getDepartureTimeDeviation() / (long)precision * (long)precision : stop.getScheduledArrivalTime() + stop.getArrivalTimeDeviation() / (long)precision * (long)precision) + DragonLib.daytimeShift()), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get())), (int)(stop.isArrivalDelayed() ? -48574 : -15013281), (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        icon.getAsSprite().render(graphics, 74, y);
        Objects.requireNonNull(font);
        GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (class_5348)GuiUtils.ellipsisString((class_327)font, (class_2561)TextUtils.text((String)stop.getClientTag().tagName()), (int)(width - 88 - font.method_1727(stop.getRealTimeStationTag().info().platform()) - 10)), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        Objects.requireNonNull(font);
        GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)(width - 4), (int)(y + 14 - 2 - 9 / 2), (String)stop.getRealTimeStationTag().info().platform(), (int)(stop.isStationInfoChanged() ? -48574 : -2368549), (EAlignment)EAlignment.RIGHT, (boolean)false);
    }

    public static void renderTransfer(Graphics graphics, int y, int width, class_327 font, TransferConnection connection) {
        if (connection.isConnectionMissed()) {
            ModGuiIcons.CROSS.getAsSprite(16, 16).render(graphics, 5, y + 14 - 2 - 8);
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (class_5348)textConnectionMissed.method_27692(class_124.field_1067).method_27692(class_124.field_1061), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        } else if (connection.isConnectionEndangered()) {
            ModGuiIcons.WARN.getAsSprite(16, 16).render(graphics, 5, y + 14 - 2 - 8);
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (class_5348)textConnectionEndangered.method_27692(class_124.field_1067).method_27692(class_124.field_1065), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)false);
        } else {
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)7, (int)(y + 14 - 2 - 9 / 2), (class_5348)TextUtils.text((String)TimeUtils.parseDurationShort((long)((int)connection.getRealTimeTransferTime()))).method_27692(class_124.field_1056), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
            Objects.requireNonNull(font);
            GuiUtils.drawString((Graphics)graphics, (class_327)font, (int)88, (int)(y + 14 - 2 - 9 / 2), (class_5348)textTransfer.method_27692(class_124.field_1056), (int)-2368549, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        RoutePathIcons.TRANSFER.getAsSprite().render(graphics, 74, y);
    }

    public static enum RoutePathIcons {
        CURRENT(0),
        STOP(1),
        TRANSFER_STOP(2),
        TRANSFER(3),
        START(4);

        private static final int V = 30;
        private static final int START_U = 21;
        private static final int SPRITE_WIDTH = 7;
        private static final int SPRITE_HEIGHT = 14;
        private int index;

        private RoutePathIcons(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static RoutePathIcons getByIndex(int index) {
            return Arrays.stream(RoutePathIcons.values()).filter(x -> x.getIndex() == index).findFirst().orElse(START);
        }

        public Sprite getAsSprite() {
            return new Sprite(CRNGui.GUI, 64, 64, 21 + this.getIndex() * 7, 30, 7, 14, 7, 14, 0, 0);
        }
    }
}

