/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.client.ModGuiUtils;
import de.mrjulsen.crn.client.gui.overlay.OverlayPosition;
import de.mrjulsen.crn.client.gui.overlay.pages.AbstractRouteDetailsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.ConnectionMissedPage;
import de.mrjulsen.crn.client.gui.overlay.pages.JourneyCompletedPage;
import de.mrjulsen.crn.client.gui.overlay.pages.NextConnectionsPage;
import de.mrjulsen.crn.client.gui.overlay.pages.RouteOverviewPage;
import de.mrjulsen.crn.client.gui.overlay.pages.TrainCancelledInfo;
import de.mrjulsen.crn.client.gui.overlay.pages.TransferPage;
import de.mrjulsen.crn.client.gui.overlay.pages.WelcomePage;
import de.mrjulsen.crn.client.gui.screen.RouteOverlaySettingsScreen;
import de.mrjulsen.crn.client.input.ModKeys;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.navigation.ClientRoute;
import de.mrjulsen.crn.data.navigation.TransferConnection;
import de.mrjulsen.crn.registry.ModItems;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.gui.DLOverlayScreen;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class RouteDetailsOverlay
extends DLOverlayScreen {
    private static final class_2960 GUI = new class_2960("createrailwaysnavigator", "textures/gui/overview.png");
    private static final class_2561 title = TextUtils.translate((String)"gui.createrailwaysnavigator.route_overview.title");
    private static final int GUI_WIDTH = 226;
    private static final int GUI_HEIGHT = 118;
    private static final int SLIDING_TEXT_AREA_WIDTH = 220;
    private final class_1937 level;
    private class_2561 slidingText = TextUtils.empty();
    private float slidingTextOffset = 0.0f;
    private int slidingTextWidth = 0;
    private LerpedFloat xPos;
    private LerpedFloat yPos;
    private static final String keyTrainDetails = "gui.createrailwaysnavigator.route_overview.train_details";
    private static final String keyTransfer = "gui.createrailwaysnavigator.route_overview.transfer";
    private static final String keyTransferWithPlatform = "gui.createrailwaysnavigator.route_overview.transfer_with_platform";
    private static final String keyAfterJourney = "gui.createrailwaysnavigator.route_overview.after_journey";
    private static final String keyOptionsText = "gui.createrailwaysnavigator.route_overview.options";
    private static final String keyKeybindOptions = "key.createrailwaysnavigator.route_overlay_options";
    private static final String keyJourneyBegins = "gui.createrailwaysnavigator.route_overview.journey_begins";
    private static final String keyJourneyBeginsWithPlatform = "gui.createrailwaysnavigator.route_overview.journey_begins_with_platform";
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyConnectionMissedInfo = "gui.createrailwaysnavigator.route_overview.connection_missed_info";
    private static final String keyTrainCancelledInfo = "gui.createrailwaysnavigator.route_overview.train_cancelled_info";
    private final class_327 font;
    private final ClientRoute route;
    private boolean journeyCompleted;
    private AbstractRouteDetailsPage currentPage;

    public RouteDetailsOverlay(class_1937 level, ClientRoute route, int width, int height) {
        this.font = class_310.method_1551().field_1772;
        this.journeyCompleted = false;
        this.level = level;
        this.route = route;
        route.addListener();
        this.currentPage = new WelcomePage(this.route);
        String terminus = route.getStart().getDisplayTitle();
        StationTag.StationInfo info = route.getStart().getRealTimeStationTag().info();
        this.setSlidingText((class_2561)(info.platform().isEmpty() ? CustomLanguage.translate(keyJourneyBegins, route.getStart().getTrainDisplayName(), terminus, ModUtils.formatTime(route.getStart().getScheduledDepartureTime(), false)) : CustomLanguage.translate(keyJourneyBeginsWithPlatform, route.getStart().getTrainDisplayName(), terminus, ModUtils.formatTime(route.getStart().getScheduledDepartureTime(), false), info.platform())));
        this.xPos = LerpedFloat.linear().startWithValue((double)(width / 2) - (Double)ModClientConfig.OVERLAY_SCALE.get() * 113.0);
        this.yPos = LerpedFloat.linear().startWithValue((double)(height / 2) - (Double)ModClientConfig.OVERLAY_SCALE.get() * 59.0);
        if (route.isClosed()) {
            return;
        }
        route.listen("departure_from_any_stop", (Object)this, x -> {
            this.currentPage = new RouteOverviewPage(this.route);
            String terminus = x.part().getNextStop().getTerminusText();
            this.setSlidingText((class_2561)CustomLanguage.translate(keyTrainDetails, x.part().getNextStop().getTrainDisplayName(), terminus == null || terminus.isEmpty() ? x.part().getNextStop().getScheduleTitle() : terminus));
        });
        route.listen("first_stop_station_changed", (Object)this, x -> this.setSlidingText((class_2561)(x.trainStop().getRealTimeStationTag().info().platform().isEmpty() ? CustomLanguage.translate(keyJourneyBegins) : CustomLanguage.translate(keyJourneyBeginsWithPlatform, x.trainStop().getRealTimeStationTag().info().platform()))));
        route.listen("arrival_at_any_stop", (Object)this, x -> this.setSlidingText((class_2561)TextUtils.text((String)x.trainStop().getClientTag().tagName())));
        route.listen("any_stop_announced", (Object)this, x -> {
            NextConnectionsPage page = new NextConnectionsPage(this.route, null);
            if (page.hasConnections()) {
                this.currentPage = page;
            }
        });
        route.listen("announce_stopover", (Object)this, x -> this.setSlidingText((class_2561)CustomLanguage.translate(keyNextStop, x.trainStop().getClientTag().tagName())));
        route.listen("announce_last_stop", (Object)this, x -> this.setSlidingText((class_2561)CustomLanguage.translate(keyNextStop, x.trainStop().getClientTag().tagName())));
        route.listen("announce_transfer_arrival_station", (Object)this, x -> {
            if (x.connection().isConnectionMissed()) {
                this.connectionMissed();
                return;
            }
            this.setSlidingText((class_2561)CustomLanguage.translate(keyNextStop, x.trainStop().getClientTag().tagName()).method_27693("   ***   ").method_10852(this.getTransferSlidingText(x.connection())));
            this.currentPage = new TransferPage(this.route, x.connection());
        });
        route.listen("part_changed", (Object)this, x -> {
            if (x.connection().isConnectionMissed()) {
                this.connectionMissed();
            }
        });
        route.listen("departure_from_transfer_arrival_station", (Object)this, x -> {
            this.setSlidingText((class_2561)TextUtils.text((String)x.connection().getArrivalStation().getClientTag().tagName()).method_27693("   ***   ").method_10852(this.getTransferSlidingText(x.connection())));
            this.currentPage = new TransferPage(this.route, x.connection());
        });
        route.listen("arrival_at_last_stop", (Object)this, x -> {
            this.setSlidingText((class_2561)CustomLanguage.translate(keyAfterJourney, x.trainStop().getClientTag().tagName()));
            this.currentPage = new JourneyCompletedPage(this.route, () -> {
                this.currentPage = new NextConnectionsPage(route, () -> {});
            });
            route.close();
        });
        route.listen("departure_from_last_stop", (Object)this, x -> {
            if (this.journeyCompleted) {
                return;
            }
            this.setSlidingText((class_2561)CustomLanguage.translate(keyAfterJourney, x.trainStop().getClientTag().tagName()));
            this.currentPage = new JourneyCompletedPage(this.route, () -> {
                this.currentPage = new NextConnectionsPage(route, () -> {});
            });
            route.close();
        });
        route.listen("any_transfer_missed", (Object)this, x -> this.connectionMissed());
        route.listen("train_cancelled", (Object)this, x -> this.trainCancelled(x.part().getLastStop().getTrainDisplayName()));
    }

    private class_2561 getTransferSlidingText(TransferConnection connection) {
        StationTag.StationInfo info = connection.getDepartureStation().getRealTimeStationTag().info();
        String terminus = connection.getDepartureStation().getDisplayTitle();
        return info == null || info.platform().isBlank() ? CustomLanguage.translate(keyTransfer, connection.getDepartureStation().getTrainDisplayName(), terminus) : CustomLanguage.translate(keyTransferWithPlatform, connection.getDepartureStation().getTrainDisplayName(), terminus, info.platform());
    }

    private void connectionMissed() {
        this.setSlidingText((class_2561)CustomLanguage.translate(keyConnectionMissedInfo));
        this.currentPage = new ConnectionMissedPage(this.route);
        this.route.close();
    }

    private void trainCancelled(String trainName) {
        this.setSlidingText((class_2561)CustomLanguage.translate(keyTrainCancelledInfo, trainName));
        this.currentPage = new TrainCancelledInfo(this.route, trainName);
        this.route.close();
    }

    private float getUIScale() {
        return (float)((Double)ModClientConfig.OVERLAY_SCALE.get()).doubleValue();
    }

    public void onClose() {
        this.route.close();
        this.journeyCompleted = true;
    }

    public void method_1865() {
        if (class_437.method_25441() && ModKeys.KEY_OVERLAY_SETTINGS.method_1434() && class_310.method_1551().field_1724.method_31548().method_18862(Set.of((class_1792)ModItems.NAVIGATOR.get()))) {
            DLScreen.setScreen((DLScreen)new RouteOverlaySettingsScreen(this));
        }
        this.xPos.tickChaser();
        this.yPos.tickChaser();
        DLUtils.doIfNotNull((Object)((Object)this.currentPage), x -> x.method_1865());
    }

    protected void tickSlidingText(float delta) {
        if ((float)this.slidingTextWidth > 165.0f) {
            this.slidingTextOffset -= delta;
            if (this.slidingTextOffset < (float)(-(this.slidingTextWidth / 2))) {
                this.slidingTextOffset = 220 + this.slidingTextWidth / 2 + 20;
            }
        }
    }

    private void startStencil(Graphics graphics, int x, int y, int w, int h) {
        UIRenderHelper.swapAndBlitColor((class_276)class_310.method_1551().method_1522(), (class_276)UIRenderHelper.framebuffer);
        ModGuiUtils.startStencil(graphics, x, y, w, h);
    }

    private void endStencil() {
        ModGuiUtils.endStencil();
        UIRenderHelper.swapAndBlitColor((class_276)UIRenderHelper.framebuffer, (class_276)class_310.method_1551().method_1522());
    }

    private void setSlidingText(class_2561 component) {
        this.slidingText = component;
        this.slidingTextWidth = this.font.method_27525((class_5348)component);
        this.slidingTextOffset = (float)this.slidingTextWidth > 165.0f ? (float)(220 + this.slidingTextWidth / 2 + 20) : 82.0f;
    }

    public void render(Graphics graphics, float partialTicks, int width, int height) {
        width = class_310.method_1551().method_22683().method_4486();
        height = class_310.method_1551().method_22683().method_4502();
        partialTicks = class_310.method_1551().method_1488();
        OverlayPosition pos = (OverlayPosition)((Object)ModClientConfig.ROUTE_OVERLAY_POSITION.get());
        int x = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.BOTTOM_LEFT ? 8 : (int)((float)width - 226.0f * this.getUIScale() - 10.0f);
        int y = pos == OverlayPosition.TOP_LEFT || pos == OverlayPosition.TOP_RIGHT ? 8 : (int)((float)height - 118.0f * this.getUIScale() - 10.0f);
        this.xPos.chase((double)x, (double)0.2f, LerpedFloat.Chaser.EXP);
        this.yPos.chase((double)y, (double)0.2f, LerpedFloat.Chaser.EXP);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22904((double)((int)this.xPos.getValue(partialTicks)), (double)((int)this.yPos.getValue(partialTicks)), 0.0);
        this.renderInternal(graphics, 0, 0, width, height, partialTicks, (int)this.xPos.getValue(partialTicks), (int)this.yPos.getValue(partialTicks));
        graphics.poseStack().method_22909();
        this.tickSlidingText(2.0f * class_310.method_1551().method_1534());
    }

    public void renderSlidingText(Graphics graphics, int x, int y, int transX, int transY) {
        this.startStencil(graphics, x + 3, y + 14, 220, 21);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(1.3333334f, 1.3333334f, 1.3333334f);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)((int)((float)(x + 3) + this.slidingTextOffset)), (int)(y + 14), (class_5348)this.slidingText, (int)0xFF9900, (EAlignment)EAlignment.CENTER, (boolean)false);
        graphics.poseStack().method_22909();
        this.endStencil();
    }

    private void renderInternal(Graphics graphics, int x, int y, int width, int height, float partialTicks, int transX, int transY) {
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22905(this.getUIScale(), this.getUIScale(), this.getUIScale());
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI);
        GuiUtils.drawTexture((class_2960)GUI, (Graphics)graphics, (int)x, (int)y, (int)226, (int)118, (int)0, (int)(this.currentPage != null && this.currentPage.isImportant() ? 138 : 0), (int)256, (int)256);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(x + 6), (int)(y + 4), (class_5348)title, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        Objects.requireNonNull(this.font);
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(x + 6), (int)(y + 118 - 2 - 9), (class_5348)TextUtils.translate((String)keyOptionsText, (Object[])new Object[]{TextUtils.translate((String)class_3675.method_15985((int)(class_310.field_1703 ? 343 : 341), (int)0).method_1441()).method_27693(" + ").method_10852((class_2561)TextUtils.keybind((String)keyKeybindOptions)).method_27692(class_124.field_1067)}), (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        String timeString = TimeUtils.parseTime((long)((int)((this.level.method_8532() + DragonLib.daytimeShift()) % DragonLib.ticksPerDay())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()));
        GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)(x + 226 - 4 - this.font.method_1727(timeString)), (int)(y + 4), (String)timeString, (int)0x4F4F4F, (EAlignment)EAlignment.LEFT, (boolean)false);
        this.renderSlidingText(graphics, x, y + 2, transX, transY);
        this.startStencil(graphics, x + 3, y + 40, 220, 62);
        graphics.poseStack().method_22903();
        graphics.poseStack().method_22904(3.0, 40.0, 0.0);
        DLUtils.doIfNotNull((Object)((Object)this.currentPage), a -> {
            a.renderBackLayer(graphics, 0, 0, partialTicks);
            a.renderMainLayer(graphics, 0, 0, partialTicks);
        });
        graphics.poseStack().method_22909();
        this.endStencil();
        DLUtils.doIfNotNull((Object)((Object)this.currentPage), a -> a.renderFrontLayer(graphics, 0, 0, partialTicks));
        if (CreateRailwaysNavigator.isDebug()) {
            GuiUtils.drawString((Graphics)graphics, (class_327)this.font, (int)5, (int)128, (String)("State: " + String.valueOf((Object)this.route.getState()) + ", " + this.route.getCurrentPartIndex() + ", " + this.route.getCurrentPart().getNextStop().getClientTag().tagName()), (int)-65536, (EAlignment)EAlignment.LEFT, (boolean)false);
        }
        graphics.poseStack().method_22909();
    }

    public ClientRoute getRoute() {
        return this.route;
    }
}

