/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayScrollingTextSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;

public class BERPlatformSimple
implements AbstractAdvancedDisplayRenderer<PlatformDisplayScrollingTextSettings> {
    private static final String keyTrainDeparture = "gui.createrailwaysnavigator.route_overview.notification.journey_begins";
    private static final String keyTrainDepartureWithPlatform = "gui.createrailwaysnavigator.route_overview.notification.journey_begins_with_platform";
    private static final String keyTime = "gui.createrailwaysnavigator.time";
    private final BERLabel label = new BERLabel().setPos(3.0f, 5.5f).setYScale(0.75f).setScale(0.75f, 0.75f).setCentered(true).setScrollingSpeed(2.0f);
    private List<class_2561> texts;
    boolean updateLabel = false;

    @Override
    public void renderTick(float deltaTime) {
        this.label.renderTick();
    }

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        ArrayList<class_2561> textContent = new ArrayList<class_2561>(this.texts);
        textContent.add(0, (class_2561)CustomLanguage.translate(keyTime, TimeUtils.parseTime((long)((int)(blockEntity.method_10997().method_8532() % DragonLib.ticksPerDay() + DragonLib.daytimeShift())), (TimeUtils.TimeFormat)((TimeUtils.TimeFormat)ModClientConfig.TIME_FORMAT.get()))));
        class_5250 txt = TextUtils.concat(textContent);
        this.label.setText((class_2561)txt);
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        this.label.render(graphics, light);
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        List<StationDisplayData> preds = blockEntity.getStops().stream().filter(x -> x.getStationData().getRealTimeArrivalTime() < DragonLib.getCurrentWorldTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue() && (!x.getTrainData().isCancelled() || DragonLib.getCurrentWorldTime() < x.getStationData().getScheduledDepartureTime() + (long)((Integer)ModClientConfig.DISPLAY_LEAD_TIME.get()).intValue())).toList();
        this.label.setColor(0xFF000000 | ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL);
        this.texts = new ArrayList<class_2561>();
        this.texts.addAll(preds.stream().filter(x -> !x.isNextSectionExcluded()).map(x -> {
            String timeString = ModUtils.formatTime(x.getStationData().getScheduledDepartureTime(), ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA);
            class_5250 text = TextUtils.empty();
            if (x.getStationData().getStationInfo().platform() == null || x.getStationData().getStationInfo().platform().isBlank()) {
                text.method_10852((class_2561)CustomLanguage.translate(keyTrainDeparture, x.getTrainData().getName(), x.getStationData().getDestination(), timeString));
            } else {
                text.method_10852((class_2561)CustomLanguage.translate(keyTrainDepartureWithPlatform, x.getTrainData().getName(), x.getStationData().getDestination(), timeString, x.getStationData().getStationInfo().platform()));
            }
            if (x.getTrainData().isCancelled()) {
                text.method_27693(", ").method_27693(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.cancelled2").getString());
            } else if (x.getStationData().isDepartureDelayed()) {
                String delay = ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA ? ModUtils.timeRemainingString(x.getStationData().getDepartureTimeDeviation()) : String.valueOf(TimeUtils.formatToMinutes((long)x.getStationData().getDepartureTimeDeviation()));
                String timeUnitSuffix = ((PlatformDisplayScrollingTextSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ABS ? " " + CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delay_abs_suffix").getString() : "";
                text.method_27693(", ").method_27693(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.delayed2", delay, timeUnitSuffix).getString());
                if (x.getTrainData().hasStatusInfo()) {
                    text.method_27693(" ").method_27693(CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.reason").getString()).method_10852(x.getTrainData().getStatus().get(0).text());
                }
            }
            return text;
        }).toList());
    }
}

