/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PassengerInformationDetailedSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.portable.NextConnectionsDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.registry.data.NextConnectionsRequestData;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class BERPassengerInfoInformative
implements AbstractAdvancedDisplayRenderer<PassengerInformationDetailedSettings> {
    private static final class_2960 CARRIAGE_ICON = new class_2960("create:textures/gui/assemble.png");
    private static final class_2960 ICONS = new class_2960("createrailwaysnavigator", "textures/gui/icons.png");
    private static final String keyDate = "gui.createrailwaysnavigator.route_overview.date";
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyNextConnections = "gui.createrailwaysnavigator.route_overview.next_connections";
    private static final int MAX_LINES = 4;
    private NextConnectionsDisplayData nextConnections = null;
    private boolean nextStopAnnounced = false;
    private TrainExitSide exitSide = TrainExitSide.UNKNOWN;
    private final BERLabel timeLabel = new BERLabel().setScale(0.25f, 0.25f).setYScale(0.25f);
    private final BERLabel carriageLabel = new BERLabel().setScale(0.25f, 0.25f).setYScale(0.25f);
    private final BERLabel trainLineLabel = new BERLabel().setPos(3.0f, 2.5f).setScale(0.25f, 0.15f).setYScale(0.25f);
    private final BERLabel speedLabel = new BERLabel().setPos(3.0f, 6.0f).setScale(0.25f, 0.2f).setYScale(0.3f).setCentered(true);
    private final BERLabel dateLabel = new BERLabel().setPos(3.0f, 9.0f).setScale(0.2f, 0.15f).setYScale(0.2f).setCentered(true);
    private final BERLabel carriageInfoLabel = new BERLabel().setPos(4.5f, 11.0f).setScale(0.2f, 0.15f).setYScale(0.2f).setCentered(true);
    private final BERLabel nextConnectionsTitleLabel = new BERLabel((class_2561)CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.next_connections").method_27692(class_124.field_1067)).setPos(3.0f, 5.5f).setScale(0.15f, 0.15f).setYScale(0.15f);
    private final BERLabel pageIndicatorLabel = new BERLabel().setPos(3.0f, 12.5f).setScale(0.15f, 0.15f).setYScale(0.15f).setCentered(true);
    private BERLabel[][] scheduleLines;
    private BERLabel[][] nextConnectionsLines = new BERLabel[3][];

    private boolean shouldRenderNextConnections() {
        return this.nextConnections != null && !this.nextConnections.getConnections().isEmpty() && this.nextStopAnnounced;
    }

    private String generatePageIndexString(int current, int max) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < current; ++i) {
            sb.append(" \u25a1");
        }
        sb.append(" \u25a0");
        for (i = current + 1; i < max; ++i) {
            sb.append(" \u25a1");
        }
        return sb.toString();
    }

    @Override
    public void renderTick(float deltaTime) {
        this.timeLabel.renderTick();
        this.dateLabel.renderTick();
        this.trainLineLabel.renderTick();
        this.speedLabel.renderTick();
        this.carriageInfoLabel.renderTick();
        this.nextConnectionsTitleLabel.renderTick();
        this.pageIndicatorLabel.renderTick();
        DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], z -> z.renderTick());
                    }
                });
            }
        });
        DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], z -> z.renderTick());
                    }
                });
            }
        });
    }

    @Override
    public void tick(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        this.timeLabel.setText((class_2561)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)).method_27692(class_124.field_1067) : TextUtils.empty())).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - this.timeLabel.getTextWidth() - (float)(this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0), 2.5f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
    }

    public void renderHeader(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        float uv255 = 0.00390625f;
        TrainExitSide side = this.exitSide;
        if (backSide) {
            side = side.getOpposite();
        }
        graphics.poseStack().method_22903();
        if (side == TrainExitSide.LEFT) {
            graphics.poseStack().method_22904(4.0, 0.0, 0.0);
        }
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() > 1 && !this.nextStopAnnounced) {
            this.timeLabel.render(graphics, light);
            BERUtils.renderTexture((class_2960)ICONS, graphics, (boolean)false, (float)(this.timeLabel.getX() - 2.5f), (float)2.5f, (float)0.0f, (float)2.0f, (float)2.0f, (float)0.88671875f, (float)0.07421875f, (float)0.92578125f, (float)0.11328125f, (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
        }
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isEmpty()) {
            graphics.poseStack().method_22909();
            return;
        }
        this.trainLineLabel.render(graphics, light);
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() > 2 && !this.nextStopAnnounced) {
            this.carriageLabel.render(graphics, light);
            BERUtils.renderTexture((class_2960)CARRIAGE_ICON, graphics, (boolean)false, (float)(this.carriageLabel.getX() - 3.5f), (float)2.5f, (float)0.0f, (float)3.0f, (float)2.0f, (float)0.0859375f, (float)0.90234375f, (float)0.13671875f, (float)0.921875f, (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
        }
        graphics.poseStack().method_22909();
        if (this.nextStopAnnounced || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isWaitingAtStation()) {
            switch (side) {
                case RIGHT: {
                    BERUtils.renderTexture((class_2960)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 3 - 3), (float)2.05f, (float)0.0f, (float)3.0f, (float)3.0f, (float)(0.00390625f * (float)ModGuiIcons.ARROW_RIGHT.getU()), (float)(0.00390625f * (float)ModGuiIcons.ARROW_RIGHT.getV()), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_RIGHT.getU() + 16)), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_RIGHT.getV() + 16)), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                    break;
                }
                case LEFT: {
                    BERUtils.renderTexture((class_2960)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)3.0f, (float)2.05f, (float)0.0f, (float)3.0f, (float)3.0f, (float)(0.00390625f * (float)ModGuiIcons.ARROW_LEFT.getU()), (float)(0.00390625f * (float)ModGuiIcons.ARROW_LEFT.getV()), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_LEFT.getU() + 16)), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_LEFT.getV() + 16)), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                    break;
                }
            }
        }
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        float uv255 = 0.00390625f;
        this.renderHeader(graphics, partialTick, parent, light, backSide);
        BERUtils.fillColor(graphics, (float)2.5f, (float)5.0f, (float)0.01f, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 5), (float)0.25f, (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)light);
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isEmpty()) {
            return;
        }
        if (this.shouldRenderNextConnections()) {
            DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
                for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                    DLUtils.doIfNotNull((Object)x[i], a -> {
                        for (int j = 0; j < ((BERLabel[])a).length; ++j) {
                            DLUtils.doIfNotNull((Object)a[j], b -> b.render((RenderGraphics)graphics, light));
                        }
                    });
                }
            });
            this.nextConnectionsTitleLabel.render(graphics, light);
            this.pageIndicatorLabel.render(graphics, light);
        } else if (((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showStats() && DragonLib.getCurrentWorldTime() % 500L < 200L && !((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isWaitingAtStation()) {
            this.speedLabel.render(graphics, light);
            this.dateLabel.render(graphics, light);
            this.carriageInfoLabel.render(graphics, light);
            BERUtils.renderTexture((class_2960)CARRIAGE_ICON, graphics, (boolean)false, (float)((float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16) / 2.0f - this.carriageInfoLabel.getTextWidth() / 2.0f - 1.5f), (float)this.carriageInfoLabel.getY(), (float)0.0f, (float)2.25f, (float)1.5f, (float)0.0859375f, (float)0.90234375f, (float)0.13671875f, (float)0.921875f, (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
        } else {
            DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
                for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                    int idx = i;
                    DLUtils.doIfNotNull((Object)x[i], a -> {
                        for (int j = 0; j < ((BERLabel[])a).length; ++j) {
                            DLUtils.doIfNotNull((Object)a[j], b -> b.render((RenderGraphics)graphics, light));
                        }
                        float uv32 = 0.015625f;
                        if (idx == 0 && this.scheduleLines.length > 1) {
                            BERUtils.renderTexture((class_2960)CRNGui.GUI, (RenderGraphics)graphics, (boolean)false, (float)((a[LineComponent.REAL_TIME.i()] == null ? a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getMaxWidth() : a[LineComponent.REAL_TIME.i()].getX() + a[LineComponent.REAL_TIME.i()].getMaxWidth()) - 1.0f), (float)(a[LineComponent.SCHEDULED_TIME.i()].getY() - 1.0f), (float)0.0f, (float)1.0f, (float)2.0f, (float)0.328125f, (float)0.46875f, (float)0.4375f, (float)0.6875f, (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
                        } else if (idx >= 3) {
                            BERUtils.renderTexture((class_2960)CRNGui.GUI, (RenderGraphics)graphics, (boolean)false, (float)((a[LineComponent.REAL_TIME.i()] == null ? a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getMaxWidth() : a[LineComponent.REAL_TIME.i()].getX() + a[LineComponent.REAL_TIME.i()].getMaxWidth()) - 1.0f), (float)(a[LineComponent.SCHEDULED_TIME.i()].getY() - 1.0f), (float)0.0f, (float)1.0f, (float)2.0f, (float)0.546875f, (float)0.46875f, (float)0.65625f, (float)0.6875f, (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
                        } else {
                            BERUtils.renderTexture((class_2960)CRNGui.GUI, (RenderGraphics)graphics, (boolean)false, (float)((a[LineComponent.REAL_TIME.i()] == null ? a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getMaxWidth() : a[LineComponent.REAL_TIME.i()].getX() + a[LineComponent.REAL_TIME.i()].getMaxWidth()) - 1.0f), (float)(a[LineComponent.SCHEDULED_TIME.i()].getY() - 1.0f), (float)0.0f, (float)1.0f, (float)2.0f, (float)0.4375f, (float)0.46875f, (float)0.546875f, (float)0.6875f, (class_2350)((class_2350)((AdvancedDisplayBlockEntity)graphics.blockEntity()).method_11010().method_11654((class_2769)class_2383.field_11177)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void update(class_1937 level, class_2338 pos, class_2680 state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().isEmpty()) {
            return;
        }
        TrainDisplayData data = blockEntity.getTrainData();
        boolean wasNextStopAnnounced = this.nextStopAnnounced;
        boolean bl = this.nextStopAnnounced = !data.isWaitingAtStation() && data.getNextStop().isPresent() && data.getNextStop().get().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime() < (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue();
        TrainExitSide trainExitSide = !this.nextStopAnnounced && !data.isWaitingAtStation() || !((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).showExit() ? TrainExitSide.UNKNOWN : (this.exitSide = data.isWaitingAtStation() ? this.exitSide : (TrainExitSide)((Object)blockEntity.relativeExitDirection.get()));
        if (((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).showConnections() && blockEntity.getXSizeScaled() > 1 && this.nextStopAnnounced && !wasNextStopAnnounced && data.getNextStop().isPresent()) {
            DataAccessor.getFromServer((Object)new NextConnectionsRequestData(data.getNextStop().get().getName(), data.getTrainData().getId()), ModAccessorTypes.GET_NEXT_CONNECTIONS_DISPLAY_DATA, res -> {
                this.nextConnections = res;
                this.updateLayout(blockEntity, data);
                this.updateContent(blockEntity, data);
            });
        }
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || !this.nextStopAnnounced) {
            this.updateLayout(blockEntity, data);
            this.nextConnections = null;
        }
        this.updateContent(blockEntity, data);
    }

    private int getCarriageIndex(AdvancedDisplayBlockEntity blockEntity) {
        PassengerInformationDetailedSettings settings = (PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity);
        return (settings.shouldOverwriteCarriageIndex() ? 0 : blockEntity.getCarriageData().index() + 1) + settings.getCarriageIndex();
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, TrainDisplayData data) {
        PassengerInformationDetailedSettings settings = (PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity);
        int carriageIndex = this.getCarriageIndex(blockEntity);
        this.timeLabel.setText((class_2561)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA)).method_27692(class_124.field_1067) : TextUtils.empty())).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - this.timeLabel.getTextWidth() - (float)(this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0), 2.5f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.carriageLabel.setText((class_2561)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)String.format("%02d", carriageIndex)).method_27692(class_124.field_1067) : TextUtils.empty())).setPos(this.timeLabel.getX() - 4.0f - this.carriageLabel.getTextWidth(), 2.5f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.trainLineLabel.setText((class_2561)(this.nextStopAnnounced ? CustomLanguage.translate(keyNextStop, data.getNextStop().get().getName()) : TextUtils.text((String)((String)(settings.getTrainTextComponents().showTrainName() ? data.getTrainData().getName() + " " : "") + (settings.getTrainTextComponents().showDestination() ? data.getNextStop().get().getDestination() : ""))).method_27692(class_124.field_1067))).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6) - (blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? this.timeLabel.getTextWidth() - 4.0f : 0.0f) - (blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? this.carriageLabel.getTextWidth() - 5.0f : 0.0f) - (float)(this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0), BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.speedLabel.setText((class_2561)ModUtils.calcSpeedString(data.getSpeed(), (ESpeedUnit)((Object)ModClientConfig.SPEED_UNIT.get())).method_27692(class_124.field_1067)).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.dateLabel.setText((class_2561)CustomLanguage.translate(keyDate, blockEntity.method_10997().method_8532() / 24000L, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.carriageInfoLabel.setText((class_2561)TextUtils.text((String)String.format("%02d", carriageIndex))).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        if (this.shouldRenderNextConnections() && !this.nextConnections.getConnections().isEmpty()) {
            int pages = (int)Math.ceil((float)this.nextConnections.getConnections().size() / 3.0f);
            int page = (int)(DragonLib.getCurrentWorldTime() % (long)(100 * pages) / 100L);
            this.pageIndicatorLabel.setText((class_2561)TextUtils.text((String)this.generatePageIndexString(page, pages))).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
            this.nextConnectionsTitleLabel.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
            DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
                for (int i = 0; i < 3; ++i) {
                    int k = i;
                    int connectionIdx = i + page * 3;
                    DLUtils.doIfNotNull((Object)this.nextConnectionsLines[i], a -> {
                        if (connectionIdx >= this.nextConnections.getConnections().size()) {
                            a[LineComponent.SCHEDULED_TIME.i()].setText((class_2561)TextUtils.empty());
                            if (a[LineComponent.REAL_TIME.i()] != null) {
                                a[LineComponent.REAL_TIME.i()].setText((class_2561)TextUtils.empty());
                            }
                            a[LineComponent.TRAIN_NAME.i()].setText((class_2561)TextUtils.empty());
                            a[LineComponent.DESTINATION.i()].setText((class_2561)TextUtils.empty());
                            a[LineComponent.PLATFORM.i()].setText((class_2561)TextUtils.empty());
                            return;
                        }
                        TrainStopDisplayData stop = this.nextConnections.getConnections().get(connectionIdx);
                        a[LineComponent.PLATFORM.i()].setText((class_2561)TextUtils.text((String)stop.getStationInfo().platform())).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - a[LineComponent.PLATFORM.i()].getTextWidth(), 7.5f + (float)k * 1.7f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                        if (a[LineComponent.REAL_TIME.i()] != null) {
                            a[LineComponent.SCHEDULED_TIME.i()].setPos(3.0f, 7.5f + (float)k * 1.7f).setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                            a[LineComponent.REAL_TIME.i()].setPos(a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 1.0f, 7.5f + (float)k * 1.7f).setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isDepartureDelayed() ? -48574 : -15013281);
                        } else {
                            a[LineComponent.SCHEDULED_TIME.i()].setPos(3.0f, 7.5f + (float)k * 1.7f).setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isDepartureDelayed() ? -48574 : -15013281);
                        }
                        float pX = a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 1.0f + (a[LineComponent.REAL_TIME.i()] == null ? 0.0f : a[LineComponent.REAL_TIME.i()].getTextWidth() + 1.0f);
                        a[LineComponent.TRAIN_NAME.i()].setPos(pX, 7.5f + (float)k * 1.7f).setText((class_2561)TextUtils.text((String)stop.getTrainName())).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                        a[LineComponent.DESTINATION.i()].setPos(pX + 7.0f, 7.5f + (float)k * 1.7f).setText((class_2561)TextUtils.text((String)stop.getDestination())).setMaxWidth(a[LineComponent.PLATFORM.i()].getX() - 1.0f - pX - 7.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                    });
                }
            });
        } else {
            DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
                int totalStationsCount = data.getStopsFromCurrentStation().size();
                int linesCount = Math.min(this.scheduleLines.length, totalStationsCount);
                for (int i = 0; i < linesCount; ++i) {
                    int j = i;
                    int k = i >= linesCount - 1 ? totalStationsCount - 1 : i;
                    DLUtils.doIfNotNull((Object)this.scheduleLines[i], a -> {
                        TrainStopDisplayData stop = data.getStopsFromCurrentStation().get(k);
                        if (a[LineComponent.REAL_TIME.i()] != null) {
                            a[LineComponent.SCHEDULED_TIME.i()].setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                            a[LineComponent.REAL_TIME.i()].setPos(a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 1.0f, (float)(6 + j * 2)).setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isArrivalDelayed() ? -48574 : -15013281);
                        } else {
                            a[LineComponent.SCHEDULED_TIME.i()].setText((class_2561)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isArrivalDelayed() ? -48574 : -15013281);
                        }
                        float pX = a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 3.0f + (a[LineComponent.REAL_TIME.i()] == null ? 0.0f : a[LineComponent.REAL_TIME.i()].getTextWidth() + 1.0f);
                        a[LineComponent.DESTINATION.i()].setPos(pX, (float)(6 + j * 2)).setText((class_2561)TextUtils.text((String)stop.getName()).method_27692(j >= linesCount - 1 ? class_124.field_1067 : class_124.field_1070)).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 3) - pX, BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                    });
                }
            });
        }
    }

    private BERLabel[] createStationLine(AdvancedDisplayBlockEntity blockEntity, int index) {
        BERLabel timeLabel = new BERLabel().setPos(3.0f, (float)(6 + index * 2)).setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        BERLabel realTimeLabel = null;
        if (blockEntity.getXSizeScaled() > 1) {
            realTimeLabel = new BERLabel().setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        }
        BERLabel destinationLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        return new BERLabel[]{timeLabel, realTimeLabel, null, destinationLabel};
    }

    private BERLabel[] createNextConnectionsLine(AdvancedDisplayBlockEntity blockEntity, int index) {
        BERLabel timeLabel = new BERLabel().setPos(3.0f, (float)(7 + index * 2)).setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        BERLabel realTimeLabel = null;
        if (blockEntity.getXSizeScaled() > 2) {
            realTimeLabel = new BERLabel().setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        }
        BERLabel trainNameLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        BERLabel destinationLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        BERLabel platformLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        return new BERLabel[]{timeLabel, realTimeLabel, trainNameLabel, destinationLabel, platformLabel};
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, TrainDisplayData data) {
        if (this.shouldRenderNextConnections()) {
            for (int i = 0; i < 3; ++i) {
                this.nextConnectionsLines[i] = this.createNextConnectionsLine(blockEntity, i);
            }
            return;
        }
        int totalStationsCount = data.getStopsFromCurrentStation().size();
        int linesCount = Math.min(4, totalStationsCount);
        this.scheduleLines = new BERLabel[linesCount][];
        for (int i = 0; i < linesCount; ++i) {
            this.scheduleLines[i] = this.createStationLine(blockEntity, i);
        }
    }

    private static enum LineComponent {
        SCHEDULED_TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4);

        int i;

        private LineComponent(int i) {
            this.i = i;
        }

        public int i() {
            return this.i;
        }
    }
}

