/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.ber.variants.BERError;
import de.mrjulsen.crn.registry.ModDisplayTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public final class AdvancedDisplaysRegistry {
    private static final Map<EDisplayType, Map<String, DisplayRegistrationData<?, ?>>> newDisplayTypes = new HashMap();

    public static <S extends IDisplaySettings, R extends AbstractAdvancedDisplayRenderer<S>> DisplayTypeResourceKey register(EDisplayType category, String name, Supplier<S> settings, Supplier<R> renderer, DisplayProperties properties) {
        DisplayTypeResourceKey key = new DisplayTypeResourceKey(category, name);
        Map reg = newDisplayTypes.computeIfAbsent(category, x -> new HashMap());
        if (reg.containsKey(name)) {
            throw new IllegalArgumentException("A display type with the id '" + String.valueOf(key) + "' is already registered!");
        }
        reg.put(name, new DisplayRegistrationData<S, R>(settings, renderer, properties));
        return key;
    }

    public static boolean isRegietered(DisplayTypeResourceKey key) {
        return key != null && newDisplayTypes.containsKey((Object)key.category()) && newDisplayTypes.get((Object)key.category()).containsKey(key.name());
    }

    @Environment(value=EnvType.CLIENT)
    public static AbstractAdvancedDisplayRenderer<?> createRenderer(DisplayTypeResourceKey key) {
        if (!AdvancedDisplaysRegistry.isRegietered(key)) {
            return new BERError();
        }
        return (AbstractAdvancedDisplayRenderer)newDisplayTypes.get((Object)key.category()).get(key.name()).renderer().get();
    }

    public static IDisplaySettings createSettings(DisplayTypeResourceKey key) {
        if (!AdvancedDisplaysRegistry.isRegietered(key)) {
            return new BasicDisplaySettings();
        }
        return (IDisplaySettings)newDisplayTypes.get((Object)key.category()).get(key.name()).customizationSettings().get();
    }

    public static DisplayProperties getProperties(DisplayTypeResourceKey key) {
        if (!AdvancedDisplaysRegistry.isRegietered(key)) {
            return new DisplayProperties(true, $ -> 0);
        }
        return newDisplayTypes.get((Object)key.category()).get(key.name()).properties();
    }

    public static Map<String, DisplayProperties> getAllOfType(EDisplayType type) {
        return newDisplayTypes.get((Object)type).entrySet().stream().collect(Collectors.toMap(a -> (String)a.getKey(), b -> ((DisplayRegistrationData)b.getValue()).properties()));
    }

    public static List<DisplayTypeResourceKey> getAllOfTypeAsKey(EDisplayType type) {
        return newDisplayTypes.get((Object)type).entrySet().stream().map(x -> new DisplayTypeResourceKey(type, (String)x.getKey())).toList();
    }

    public static List<String> getAllNamesOfType(EDisplayType type) {
        return newDisplayTypes.get((Object)type).entrySet().stream().map(x -> (String)x.getKey()).toList();
    }

    public record DisplayTypeResourceKey(EDisplayType category, String name) {
        private static final String NBT_ID = "DisplayId";
        @Deprecated
        private static final String LEGACY_NBT_ID = "Id";
        @Deprecated
        private static final String LEGACY_NBT_CATEGORY = "Category";

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final boolean equals(Object arg) {
            if (!(arg instanceof DisplayTypeResourceKey)) return false;
            DisplayTypeResourceKey o = (DisplayTypeResourceKey)arg;
            if (this.category() != o.category()) return false;
            if (!this.name().equals(o.name())) return false;
            return true;
        }

        @Override
        public final int hashCode() {
            return Objects.hash(new Object[]{this.category(), this.name()});
        }

        public void toNbt(class_2487 nbt) {
            nbt.method_10582(NBT_ID, this.getLocation().toString());
        }

        public class_2960 getLocation() {
            return new class_2960("createrailwaysnavigator", this.category().getInfoTypeName() + "/" + this.name());
        }

        @Deprecated
        public static DisplayTypeResourceKey legacy_fromNbt(class_2487 nbt) {
            return new DisplayTypeResourceKey(EDisplayType.getTypeById(nbt.method_10571(LEGACY_NBT_CATEGORY)), new class_2960(nbt.method_10558(LEGACY_NBT_ID)).method_12832());
        }

        public static DisplayTypeResourceKey fromNbt(class_2487 nbt) {
            String id = nbt.method_10558(NBT_ID);
            String[] data = new class_2960(id).method_12832().split("/");
            return new DisplayTypeResourceKey(data.length > 0 ? EDisplayType.getTypeByName(data[0]) : ModDisplayTypes.TRAIN_DESTINATION_SIMPLE.category(), data.length > 1 ? data[1] : ModDisplayTypes.TRAIN_DESTINATION_SIMPLE.name());
        }

        public String getTranslationKey() {
            return "display.createrailwaysnavigator." + this.category().getEnumValueName() + "." + this.name();
        }

        @Override
        public final String toString() {
            return "DisplayType[" + this.category().getEnumValueName() + "/" + this.name() + "]";
        }
    }

    protected record DisplayRegistrationData<S extends IDisplaySettings, R extends AbstractAdvancedDisplayRenderer<S>>(Supplier<S> customizationSettings, Supplier<R> renderer, DisplayProperties properties) {
    }

    public record DisplayProperties(boolean singleLined, Function<AdvancedDisplayBlockEntity, Integer> platformDisplayTrainsCount) {
    }
}

