/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties.components;

import com.simibubi.create.foundation.gui.widget.ScrollInput;
import de.mrjulsen.crn.block.display.properties.DepartureBoardDisplayTableSettings;
import de.mrjulsen.crn.block.display.properties.PlatformDisplayFocusSettings;
import de.mrjulsen.crn.block.display.properties.components.ICarriageIndexSetting;
import de.mrjulsen.crn.block.display.properties.components.IColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ICustomTextWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowArrivalSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowExitDirectionSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowNextConnections;
import de.mrjulsen.crn.block.display.properties.components.IShowTimeAndDateSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowTrainStatsSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainTextSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.ColorSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.DLCreateScrollInput;
import de.mrjulsen.crn.client.gui.widgets.DLCreateSelectionScrollInput;
import de.mrjulsen.crn.client.gui.widgets.IconSlotWidget;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLCheckBox;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.data.Single;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_339;
import net.minecraft.class_437;

public class GuiBuilderWrapper {
    static void buildColorGui(IColorSetting setting, GuiBuilderContext context) {
        context.builder().addLine("color", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16)));
            line.add(new ColorSlotWidget(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, setting.getFontColor() == 0 ? 0 : 0xFF000000 | setting.getFontColor() & 0xFFFFFF, ModUtils.getDyeColors(), false, false, List.of(IColorSetting.textFontColor, IColorSetting.textClickToEdit), () -> 0, b -> setting.setFontColor(b.getSelectedColor())));
            line.add(new ColorSlotWidget(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, setting.getBackColor() == 0 ? 0 : 0xFF000000 | setting.getBackColor() & 0xFFFFFF, ModUtils.getDyeColors(), false, true, List.of(IColorSetting.textBackColor, IColorSetting.textClickToEdit), () -> 0, b -> setting.setBackColor(b.getSelectedColor())));
        });
    }

    static void buildCarriageIndexGui(ICarriageIndexSetting setting, final GuiBuilderContext context) {
        context.builder().addLine("carriage_index", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.CARRIAGE_NUMBER.getAsSprite(16, 16)));
            int w = 22;
            line.add(new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 6, line.y() + 2, w, 18)).setRenderArrow(true).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.carriage_index")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.advanced_display_settings.carriage_index.description")).withRange(0, 100).withShiftStep(4).setState((int)setting.getCarriageIndex()).calling(i -> setting.setCarriageIndex(i.byteValue()));
            line.add(new DLCheckBox(line.getCurrentX() + 4, line.y() + line.height() / 2 - 8, line.getRemainingWidth(), ICarriageIndexSetting.textOverwriteCarriageIndex.getString(), setting.shouldOverwriteCarriageIndex(), c -> setting.setOverwriteCarriageIndex(c.isChecked())){

                public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
                    if (!this.isMouseSelected()) {
                        return;
                    }
                    GuiUtils.renderTooltip((class_437)context.container().getParentScreen(), (class_339)this, List.of(ICarriageIndexSetting.textOverwriteCarriageIndexDescription), (int)(context.container().getParentScreen().width() / 3), (Graphics)graphics, (int)mouseX, (int)mouseY);
                }
            });
        });
    }

    static void buildBasicTextWidthGui(ICustomTextWidthSetting setting, GuiBuilderContext context) {
        context.builder().addLine("text_width", line -> line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.WIDTH.getAsSprite(16, 16))));
    }

    static void buildPlatformWidthGui(IPlatformWidthSetting setting, GuiBuilderContext context, boolean allowAuto) {
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            line.add(new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18)).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width.description")).withRange(allowAuto ? -1 : 0, 65).withShiftStep(4).setState((int)setting.getPlatformWidth()).format(val -> {
                if (val >= 0) {
                    return TextUtils.text((String)(String.valueOf(val) + "px"));
                }
                return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto");
            }).calling(i -> setting.setPlatformWidth(i.byteValue()));
        });
    }

    static void buildShowArrivalGui(IShowArrivalSetting setting, final GuiBuilderContext context) {
        context.builder().addLine("show_arrival", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.TARGET.getAsSprite(16, 16)));
            line.add(new DLCheckBox(line.getCurrentX() + 4, line.y() + line.height() / 2 - 8, line.getRemainingWidth(), IShowArrivalSetting.textShowArrival.getString(), setting.showArrival(), cb -> setting.setShowArrival(cb.isChecked())){

                public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
                    if (!this.isMouseSelected()) {
                        return;
                    }
                    GuiUtils.renderTooltip((class_437)context.container().getParentScreen(), (class_339)this, List.of(IShowArrivalSetting.textShowArrivalDescription), (int)(context.container().getParentScreen().width() / 3), (Graphics)graphics, (int)mouseX, (int)mouseY);
                }
            });
        });
    }

    static void buildShowExitGui(IShowExitDirectionSetting settings, GuiBuilderContext context) {
        context.builder().addLine("show_exit", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.EXIT.getAsSprite(16, 16)));
            line.add(new DLCheckBox(line.getCurrentX() + 4, line.y() + line.height() / 2 - 8, line.getRemainingWidth(), IShowExitDirectionSetting.textShowExit.getString(), settings.showExit(), cb -> settings.setShowExit(cb.isChecked())));
        });
    }

    static void buildShowLineColorGui(IShowLineColorSetting setting, final GuiBuilderContext context) {
        context.builder().addLine("show_line_color", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.COLOR_PALETTE.getAsSprite(16, 16)));
            line.add(new DLCheckBox(line.getCurrentX() + 4, line.y() + line.height() / 2 - 8, line.getRemainingWidth(), IShowLineColorSetting.textShowLineColor.getString(), setting.showLineColor(), cb -> setting.setShowLineColor(cb.isChecked())){

                public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
                    super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
                    if (!this.isMouseSelected()) {
                        return;
                    }
                    GuiUtils.renderTooltip((class_437)context.container().getParentScreen(), (class_339)this, List.of(IShowLineColorSetting.textShowLineColorDescription), (int)(context.container().getParentScreen().width() / 3), (Graphics)graphics, (int)mouseX, (int)mouseY);
                }
            });
        });
    }

    static void buildShowConnectionGui(IShowNextConnections setting, GuiBuilderContext context) {
        context.builder().addLine("show_connections", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.CONNECTIONS.getAsSprite(16, 16)));
            line.add(new DLCheckBox(line.getCurrentX() + 4, line.y() + line.height() / 2 - 8, line.getRemainingWidth(), IShowNextConnections.textShowConnections.getString(), setting.showConnections(), cb -> setting.setShowConnection(cb.isChecked())));
        });
    }

    static void buildShowTimeAndDateGui(IShowTimeAndDateSetting setting, GuiBuilderContext context) {
        context.builder().addLine("show_time", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.TIME.getAsSprite(16, 16)));
            line.add(new DLCheckBox(line.getCurrentX() + 4, line.y() + line.height() / 2 - 8, line.getRemainingWidth(), IShowTimeAndDateSetting.textShowStats.getString(), setting.showTimeAndDate(), cb -> setting.setShowTimeAndDate(cb.isChecked())));
        });
    }

    static void buildShowStatsGui(IShowTrainStatsSetting setting, GuiBuilderContext context) {
        context.builder().addLine("show_stats", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.TRAIN_INFO.getAsSprite(16, 16)));
            line.add(new DLCheckBox(line.getCurrentX() + 4, line.y() + line.height() / 2 - 8, line.getRemainingWidth(), IShowTrainStatsSetting.textShowStats.getString(), setting.showStats(), cb -> setting.setShowStats(cb.isChecked())));
        });
    }

    static void buildTimeDisplayGui(ITimeDisplaySetting setting, GuiBuilderContext context) {
        context.builder().addLine("time", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.TIME.getAsSprite(16, 16)));
            line.add(new DLCreateSelectionScrollInput(context.container().getParentScreen(), line.getCurrentX() + 6, line.y() + 2, 32, 18)).setRenderArrow(true).forOptions(Arrays.stream(ETimeDisplay.values()).map(x -> TextUtils.translate((String)x.getValueInfoTranslationKey("createrailwaysnavigator"))).toList()).titled(TextUtils.translate((String)"enum.createrailwaysnavigator.time_display")).addHint(TextUtils.translate((String)"enum.createrailwaysnavigator.time_display.description")).format(val -> TextUtils.translate((String)ETimeDisplay.getById(val).getValueTranslationKey("createrailwaysnavigator"))).setState((int)setting.getTimeDisplay().getId()).calling(i -> setting.setTimeDisplay(ETimeDisplay.getById(i)));
        });
    }

    static void buildTrainNameGui(ITrainNameWidthSetting setting, GuiBuilderContext context, boolean allowAuto, boolean allowMax) {
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            line.add(new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18)).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width.description")).withRange(0 - (allowAuto ? 1 : 0), 100 + (allowMax ? 1 : 0)).withShiftStep(5).setState((int)setting.getTrainNameWidth()).format(val -> {
                if (val < 0) {
                    return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto");
                }
                if (val >= 100) {
                    return TextUtils.translate((String)"gui.createrailwaysnavigator.common.max");
                }
                return TextUtils.text((String)(String.valueOf(val) + "px"));
            }).calling(i -> setting.setTrainNameWidth(i.byteValue()));
        });
    }

    static void buildTrainTextGui(ITrainTextSetting setting, GuiBuilderContext context) {
        context.builder().addLine("train_text", line -> {
            line.add(new IconSlotWidget(line.getCurrentX(), line.y() + 2, ModGuiIcons.TEXT.getAsSprite(16, 16)));
            line.add(new DLCreateSelectionScrollInput(context.container().getParentScreen(), line.getCurrentX() + 6, line.y() + 2, line.getRemainingWidth() - 6, 18)).setRenderArrow(true).forOptions(Arrays.stream(ITrainTextSetting.ETrainTextComponents.values()).map(x -> TextUtils.translate((String)x.getValueTranslationKey("createrailwaysnavigator"))).toList()).titled(TextUtils.translate((String)"enum.createrailwaysnavigator.train_text_components")).addHint(TextUtils.translate((String)"enum.createrailwaysnavigator.train_text_components.description")).format(val -> TextUtils.translate((String)ITrainTextSetting.ETrainTextComponents.getById(val).getValueTranslationKey("createrailwaysnavigator"))).setState((int)setting.getTrainTextComponents().getId()).calling(i -> setting.setTrainTextComponents(ITrainTextSetting.ETrainTextComponents.getById(i)));
        });
    }

    public static void buildPlatformDisplayFocusGui(PlatformDisplayFocusSettings setting, GuiBuilderContext context) {
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            line.add(new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18)).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width_table")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width.description")).withRange(-1, 100).withShiftStep(5).setState((int)setting.getTrainNameWidth()).format(val -> {
                if (val < 0) {
                    return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto");
                }
                if (val >= 100) {
                    return TextUtils.translate((String)"gui.createrailwaysnavigator.common.max");
                }
                return TextUtils.text((String)(String.valueOf(val) + "px"));
            }).calling(i -> setting.setTrainNameWidth(i.byteValue()));
        });
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            line.add(new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18)).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width_table")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width.description")).withRange(-1, 65).withShiftStep(4).setState((int)setting.getPlatformWidth()).format(val -> {
                if (val >= 0) {
                    return TextUtils.text((String)(String.valueOf(val) + "px"));
                }
                return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto");
            }).calling(i -> setting.setPlatformWidth(i.byteValue()));
        });
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            line.add(new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18)).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width_next")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.train_name_width.description")).withRange(-1, 100).withShiftStep(5).setState((int)setting.getTrainNameWidthNextStop()).format(val -> {
                if (val < 0) {
                    return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto");
                }
                if (val >= 100) {
                    return TextUtils.translate((String)"gui.createrailwaysnavigator.common.max");
                }
                return TextUtils.text((String)(String.valueOf(val) + "px"));
            }).calling(i -> setting.setTrainNameWidthNextStop(i.byteValue()));
        });
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            line.add(new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18)).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width_next")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.platform_width.description")).withRange(-1, 65).withShiftStep(4).setState((int)setting.getPlatformWidthNextStop()).format(val -> {
                if (val >= 0) {
                    return TextUtils.text((String)(String.valueOf(val) + "px"));
                }
                return TextUtils.translate((String)"gui.createrailwaysnavigator.common.auto");
            }).calling(i -> setting.setPlatformWidthNextStop(i.byteValue()));
        });
    }

    public static void buildDepartureBoardTableGui(DepartureBoardDisplayTableSettings setting, GuiBuilderContext context) {
        Single.MutableSingle stopovers = new Single.MutableSingle(null);
        Single.MutableSingle info = new Single.MutableSingle(null);
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            stopovers.setFirst((Object)new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.stopovers_width")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.stopovers_width.description")).withRange(0, 101).withShiftStep(5).setState((int)(setting.getStopoversWidthPercentage() * 100.0f)).format(val -> TextUtils.text((String)(String.valueOf(val) + "%"))).calling(i -> {
                setting.setStopoversWidthPercentageInt(i.byteValue());
                DLUtils.doIfNotNull((Object)((ScrollInput)info.getFirst()), x -> x.withRange(0, MathUtils.clamp((int)(101 - i), (int)0, (int)101)));
            }));
            line.add((ScrollInput)stopovers.getFirst());
            if (stopovers.getFirst() != null && info.getFirst() != null) {
                ((ScrollInput)stopovers.getFirst()).withRange(0, MathUtils.clamp((int)(101 - ((ScrollInput)info.getFirst()).getState()), (int)0, (int)101));
                ((ScrollInput)info.getFirst()).withRange(0, MathUtils.clamp((int)(101 - ((ScrollInput)stopovers.getFirst()).getState()), (int)0, (int)101));
            }
        });
        context.builder().addToLine("text_width", line -> {
            int w = (line.getWidth() - 22) / 4 - 3;
            info.setFirst((Object)new DLCreateScrollInput(context.container().getParentScreen(), line.getCurrentX() + 4, line.y() + 2, w, 18).titled(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.info_width")).addHint(TextUtils.translate((String)"gui.createrailwaysnavigator.display_source.advanced_display.info_width.description")).withRange(0, 101).withShiftStep(5).setState((int)(setting.getInfoWidthPercentage() * 100.0f)).format(val -> TextUtils.text((String)(String.valueOf(val) + "%"))).calling(i -> {
                setting.setInfoWidthPercentageInt(i.byteValue());
                DLUtils.doIfNotNull((Object)((ScrollInput)stopovers.getFirst()), x -> x.withRange(0, MathUtils.clamp((int)(101 - i), (int)0, (int)101)));
            }));
            line.add((ScrollInput)info.getFirst());
            if (stopovers.getFirst() != null && info.getFirst() != null) {
                ((ScrollInput)stopovers.getFirst()).withRange(0, MathUtils.clamp((int)(101 - ((ScrollInput)info.getFirst()).getState()), (int)0, (int)101));
                ((ScrollInput)info.getFirst()).withRange(0, MathUtils.clamp((int)(101 - ((ScrollInput)stopovers.getFirst()).getState()), (int)0, (int)101));
            }
        });
    }
}

