/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.GuiBuilderWrapper;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowArrivalSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;

public class PlatformDisplayFocusSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
ITrainNameWidthSetting,
IPlatformWidthSetting,
IShowArrivalSetting,
IShowLineColorSetting {
    public static final String NBT_TRAIN_NAME_WIDTH_NEXT_STOP = "TrainNameWidthNextStop";
    public static final String NBT_PLATFORM_WIDTH_NEXT_STOP = "PlatformWidthNextStop";
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected byte trainNameWidth = (byte)12;
    protected byte trainNameWidthNextStop = (byte)-1;
    protected byte platformWidth = (byte)-1;
    protected byte platformWidthNextStop = (byte)-1;
    protected boolean showArrival = true;
    protected boolean showTrainLineColor = false;

    @Override
    public void deserializeNbt(class_2487 nbt) {
        super.deserializeNbt(nbt);
        if (nbt.method_10545("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.method_10571("TimeDisplay"));
        }
        if (nbt.method_10545("TrainNameWidth")) {
            this.trainNameWidth = nbt.method_10571("TrainNameWidth");
        }
        if (nbt.method_10545(NBT_TRAIN_NAME_WIDTH_NEXT_STOP)) {
            this.trainNameWidthNextStop = nbt.method_10571(NBT_TRAIN_NAME_WIDTH_NEXT_STOP);
        }
        if (nbt.method_10545("PlatformWidth")) {
            this.platformWidth = nbt.method_10571("PlatformWidth");
        }
        if (nbt.method_10545(NBT_PLATFORM_WIDTH_NEXT_STOP)) {
            this.platformWidthNextStop = nbt.method_10571(NBT_PLATFORM_WIDTH_NEXT_STOP);
        }
        if (nbt.method_10545("ShowArrival")) {
            this.showArrival = nbt.method_10577("ShowArrival");
        }
        if (nbt.method_10545("ShowLineColor")) {
            this.showTrainLineColor = nbt.method_10577("ShowLineColor");
        }
    }

    @Override
    public void serializeNbt(class_2487 nbt) {
        super.serializeNbt(nbt);
        nbt.method_10567("TimeDisplay", this.timeDisplay.getId());
        nbt.method_10567("TrainNameWidth", this.trainNameWidth);
        nbt.method_10567(NBT_TRAIN_NAME_WIDTH_NEXT_STOP, this.trainNameWidthNextStop);
        nbt.method_10567("PlatformWidth", this.platformWidth);
        nbt.method_10567(NBT_PLATFORM_WIDTH_NEXT_STOP, this.platformWidthNextStop);
        nbt.method_10556("ShowArrival", this.showArrival);
        nbt.method_10556("ShowLineColor", this.showTrainLineColor);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildBasicTextWidthGui(context);
        GuiBuilderWrapper.buildPlatformDisplayFocusGui(this, context);
        this.buildShowArrivalGui(context);
        this.buildShowLineColorGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyTrainNameSetting(oldSettings);
        this.copyPlatformWidthSetting(oldSettings);
        this.copyShowArrivalSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
        if (oldSettings instanceof PlatformDisplayFocusSettings) {
            PlatformDisplayFocusSettings o = (PlatformDisplayFocusSettings)oldSettings;
            this.setTrainNameWidthNextStop(o.getTrainNameWidthNextStop());
        }
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public byte getPlatformWidth() {
        return this.platformWidth;
    }

    @Override
    public void setPlatformWidth(byte b) {
        this.platformWidth = b;
    }

    public byte getPlatformWidthNextStop() {
        return this.platformWidthNextStop;
    }

    public void setPlatformWidthNextStop(byte b) {
        this.platformWidthNextStop = b;
    }

    @Override
    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    @Override
    public void setTrainNameWidth(byte b) {
        this.trainNameWidth = b;
    }

    public byte getTrainNameWidthNextStop() {
        return this.trainNameWidthNextStop;
    }

    public void setTrainNameWidthNextStop(byte b) {
        this.trainNameWidthNextStop = b;
    }

    @Override
    public boolean showArrival() {
        return this.showArrival;
    }

    @Override
    public void setShowArrival(boolean b) {
        this.showArrival = b;
    }

    public boolean isAutoTrainNameWidthNextStop() {
        return this.getTrainNameWidthNextStop() < 0;
    }

    public boolean isAutoPlatformWidthNextStop() {
        return this.getPlatformWidthNextStop() < 0;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showTrainLineColor = b;
    }

    @Override
    public boolean showLineColor() {
        return this.showTrainLineColor;
    }
}

