/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.ICarriageIndexSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowExitDirectionSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowNextConnections;
import de.mrjulsen.crn.block.display.properties.components.IShowTrainStatsSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainTextSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;

public class PassengerInformationDetailedSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
IShowTrainStatsSetting,
IShowExitDirectionSetting,
ICarriageIndexSetting,
IShowNextConnections,
ITrainTextSetting {
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected boolean showStats = true;
    protected boolean showExit = true;
    protected boolean showConnections = true;
    protected byte carriageIndexOffset = 0;
    protected boolean overwriteCarriageIndex = false;
    protected ITrainTextSetting.ETrainTextComponents trainTextComponents = ITrainTextSetting.ETrainTextComponents.TRAIN_NAME;

    @Override
    public void deserializeNbt(class_2487 nbt) {
        super.deserializeNbt(nbt);
        if (nbt.method_10545("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.method_10571("TimeDisplay"));
        }
        if (nbt.method_10545("ShowStats")) {
            this.showStats = nbt.method_10577("ShowStats");
        }
        if (nbt.method_10545("ShowExit")) {
            this.showExit = nbt.method_10577("ShowExit");
        }
        if (nbt.method_10545("ShowConnections")) {
            this.showConnections = nbt.method_10577("ShowConnections");
        }
        if (nbt.method_10545("CarriageIndexOffset")) {
            this.carriageIndexOffset = nbt.method_10571("CarriageIndexOffset");
        }
        if (nbt.method_10545("OverwriteCarriageIndex")) {
            this.overwriteCarriageIndex = nbt.method_10577("OverwriteCarriageIndex");
        }
        if (nbt.method_10545("TrainText")) {
            this.trainTextComponents = ITrainTextSetting.ETrainTextComponents.getById(nbt.method_10571("TrainText"));
        }
    }

    @Override
    public void serializeNbt(class_2487 nbt) {
        super.serializeNbt(nbt);
        nbt.method_10567("TimeDisplay", this.timeDisplay.getId());
        nbt.method_10556("ShowStats", this.showStats);
        nbt.method_10556("ShowExit", this.showExit);
        nbt.method_10556("ShowConnections", this.showConnections);
        nbt.method_10567("CarriageIndexOffset", this.carriageIndexOffset);
        nbt.method_10556("OverwriteCarriageIndex", this.overwriteCarriageIndex);
        nbt.method_10567("TrainText", this.trainTextComponents.getId());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildShowStatsGui(context);
        this.buildShowExitGui(context);
        this.buildShowConnectionGui(context);
        this.buildCarriageIndexGui(context);
        this.buildTrainTextGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyShowExitSetting(oldSettings);
        this.copyShowStatsSetting(oldSettings);
        this.copyShowConnectionSetting(oldSettings);
        this.copyCarriageIndexSetting(oldSettings);
    }

    @Override
    public boolean showStats() {
        return this.showStats;
    }

    @Override
    public void setShowStats(boolean b) {
        this.showStats = b;
    }

    @Override
    public boolean showExit() {
        return this.showExit;
    }

    @Override
    public void setShowExit(boolean b) {
        this.showExit = b;
    }

    @Override
    public boolean showConnections() {
        return this.showConnections;
    }

    @Override
    public void setShowConnection(boolean b) {
        this.showConnections = b;
    }

    @Override
    public byte getCarriageIndex() {
        return this.carriageIndexOffset;
    }

    @Override
    public boolean shouldOverwriteCarriageIndex() {
        return this.overwriteCarriageIndex;
    }

    @Override
    public void setCarriageIndex(byte b) {
        this.carriageIndexOffset = b;
    }

    @Override
    public void setOverwriteCarriageIndex(boolean b) {
        this.overwriteCarriageIndex = b;
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public ITrainTextSetting.ETrainTextComponents getTrainTextComponents() {
        return this.trainTextComponents;
    }

    @Override
    public void setTrainTextComponents(ITrainTextSetting.ETrainTextComponents v) {
        this.trainTextComponents = v;
    }
}

