/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayBoardTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.data.storage.GlobalSettings;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.event.ModCommonEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_5250;

public class AdvancedDisplayTarget
extends DisplayBoardTarget {
    private static boolean running = false;
    private static boolean threadRunning = false;
    private static final Queue<Runnable> workerTasks = new ConcurrentLinkedQueue<Runnable>();

    public static void start() {
        if (running) {
            AdvancedDisplayTarget.stop();
        }
        while (running && threadRunning) {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        workerTasks.clear();
        running = true;
        new Thread(() -> {
            threadRunning = true;
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been started.");
            while (running) {
                while (!workerTasks.isEmpty()) {
                    try {
                        workerTasks.poll().run();
                    }
                    catch (Exception e) {
                        CreateRailwaysNavigator.LOGGER.info("Error while process Advanced Display Data. " + e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            workerTasks.clear();
            CreateRailwaysNavigator.LOGGER.info("Advanced Display Data Manager has been stopped.");
            threadRunning = false;
        }, "Advanced Display Data Manager").start();
    }

    public static void stop() {
        CreateRailwaysNavigator.LOGGER.info("Stopping Advanced Display Data Manager...");
        running = false;
    }

    private static void queueAdvancedDisplayWorkerTask(Runnable task) {
        workerTasks.add(task);
    }

    public void acceptFlapText(int line, List<List<class_5250>> text, DisplayLinkContext context) {
        class_2487 nbt = context.sourceConfig();
        if (!nbt.method_10545("AdvancedDisplay")) {
            return;
        }
        class_2586 class_25862 = context.getTargetBlockEntity();
        if (class_25862 instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity blockEntity = (AdvancedDisplayBlockEntity)class_25862;
            if (ModCommonEvents.hasServer()) {
                AdvancedDisplayBlockEntity controller = blockEntity.getController();
                long dayTime = context.getTargetBlockEntity().method_10997().method_8532();
                AdvancedDisplayTarget.queueAdvancedDisplayWorkerTask(() -> {
                    if (controller != null && controller.getDisplayType().category().getSource() == EDisplayType.EDisplayTypeDataSource.PLATFORM) {
                        String filter = context.sourceConfig().method_10558("Filter");
                        List<StationDisplayData> preds = AdvancedDisplayTarget.prepare(filter, controller.getDisplayProperties().platformDisplayTrainsCount().apply(controller));
                        controller.setDepartureData(preds, filter, GlobalSettings.getInstance().getOrCreateStationTagFor(filter).getInfoForStation(filter), dayTime);
                        ModCommonEvents.getCurrentServer().get().method_40000(() -> ((AdvancedDisplayBlockEntity)controller).sendData());
                    }
                });
            }
        }
    }

    public static List<StationDisplayData> prepare(String filter, int maxLines) {
        ArrayList<StationDisplayData> result = new ArrayList<StationDisplayData>(maxLines);
        int i = 0;
        for (TrainStop stop : TrainUtils.getDeparturesAtStationName(filter, null)) {
            result.add(StationDisplayData.of(stop));
            if (++i < maxLines) continue;
            break;
        }
        return result;
    }

    public boolean isReserved(int line, class_2586 target, DisplayLinkContext context) {
        return super.isReserved(line, target, context) || target instanceof AdvancedDisplayBlockEntity;
    }

    public DisplayTargetStats provideStats(DisplayLinkContext context) {
        AdvancedDisplayBlockEntity controller = this.getController(context);
        if (controller == null) {
            return new DisplayTargetStats(1, 1, (DisplayTarget)this);
        }
        return new DisplayTargetStats(1, 1, (DisplayTarget)this);
    }

    private AdvancedDisplayBlockEntity getController(DisplayLinkContext context) {
        class_2586 teIn = context.getTargetBlockEntity();
        if (!(teIn instanceof AdvancedDisplayBlockEntity)) {
            return null;
        }
        AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)teIn;
        return be.getController();
    }

    public class_238 getMultiblockBounds(class_1936 level, class_2338 pos) {
        class_238 baseShape = super.getMultiblockBounds(level, pos);
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof AdvancedDisplayBlockEntity)) {
            return baseShape;
        }
        AdvancedDisplayBlockEntity fdbe = (AdvancedDisplayBlockEntity)be;
        AdvancedDisplayBlockEntity controller = fdbe.getController();
        if (controller == null) {
            return baseShape;
        }
        class_2382 normal = controller.getDirection().method_10170().method_10163();
        return baseShape.method_996(controller.method_11016().method_10059((class_2382)pos)).method_1012((double)(normal.method_10263() * (controller.getXSize() - 1)), (double)(1 - controller.getYSize()), (double)(normal.method_10260() * (controller.getXSize() - 1)));
    }
}

