/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.blockentity;

import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import de.mrjulsen.crn.Constants;
import de.mrjulsen.crn.block.AbstractAdvancedDisplayBlock;
import de.mrjulsen.crn.block.blockentity.IContraptionBlockEntity;
import de.mrjulsen.crn.block.blockentity.IMultiblockBlockEntity;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.properties.EDisplayInfo;
import de.mrjulsen.crn.block.properties.EDisplayType;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.AdvancedDisplaysRegistry;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.data.CarriageData;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.portable.StationDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.registry.ModDisplayTypes;
import de.mrjulsen.mcdragonlib.block.IBERInstance;
import de.mrjulsen.mcdragonlib.client.ber.IBlockEntityRendererInstance;
import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import de.mrjulsen.mcdragonlib.util.ListUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class AdvancedDisplayBlockEntity
extends SmartBlockEntity
implements IMultiblockBlockEntity<AdvancedDisplayBlockEntity, AbstractAdvancedDisplayBlock>,
IContraptionBlockEntity<AdvancedDisplayBlockEntity>,
IBERInstance<AdvancedDisplayBlockEntity> {
    private static final String NBT_DISPLAY_TYPE_SETTINGS = "DisplaySettings";
    private static final String NBT_FILTER = "Filter";
    private static final String NBT_XSIZE = "XSize";
    private static final String NBT_YSIZE = "YSize";
    private static final String NBT_CONTROLLER = "IsController";
    private static final String NBT_GLOWING = "Glowing";
    private static final String NBT_LAST_REFRESH_TIME = "LastRefreshed";
    private static final String NBT_TRAIN_STOPS = "TrainStops";
    @Deprecated
    private static final String LEGACY_NBT_PLATFORM_WIDTH = "PlatformWidth";
    @Deprecated
    private static final String LEGACY_NBT_TRAIN_NAME_WIDTH = "TrainNameWidth";
    @Deprecated
    private static final String LEGACY_NBT_COLOR = "Color";
    @Deprecated
    private static final String LEGACY_NBT_TIME_DISPLAY = "TimeDisplay";
    @Deprecated
    private static final String LEGACY_NBT_DISPLAY_TYPE_KEY = "DisplayTypeKey";
    @Deprecated
    private static final String LEGACY_NBT_INFO_TYPE = "InfoType";
    @Deprecated
    private static final String LEGACY_NBT_DISPLAY_TYPE = "DisplayType";
    public static final byte MAX_XSIZE = 16;
    public static final byte MAX_YSIZE = 16;
    private static final int REFRESH_FREQUENCY = 100;
    private AdvancedDisplaysRegistry.DisplayTypeResourceKey displayTypeId = ModDisplayTypes.TRAIN_DESTINATION_SIMPLE;
    private byte xSize = 1;
    private byte ySize = 1;
    private boolean isController;
    private List<StationDisplayData> predictions;
    private boolean dataOrderChanged = false;
    private String stationNameFilter;
    private StationTag.StationInfo stationInfo;
    private boolean glowing = false;
    private IDisplaySettings displayTypeSettings = AdvancedDisplaysRegistry.createSettings(ModDisplayTypes.TRAIN_DESTINATION_SIMPLE);
    private long lastRefreshedTime;
    private TrainDisplayData trainData = TrainDisplayData.empty();
    private CarriageData carriageData = new CarriageData(0, class_2350.field_11043, false);
    private int syncTicks = 99;
    private final Cache<IBlockEntityRendererInstance<AdvancedDisplayBlockEntity>> renderer = new Cache(() -> new AdvancedDisplayRenderInstance(this), ECachingPriority.ALWAYS);
    public final Cache<TrainExitSide> relativeExitDirection = new Cache(() -> {
        if (this.getCarriageData() == null || !this.getTrainData().getNextStop().isPresent() || !(this.method_11010().method_26204() instanceof AbstractAdvancedDisplayBlock)) {
            return TrainExitSide.UNKNOWN;
        }
        TrainExitSide side = this.getTrainData().getNextStopExitSide();
        class_2350 blockFacing = (class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177);
        if (!this.carriageData.isOppositeDirection()) {
            blockFacing = blockFacing.method_10153();
        }
        TrainExitSide result = side;
        if (this.getCarriageData().assemblyDirection() == blockFacing) {
            result = result.getOpposite();
        } else if (this.getCarriageData().assemblyDirection().method_10153() != blockFacing) {
            result = TrainExitSide.UNKNOWN;
        }
        return result;
    });
    public final Cache<Tripple<Float, Float, Float>> renderRotation = new Cache(() -> {
        class_2248 patt0$temp = this.method_11010().method_26204();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            return block.getRenderRotation(this.field_11863, this.method_11010(), this.field_11867);
        }
        return Tripple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderOffset = new Cache(() -> {
        class_2248 patt0$temp = this.method_11010().method_26204();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            return block.getRenderOffset(this.field_11863, this.method_11010(), this.field_11867);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderZOffset = new Cache(() -> {
        class_2248 patt0$temp = this.method_11010().method_26204();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            return block.getRenderZOffset(this.field_11863, this.method_11010(), this.field_11867);
        }
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    });
    public final Cache<Pair<Float, Float>> renderAspectRatio = new Cache(() -> {
        class_2248 patt0$temp = this.method_11010().method_26204();
        if (patt0$temp instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)patt0$temp;
            Pair<Float, Float> raw = block.getRenderAspectRatio(this.field_11863, this.method_11010(), this.field_11867);
            float scale = 1.0f / Math.min(((Float)raw.getFirst()).floatValue(), ((Float)raw.getSecond()).floatValue());
            return Pair.of((Object)Float.valueOf(((Float)raw.getFirst()).floatValue() * scale), (Object)Float.valueOf(((Float)raw.getSecond()).floatValue() * scale));
        }
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    });
    public final Cache<Float> renderScale = new Cache(() -> Float.valueOf(1.0f / Math.max(((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue(), ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue())));

    public AdvancedDisplayBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.reset();
    }

    public TrainDisplayData getTrainData() {
        return this.trainData;
    }

    public CarriageData getCarriageData() {
        return this.carriageData;
    }

    public long getLastRefreshedTime() {
        return this.lastRefreshedTime;
    }

    public byte getXSize() {
        return this.xSize;
    }

    public byte getXSizeScaled() {
        return (byte)((float)this.getXSize() * ((Float)((Pair)this.renderAspectRatio.get()).getFirst()).floatValue());
    }

    public byte getYSize() {
        return this.ySize;
    }

    public byte getYSizeScaled() {
        return (byte)((float)this.getYSize() * ((Float)((Pair)this.renderAspectRatio.get()).getSecond()).floatValue());
    }

    @Override
    public boolean isController() {
        return this.isController;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public AdvancedDisplaysRegistry.DisplayTypeResourceKey getDisplayType() {
        return this.displayTypeId;
    }

    @Override
    public byte getMaxWidth() {
        return 16;
    }

    @Override
    public byte getMaxHeight() {
        return 16;
    }

    @Override
    public byte getWidth() {
        return this.xSize;
    }

    @Override
    public byte getHeight() {
        return this.ySize;
    }

    @Override
    public Class<AbstractAdvancedDisplayBlock> getBlockType() {
        return AbstractAdvancedDisplayBlock.class;
    }

    @Override
    public Class<AdvancedDisplayBlockEntity> getBlockEntityType() {
        return AdvancedDisplayBlockEntity.class;
    }

    public List<StationDisplayData> getStops() {
        return this.predictions;
    }

    public boolean isPlatformFixed() {
        return !this.stationNameFilter.contains("*");
    }

    public StationTag.StationInfo getStationInfo() {
        return this.stationInfo;
    }

    public String getStationNameFilter() {
        return this.stationNameFilter;
    }

    public boolean isSingleLine() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof AbstractAdvancedDisplayBlock) {
            AbstractAdvancedDisplayBlock block = (AbstractAdvancedDisplayBlock)class_22482;
            return block.isSingleLined() || AdvancedDisplaysRegistry.getProperties(this.displayTypeId).singleLined();
        }
        return false;
    }

    public AdvancedDisplaysRegistry.DisplayProperties getDisplayProperties() {
        return AdvancedDisplaysRegistry.getProperties(this.displayTypeId);
    }

    public void setGlowing(boolean glowing) {
        this.glowing = glowing;
        if (this.field_11863.field_9236) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, (Object)EUpdateReason.LAYOUT_CHANGED);
        }
    }

    public void setDisplayType(AdvancedDisplaysRegistry.DisplayTypeResourceKey key, @Nullable IDisplaySettings settings) {
        this.displayTypeId = key;
        this.displayTypeSettings = settings;
        if (this.field_11863.field_9236) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, (Object)EUpdateReason.LAYOUT_CHANGED);
        }
    }

    public void setDepartureData(List<StationDisplayData> predictions, String stationNameFilter, StationTag.StationInfo staionInfo, long lastRefreshedTime) {
        this.dataOrderChanged = this.dataOrderChanged || !ListUtils.compareCollections(this.predictions, predictions, StationDisplayData::equals);
        boolean clientUpdate = Platform.getEnv() == EnvType.CLIENT && !this.getStationInfo().equals(staionInfo);
        this.predictions = predictions;
        this.stationNameFilter = stationNameFilter;
        this.stationInfo = staionInfo;
        this.lastRefreshedTime = lastRefreshedTime;
        if (clientUpdate) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, (Object)EUpdateReason.DATA_CHANGED);
        }
    }

    @Override
    public boolean connectable(class_1922 getter, class_2338 a, class_2338 b) {
        if (getter == null || a == null || b == null) {
            return false;
        }
        class_2586 class_25862 = getter.method_8321(a);
        if (class_25862 instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity be1 = (AdvancedDisplayBlockEntity)class_25862;
            class_25862 = getter.method_8321(b);
            if (class_25862 instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be2 = (AdvancedDisplayBlockEntity)class_25862;
                class_25862 = be1.method_11010().method_26204();
                if (class_25862 instanceof AbstractAdvancedDisplayBlock) {
                    AbstractAdvancedDisplayBlock block1 = (AbstractAdvancedDisplayBlock)class_25862;
                    class_25862 = be2.method_11010().method_26204();
                    if (class_25862 instanceof AbstractAdvancedDisplayBlock) {
                        AbstractAdvancedDisplayBlock block2 = (AbstractAdvancedDisplayBlock)class_25862;
                        return block1 == block2 && be1.getDisplayType().equals(be2.getDisplayType()) && block1.canConnectWithBlock(getter, getter.method_8320(a), getter.method_8320(b)) && block2.canConnectWithBlock(getter, getter.method_8320(b), getter.method_8320(a)) && (!a.method_10084().equals((Object)b) || (Boolean)be1.method_11010().method_11654((class_2769)AbstractAdvancedDisplayBlock.UP) != false && !be1.isSingleLine()) && (!a.method_10074().equals((Object)b) || (Boolean)be1.method_11010().method_11654((class_2769)AbstractAdvancedDisplayBlock.DOWN) != false && !be1.isSingleLine());
                    }
                }
            }
        }
        return false;
    }

    public AdvancedDisplayBlockEntity getController() {
        AdvancedDisplayBlockEntity flap;
        class_2586 found;
        int i;
        if (this.isController()) {
            return this;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof AbstractAdvancedDisplayBlock)) {
            return null;
        }
        class_2338.class_2339 pos = this.method_11016().method_25503();
        class_2350 side = ((class_2350)blockState.method_11654((class_2769)AbstractAdvancedDisplayBlock.FACING)).method_10170();
        for (i = 0; i < this.getMaxWidth(); ++i) {
            if (!this.connectable((class_1922)this.field_11863, (class_2338)pos, pos.method_10093(side))) {
                found = this.field_11863.method_8321((class_2338)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity) || !(flap = (AdvancedDisplayBlockEntity)found).isController()) break;
                return flap;
            }
            pos.method_10098(side);
        }
        for (i = 0; i < this.getMaxHeight(); ++i) {
            if (!this.connectable((class_1922)this.field_11863, (class_2338)pos, pos.method_10093(class_2350.field_11036))) {
                found = this.field_11863.method_8321((class_2338)pos);
                if (!(found instanceof AdvancedDisplayBlockEntity) || !(flap = (AdvancedDisplayBlockEntity)found).isController()) break;
                return flap;
            }
            pos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    public void copyFrom(AdvancedDisplayBlockEntity other) {
        if (this.getDisplayType().equals(other.getDisplayType()) && this.isGlowing() == other.isGlowing()) {
            return;
        }
        this.glowing = other.isGlowing();
        this.displayTypeId = other.getDisplayType();
        this.displayTypeSettings = other.getSettings();
        this.notifyUpdate();
    }

    public void reset() {
        this.dataOrderChanged = true;
        this.predictions = List.of();
        this.stationNameFilter = "";
        this.xSize = 1;
        this.ySize = 1;
        this.isController = false;
        this.stationInfo = StationTag.StationInfo.empty();
    }

    public void updateControllerStatus() {
        if (this.field_11863.field_9236) {
            return;
        }
        class_2680 blockState = this.method_11010();
        if (!(blockState.method_26204() instanceof AbstractAdvancedDisplayBlock)) {
            return;
        }
        class_2350 leftDirection = ((class_2350)blockState.method_11654((class_2769)AbstractAdvancedDisplayBlock.FACING)).method_10170();
        boolean shouldBeController = !this.connectable((class_1922)this.field_11863, this.field_11867, this.field_11867.method_10093(leftDirection)) && !this.connectable((class_1922)this.field_11863, this.field_11867, this.field_11867.method_10084());
        int newXSize = 1;
        byte newYSize = 1;
        if (shouldBeController) {
            class_2338 relPos;
            for (int xOffset = 1; xOffset < this.getMaxWidth() && this.field_11863.method_8320(relPos = this.field_11867.method_10079(leftDirection.method_10153(), xOffset)) == blockState; ++xOffset) {
                newXSize = (byte)(newXSize + 1);
            }
            if (!this.isSingleLine()) {
                for (int yOffset = 0; yOffset < this.getMaxHeight(); ++yOffset) {
                    class_2338 downPos = this.field_11867.method_10079(class_2350.field_11033, yOffset);
                    for (int i = 0; i < newXSize; ++i) {
                        AdvancedDisplayBlockEntity be;
                        class_2338 relPos2 = downPos.method_10079(leftDirection.method_10153(), i);
                        class_2586 class_25862 = this.field_11863.method_8321(relPos2);
                        if (!(class_25862 instanceof AdvancedDisplayBlockEntity) || (be = (AdvancedDisplayBlockEntity)class_25862) == this) continue;
                        be.copyFrom(this);
                    }
                    if (!this.connectable((class_1922)this.field_11863, downPos, downPos.method_10074())) break;
                    newYSize = (byte)(newYSize + 1);
                }
            }
        }
        if (this.isController == shouldBeController && newXSize == this.xSize && newYSize == this.ySize) {
            return;
        }
        this.isController = shouldBeController;
        this.xSize = newXSize;
        this.ySize = newYSize;
        if (!this.isController) {
            this.reset();
        }
        this.notifyUpdate();
    }

    public void tick() {
        if (this.field_11863.field_9236) {
            this.getRenderer().tick(this.field_11863, this.method_11016(), this.method_11010(), (class_2586)this);
        }
        super.tick();
        if (this.getDisplayType().category().getSource() != EDisplayType.EDisplayTypeDataSource.PLATFORM) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0 && this.field_11863.field_9236) {
            boolean shouldUpdate;
            boolean bl = shouldUpdate = this.getStops().size() > 0 || this.dataOrderChanged;
            if (shouldUpdate) {
                this.getRenderer().update(this.field_11863, this.method_11016(), this.method_11010(), (class_2586)this, (Object)(this.dataOrderChanged ? EUpdateReason.LAYOUT_CHANGED : EUpdateReason.DATA_CHANGED));
                this.dataOrderChanged = false;
            }
        }
    }

    public void lazyTick() {
        super.lazyTick();
        this.updateControllerStatus();
    }

    @Override
    public void contraptionTick(class_1937 level, class_2338 pos, class_2680 state, CarriageContraption carriage) {
        this.getRenderer().tick(level, pos, state, (class_2586)this);
        if (!this.isController()) {
            return;
        }
        if (this.getDisplayType().category().getSource() != EDisplayType.EDisplayTypeDataSource.TRAIN_INFORMATION) {
            return;
        }
        ++this.syncTicks;
        if ((this.syncTicks %= 100) == 0 && level.field_9236) {
            DataAccessor.getFromServer((Object)((CarriageContraptionEntity)carriage.entity).trainId, ModAccessorTypes.GET_TRAIN_DISPLAY_DATA_FROM_SERVER, data -> {
                boolean outOfService;
                if (data.isEmpty() && this.trainData.isEmpty()) {
                    return;
                }
                boolean shouldUpdate = false;
                if (this.trainData != null && this.trainData.getNextStop().isPresent() && data.getNextStop().isPresent()) {
                    TrainStopDisplayData prediction = this.trainData.getNextStop().get();
                    shouldUpdate = !this.trainData.getTrainData().getName().equals(data.getTrainData().getName()) || !prediction.getDestination().equals(data.getNextStop().get().getDestination()) || prediction.getStationEntryIndex() != data.getNextStop().get().getStationEntryIndex() || this.trainData.getNextStopExitSide() != data.getNextStopExitSide() || this.trainData.isWaitingAtStation() != data.isWaitingAtStation();
                }
                boolean bl = outOfService = this.trainData != null && !this.trainData.getTrainData().getId().equals(Constants.ZERO_UUID) && !data.getNextStop().isPresent();
                if (outOfService) {
                    shouldUpdate = true;
                }
                this.trainData = outOfService ? TrainDisplayData.empty() : data;
                this.carriageData = new CarriageData(((CarriageContraptionEntity)carriage.entity).carriageIndex, carriage.getAssemblyDirection(), data.isOppositeDirection());
                this.relativeExitDirection.clear();
                this.getRenderer().update(level, pos, state, (class_2586)this, (Object)(shouldUpdate ? EUpdateReason.LAYOUT_CHANGED : EUpdateReason.DATA_CHANGED));
            });
        }
    }

    protected void write(class_2487 pTag, boolean clientPacket) {
        super.write(pTag, clientPacket);
        pTag.method_10567(NBT_XSIZE, this.getXSize());
        pTag.method_10567(NBT_YSIZE, this.getYSize());
        pTag.method_10556(NBT_CONTROLLER, this.isController());
        pTag.method_10582(NBT_FILTER, this.getStationNameFilter());
        pTag.method_10556(NBT_GLOWING, this.isGlowing());
        pTag.method_10544(NBT_LAST_REFRESH_TIME, this.getLastRefreshedTime());
        this.displayTypeId.toNbt(pTag);
        pTag.method_10566(NBT_DISPLAY_TYPE_SETTINGS, (class_2520)this.displayTypeSettings.serializeNbt());
        this.getStationInfo().writeNbt(pTag);
        if (this.getStops() != null && !this.getStops().isEmpty()) {
            class_2499 list = new class_2499();
            for (StationDisplayData data : this.getStops()) {
                list.add((Object)data.toNbt());
            }
            pTag.method_10566(NBT_TRAIN_STOPS, (class_2520)list);
        }
    }

    public void read(class_2487 pTag, boolean clientPacket) {
        boolean updateClient = false;
        IDisplaySettings oldDisplayTypeSettings = this.displayTypeSettings;
        StationTag.StationInfo info = StationTag.StationInfo.fromNbt(pTag);
        if (this.field_11863 != null && this.method_11010() != null && this.field_11863.field_9236 && (this.isController() != pTag.method_10577(NBT_CONTROLLER) || this.getXSize() != pTag.method_10571(NBT_XSIZE) || this.getYSize() != pTag.method_10571(NBT_YSIZE) || !this.getStationInfo().equals(info) || this.getStops().isEmpty() ^ !pTag.method_10545(NBT_TRAIN_STOPS))) {
            updateClient = true;
        }
        super.read(pTag, clientPacket);
        this.xSize = pTag.method_10571(NBT_XSIZE);
        this.ySize = pTag.method_10571(NBT_YSIZE);
        this.glowing = pTag.method_10577(NBT_GLOWING);
        this.isController = pTag.method_10577(NBT_CONTROLLER);
        Class<?> oldDisplaySettings = this.displayTypeSettings.getClass();
        AdvancedDisplaysRegistry.DisplayTypeResourceKey oldDisplayType = this.displayTypeId;
        if (pTag.method_10545(LEGACY_NBT_INFO_TYPE) && pTag.method_10545(LEGACY_NBT_DISPLAY_TYPE)) {
            this.displayTypeId = ModDisplayTypes.legacy_getKeyForType(EDisplayType.getTypeById(pTag.method_10550(LEGACY_NBT_DISPLAY_TYPE)), EDisplayInfo.getTypeById(pTag.method_10550(LEGACY_NBT_INFO_TYPE)));
            this.displayTypeSettings = AdvancedDisplaysRegistry.createSettings(this.displayTypeId);
        } else if (pTag.method_10545(LEGACY_NBT_DISPLAY_TYPE_KEY)) {
            this.displayTypeId = AdvancedDisplaysRegistry.DisplayTypeResourceKey.legacy_fromNbt(pTag.method_10562(LEGACY_NBT_DISPLAY_TYPE_KEY));
            this.displayTypeSettings = AdvancedDisplaysRegistry.createSettings(this.displayTypeId);
        } else {
            this.displayTypeId = AdvancedDisplaysRegistry.DisplayTypeResourceKey.fromNbt(pTag);
            this.displayTypeSettings = AdvancedDisplaysRegistry.createSettings(this.displayTypeId);
            this.displayTypeSettings.deserializeNbt(pTag.method_10562(NBT_DISPLAY_TYPE_SETTINGS));
        }
        if (this.field_11863 != null && this.field_11863.field_9236) {
            boolean bl = updateClient = updateClient || !oldDisplayTypeSettings.getClass().equals(this.displayTypeSettings.getClass());
        }
        if (pTag.method_10545(LEGACY_NBT_COLOR)) {
            this.getSettingsAs(BasicDisplaySettings.class).ifPresent(x -> x.setFontColor(pTag.method_10550(LEGACY_NBT_COLOR)));
        }
        if (this.displayTypeId.category().getSource() == EDisplayType.EDisplayTypeDataSource.PLATFORM) {
            if (pTag.method_10545(LEGACY_NBT_PLATFORM_WIDTH)) {
                this.getSettingsAs(IPlatformWidthSetting.class).ifPresent(x -> x.setPlatformWidth(pTag.method_10571(LEGACY_NBT_PLATFORM_WIDTH)));
            }
            if (pTag.method_10545(LEGACY_NBT_TRAIN_NAME_WIDTH)) {
                this.getSettingsAs(ITrainNameWidthSetting.class).ifPresent(x -> x.setTrainNameWidth(pTag.method_10571(LEGACY_NBT_TRAIN_NAME_WIDTH)));
            }
            if (pTag.method_10545(LEGACY_NBT_TIME_DISPLAY)) {
                this.getSettingsAs(ITimeDisplaySetting.class).ifPresent(x -> x.setTimeDisplay(ETimeDisplay.getById(pTag.method_10571(LEGACY_NBT_TIME_DISPLAY))));
            }
        }
        this.setDepartureData(pTag.method_10545(NBT_TRAIN_STOPS) ? new ArrayList<StationDisplayData>(pTag.method_10554(NBT_TRAIN_STOPS, 10).stream().map(x -> StationDisplayData.fromNbt((class_2487)x)).toList()) : new ArrayList(), pTag.method_10558(NBT_FILTER), info, pTag.method_10537(NBT_LAST_REFRESH_TIME));
        if (!(this.field_11863 == null || this.method_11010() == null || !this.field_11863.field_9236 || oldDisplaySettings.isInstance(this.displayTypeSettings) && oldDisplayType.equals(this.displayTypeId))) {
            updateClient = true;
        }
        if (updateClient) {
            this.getRenderer().update(this.field_11863, this.field_11867, this.method_11010(), (class_2586)this, (Object)EUpdateReason.LAYOUT_CHANGED);
        }
    }

    public class_238 getRenderBoundingBox() {
        class_238 aabb = new class_238(this.field_11867);
        if (!this.isController) {
            return aabb;
        }
        class_2382 normal = this.getDirection().method_10170().method_10163();
        return aabb.method_1012((double)(normal.method_10263() * this.getXSize()), (double)(-this.getYSize()), (double)(normal.method_10260() * this.getXSize()));
    }

    public class_2350 getDirection() {
        return this.method_11010().method_28500(FlapDisplayBlock.HORIZONTAL_FACING).orElse(class_2350.field_11035).method_10153();
    }

    public IBlockEntityRendererInstance<AdvancedDisplayBlockEntity> getRenderer() {
        return (IBlockEntityRendererInstance)this.renderer.get();
    }

    public IDisplaySettings getSettings() {
        return this.displayTypeSettings;
    }

    public <S> Optional<S> getSettingsAs(Class<S> clazz) {
        return Optional.ofNullable(clazz.isInstance(this.getSettings()) ? (Object)clazz.cast(this.getSettings()) : null);
    }

    protected class_238 createRenderBoundingBox() {
        class_238 aabb = new class_238(this.field_11867);
        if (!this.isController) {
            return aabb;
        }
        class_2382 normal = this.getDirection().method_10170().method_10163();
        return aabb.method_1012((double)(normal.method_10263() * this.xSize), (double)(-this.ySize), (double)(normal.method_10260() * this.xSize));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    public void onDataPacket(class_2535 net, class_2622 pkt) {
        this.method_11014(pkt.method_11290());
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 512);
    }

    public static enum EUpdateReason {
        LAYOUT_CHANGED,
        DATA_CHANGED;

    }
}

