/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.registry.ModBlockEntities;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_322;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6756;

public abstract class AbstractAdvancedDisplayBlock
extends class_2248
implements IWrenchable,
IBE<AdvancedDisplayBlockEntity> {
    public static final int DEFAULT_DISPLAY_COLOR = -12566464;
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2746 UP = class_2746.method_11825((String)"up");
    public static final class_2746 DOWN = class_2746.method_11825((String)"down");

    public AbstractAdvancedDisplayBlock(class_4970.class_2251 properties) {
        super(properties.method_31710(class_3620.field_16005));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    @Environment(value=EnvType.CLIENT)
    public static class_322 getDisplayColor() {
        return (state, world, pos, layer) -> {
            if (world == null || state == null || pos == null) {
                return -12566464;
            }
            class_2586 patt0$temp = world.method_8321(pos);
            if (patt0$temp instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)patt0$temp;
                return be.getSettingsAs(BasicDisplaySettings.class).map(x -> {
                    int color = x.getBackColor();
                    return color == 0 ? null : Integer.valueOf(color);
                }).orElse(-12566464);
            }
            return -12566464;
        };
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return (class_2680)pState.method_11657((class_2769)FACING, (Comparable)pRotation.method_10503((class_2350)pState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pState.method_26186(pMirror.method_10345((class_2350)pState.method_11654((class_2769)FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder);
        pBuilder.method_11667(new class_2769[]{UP, DOWN, FACING});
    }

    public class_2680 method_9605(class_1750 context) {
        class_2350 face = context.method_8038();
        class_2338 clickedPos = context.method_8037();
        class_2338 placedOnPos = clickedPos.method_10093(face.method_10153());
        class_1937 level = context.method_8045();
        class_2680 otherState = level.method_8320(placedOnPos);
        class_2680 stateForPlacement = (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
        stateForPlacement = otherState.method_26204() != this || context.method_8036() != null && context.method_8036().method_5715() ? this.getDefaultPlacementState(context, stateForPlacement, otherState) : this.appendOnPlace(context, stateForPlacement, otherState);
        return this.updateColumn(level, clickedPos, stateForPlacement, true);
    }

    public class_2680 appendOnPlace(class_1750 context, class_2680 state, class_2680 other) {
        class_2350 otherFacing = (class_2350)other.method_11654((class_2769)FACING);
        state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)otherFacing);
        return state;
    }

    public class_2680 getDefaultPlacementState(class_1750 context, class_2680 state, class_2680 other) {
        return (class_2680)super.method_9605(context).method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    protected class_2680 updateColumn(class_1937 level, class_2338 pos, class_2680 state, boolean present) {
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        class_2350.class_2351 axis = this.getConnectionAxis(state);
        for (class_2350 connection : Iterate.directionsInAxis((class_2350.class_2351)class_2350.class_2351.field_11052)) {
            boolean connect = true;
            block1: for (class_2350 movement : Iterate.directionsInAxis((class_2350.class_2351)axis)) {
                currentPos.method_10101((class_2382)pos);
                for (int i = 0; i < 1000 && level.method_8477((class_2338)currentPos); ++i) {
                    class_2338 otherPos = currentPos.method_10093(connection);
                    class_2680 other1 = currentPos.equals((Object)pos) ? state : level.method_8320((class_2338)currentPos);
                    class_2680 other2 = level.method_8320(otherPos);
                    boolean col1 = this.canConnect((class_1936)level, pos, state, other1);
                    boolean col2 = this.canConnect((class_1936)level, pos, state, other2);
                    currentPos.method_10098(movement);
                    if (!col1 && !col2) continue block1;
                    if (col1 && col2) continue;
                    connect = false;
                    break block1;
                }
            }
            state = AbstractAdvancedDisplayBlock.setConnection(state, connection, connect);
        }
        return state;
    }

    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        if (pOldState.method_26204() == this) {
            return;
        }
        class_6756 blockTicks = pLevel.method_8397();
        if (!blockTicks.method_8674(pPos, (Object)this)) {
            pLevel.method_39279(pPos, (class_2248)this, 1);
        }
        this.updateNeighbours(pState, pLevel, pPos);
        if (pLevel.field_9236) {
            this.withBlockEntityDo((class_1922)pLevel, pPos, be -> be.getController().getRenderer().update(pLevel, pPos, pState, (class_2586)be, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED));
        }
    }

    public <T extends Comparable<T>> class_2680 getPropertyFromNeighbours(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2769<T> property) {
        class_2350 leftDirection = ((class_2350)pState.method_11654((class_2769)class_2383.field_11177)).method_10170();
        class_2680 newState = null;
        class_2338 relPos = pPos.method_10093(leftDirection);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.method_10093(class_2350.field_11036);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.method_10093(leftDirection.method_10153());
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        relPos = pPos.method_10093(class_2350.field_11033);
        newState = this.getPropertyFromNeighbour(pState, pLevel, pPos, relPos, property);
        if (newState != null) {
            return newState;
        }
        return pState;
    }

    public <T extends Comparable<T>> class_2680 getPropertyFromNeighbour(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2338 relPos, class_2769<T> property) {
        if (this.canConnectWithBlock((class_1922)pLevel, pState, pLevel.method_8320(relPos))) {
            return (class_2680)pState.method_11657(property, pLevel.method_8320(relPos).method_11654(property));
        }
        return null;
    }

    public void updateNeighbours(class_2680 pState, class_1937 pLevel, class_2338 pPos) {
        class_2350 leftDirection = ((class_2350)pState.method_11654((class_2769)class_2383.field_11177)).method_10170();
        class_2338 relPos = pPos.method_10093(leftDirection);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.method_10093(class_2350.field_11036);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.method_10093(leftDirection.method_10153());
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
        relPos = pPos.method_10093(class_2350.field_11033);
        if (this.updateNeighbour(pState, pLevel, pPos, relPos)) {
            return;
        }
    }

    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, class_5819 pRandom) {
        if (pState.method_26204() != this) {
            return;
        }
        class_2338 belowPos = pPos.method_10093(class_2350.method_10169((class_2350.class_2351)this.getConnectionAxis(pState), (class_2350.class_2352)class_2350.class_2352.field_11060));
        class_2680 belowState = pLevel.method_8320(belowPos);
        if (!this.canConnect((class_1936)pLevel, pPos, pState, belowState)) {
            KineticBlockEntity.switchToBlockState((class_1937)pLevel, (class_2338)pPos, (class_2680)this.updateColumn((class_1937)pLevel, pPos, pState, true));
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 pDirection, class_2680 pNeighborState, class_1936 pLevel, class_2338 pCurrentPos, class_2338 pNeighborPos) {
        return this.updatedShapeInner(state, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    private class_2680 updatedShapeInner(class_2680 state, class_2350 pDirection, class_2680 pNeighborState, class_1936 pLevel, class_2338 pCurrentPos, class_2338 pNeighborPos) {
        if (!this.canConnect(pLevel, pCurrentPos, state, pNeighborState)) {
            return AbstractAdvancedDisplayBlock.setConnection(state, pDirection, false);
        }
        if (pDirection.method_10166() == this.getConnectionAxis(state)) {
            return this.applyPropertiesOf(state, pNeighborState);
        }
        return AbstractAdvancedDisplayBlock.setConnection(state, pDirection, AbstractAdvancedDisplayBlock.getConnection(pNeighborState, pDirection.method_10153()));
    }

    public class_2680 applyPropertiesOf(class_2680 current, class_2680 state) {
        class_2680 blockState = this.method_9564();
        for (class_2769 property : state.method_26204().method_9595().method_11659()) {
            if (!blockState.method_28498(property)) continue;
            if (this.getExcludedProperties().contains(property)) {
                blockState = AbstractAdvancedDisplayBlock.copyPropertyOf(current, blockState, property);
                continue;
            }
            blockState = AbstractAdvancedDisplayBlock.copyPropertyOf(state, blockState, property);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> class_2680 copyPropertyOf(class_2680 sourceState, class_2680 targetState, class_2769<T> property) {
        return (class_2680)targetState.method_11657(property, sourceState.method_11654(property));
    }

    protected boolean canConnect(class_1936 level, class_2338 pos, class_2680 state, class_2680 other) {
        return other.method_26204() == this && state.method_11654((class_2769)FACING) == other.method_11654((class_2769)FACING);
    }

    public boolean canConnectWithBlock(class_1922 level, class_2680 selfState, class_2680 otherState) {
        return selfState.method_26204() instanceof AbstractAdvancedDisplayBlock && otherState.method_26204() instanceof AbstractAdvancedDisplayBlock && selfState.method_26204() == otherState.method_26204() && selfState.method_11654((class_2769)FACING) == otherState.method_11654((class_2769)FACING);
    }

    protected class_2350.class_2351 getConnectionAxis(class_2680 state) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10170().method_10166();
    }

    public static boolean getConnection(class_2680 state, class_2350 side) {
        class_2746 property = side == class_2350.field_11033 ? DOWN : (side == class_2350.field_11036 ? UP : null);
        return property != null && (Boolean)state.method_11654((class_2769)property) != false;
    }

    public static class_2680 setConnection(class_2680 state, class_2350 side, boolean connect) {
        class_2746 property;
        Object object = side == class_2350.field_11033 ? DOWN : (property = side == class_2350.field_11036 ? UP : null);
        if (property != null) {
            state = (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(connect));
        }
        return state;
    }

    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        super.method_9536(pState, pLevel, pPos, pNewState, pIsMoving);
        if (pIsMoving || pNewState.method_26204() == this) {
            return;
        }
        for (class_2350 d : Iterate.directionsInAxis((class_2350.class_2351)this.getConnectionAxis(pState))) {
            class_2338 relative = pPos.method_10093(d);
            class_2680 adjacent = pLevel.method_8320(relative);
            if (!this.canConnect((class_1936)pLevel, pPos, pState, adjacent)) continue;
            KineticBlockEntity.switchToBlockState((class_1937)pLevel, (class_2338)relative, (class_2680)this.updateColumn(pLevel, relative, adjacent, false));
        }
    }

    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        class_1769 dyeItem;
        class_1767 dye;
        class_1799 heldItem = pPlayer.method_5998(pHand);
        AdvancedDisplayBlockEntity blockEntity = ((AdvancedDisplayBlockEntity)pLevel.method_8321(pPos)).getController();
        class_1792 class_17922 = heldItem.method_7909();
        if (class_17922 instanceof class_1769 && (dye = (dyeItem = (class_1769)class_17922).method_7802()) != null) {
            pLevel.method_8396(null, pPos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
            int dyeColor = dye == class_1767.field_7946 ? -26368 : dye.method_16357();
            blockEntity.applyToAll(be -> be.getSettingsAs(BasicDisplaySettings.class).ifPresent(x -> {
                if (pPlayer.method_5715()) {
                    x.setBackColor(dyeColor);
                } else {
                    x.setFontColor(dyeColor);
                }
                be.notifyUpdate();
            }));
            if (pLevel.field_9236) {
                blockEntity.getRenderer().update(pLevel, pPos, pState, (class_2586)blockEntity, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED);
            }
            return class_1269.field_5812;
        }
        if (heldItem.method_31574(class_1802.field_28410)) {
            pLevel.method_8396(null, pPos, class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
            blockEntity.applyToAll(be -> {
                be.setGlowing(true);
                be.notifyUpdate();
            });
            if (pLevel.field_9236) {
                blockEntity.getRenderer().update(pLevel, pPos, pState, (class_2586)blockEntity, (Object)AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    protected boolean updateNeighbour(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2338 neighbourPos) {
        class_2586 class_25862;
        if (pLevel.method_8320(neighbourPos).method_27852((class_2248)this) && (class_25862 = pLevel.method_8321(neighbourPos)) instanceof AdvancedDisplayBlockEntity) {
            AdvancedDisplayBlockEntity otherBe = (AdvancedDisplayBlockEntity)class_25862;
            class_25862 = pLevel.method_8321(pPos);
            if (class_25862 instanceof AdvancedDisplayBlockEntity) {
                AdvancedDisplayBlockEntity be = (AdvancedDisplayBlockEntity)class_25862;
                be.copyFrom(otherBe);
                return true;
            }
        }
        return false;
    }

    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        AdvancedDisplayBlockEntity be;
        AdvancedDisplayBlockEntity controller;
        class_2586 class_25862;
        class_1937 level = context.method_8045();
        if (level.field_9236 && (class_25862 = level.method_8321(context.method_8037())) instanceof AdvancedDisplayBlockEntity && (controller = (be = (AdvancedDisplayBlockEntity)class_25862).getController()) != null) {
            ClientWrapper.showAdvancedDisplaySettingsScreen(controller);
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public class_2464 method_9604(class_2680 pState) {
        return class_2464.field_11458;
    }

    public Class<AdvancedDisplayBlockEntity> getBlockEntityClass() {
        return AdvancedDisplayBlockEntity.class;
    }

    public class_2591<? extends AdvancedDisplayBlockEntity> getBlockEntityType() {
        return (class_2591)ModBlockEntities.ADVANCED_DISPLAY_BLOCK_ENTITY.get();
    }

    public abstract boolean isSingleLined();

    public abstract Tripple<Float, Float, Float> getRenderRotation(class_1937 var1, class_2680 var2, class_2338 var3);

    public abstract Pair<Float, Float> getRenderOffset(class_1937 var1, class_2680 var2, class_2338 var3);

    public abstract Pair<Float, Float> getRenderZOffset(class_1937 var1, class_2680 var2, class_2338 var3);

    public abstract Pair<Float, Float> getRenderAspectRatio(class_1937 var1, class_2680 var2, class_2338 var3);

    public Collection<class_2769<?>> getExcludedProperties() {
        return List.of();
    }
}

